/*
 * Decompiled with CFR 0.152.
 */
package ch.oldschoolsnit;

import ch.oldschoolsnit.OldSchoolSnitchClient;
import ch.oldschoolsnit.OldSchoolSnitchConfig;
import ch.oldschoolsnit.records.ItemDrop;
import ch.oldschoolsnit.records.NameSignIn;
import ch.oldschoolsnit.records.NpcKill;
import ch.oldschoolsnit.records.UserLocation;
import ch.oldschoolsnit.records.XpDrop;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.inject.Provides;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Skill;
import net.runelite.api.WorldType;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.PlayerChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.http.api.loottracker.LootRecordType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Old School Snitch")
public class OldSchoolSnitchPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(OldSchoolSnitchPlugin.class);
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private OldSchoolSnitchClient snitchClient;
    @Inject
    private OldSchoolSnitchConfig config;
    private final Map<Skill, Integer> previousSkillExpTable = new EnumMap<Skill, Integer>(Skill.class);
    private boolean NameSnatched = false;
    private static final Pattern WOOD_CUT_PATTERN = Pattern.compile("You get (?:some|an)[\\w ]+(?:logs?|mushrooms)\\.");
    private static final Pattern MINING_PATTERN = Pattern.compile("You (?:manage to|just) (?:mined?|quarry) (?:some|an?) (?:copper|tin|clay|iron|silver|coal|gold|mithril|adamantite|runeite|amethyst|sandstone|granite|barronite shards|barronite deposit|Opal|piece of Jade|Red Topaz|Emerald|Sapphire|Ruby|Diamond)(?:\\.|!)");
    private Multiset<Integer> previousInventorySnapshot;
    private Integer containerChangedCount = 0;
    private Integer pendingInventoryUpdates = 0;
    private WorldPoint currentLocation = null;

    private Multiset<Integer> getInventorySnapshot() {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        HashMultiset inventorySnapshot = HashMultiset.create();
        if (inventory != null) {
            Arrays.stream(inventory.getItems()).forEach(arg_0 -> OldSchoolSnitchPlugin.lambda$getInventorySnapshot$0((Multiset)inventorySnapshot, arg_0));
        }
        return inventorySnapshot;
    }

    protected void startUp() throws Exception {
        log.debug("Old School Snitch started!");
    }

    @Subscribe
    public void onPlayerChanged(PlayerChanged playerChanged) {
        if (!this.NameSnatched && playerChanged.getPlayer().getId() == this.client.getLocalPlayer().getId()) {
            this.snitchClient.SignIn(new NameSignIn(this.client.getLocalPlayer().getName(), this.config.apiKey(), this.client.getAccountHash()));
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.previousInventorySnapshot = this.getInventorySnapshot();
        }
    }

    protected void shutDown() throws Exception {
        log.debug("Old School Snitch stopped!");
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.config.locationTrackingCheckbox() && !this.client.isInInstancedRegion()) {
            Long accountHash = this.client.getAccountHash();
            String apiKey = this.config.apiKey();
            WorldPoint loc = this.client.getLocalPlayer().getWorldLocation();
            int x = loc.getX();
            int y = loc.getY();
            int plane = loc.getPlane();
            if (loc != null && this.currentLocation != null && (x != this.currentLocation.getX() || y != this.currentLocation.getY() || plane != this.currentLocation.getPlane())) {
                this.snitchClient.sendLocation(new UserLocation(x, y, apiKey, accountHash));
            }
            this.currentLocation = loc;
        }
    }

    private boolean isTempWorld() {
        EnumSet worldType = this.client.getWorldType();
        return worldType.contains(WorldType.BETA_WORLD) || worldType.contains(WorldType.DEADMAN) || worldType.contains(WorldType.FRESH_START_WORLD) || worldType.contains(WorldType.LAST_MAN_STANDING) || worldType.contains(WorldType.NOSAVE_MODE) || worldType.contains(WorldType.PVP_ARENA) || worldType.contains(WorldType.QUEST_SPEEDRUNNING) || worldType.contains(WorldType.SEASONAL) || worldType.contains(WorldType.TOURNAMENT_WORLD);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (this.isTempWorld()) {
            return;
        }
        Long accountHash = this.client.getAccountHash();
        String apiKey = this.config.apiKey();
        ItemContainer container = event.getItemContainer();
        if (this.containerChangedCount < 1 && container == this.client.getItemContainer(InventoryID.INVENTORY)) {
            log.debug("Setting baseline snapshot");
            this.previousInventorySnapshot = this.getInventorySnapshot();
            log.debug("Inventory count: " + this.previousInventorySnapshot.elementSet().size());
        } else if (this.containerChangedCount > 1 && container == this.client.getItemContainer(InventoryID.INVENTORY)) {
            log.debug("Inventory changed!");
            log.debug("Pending requested updates: " + this.pendingInventoryUpdates);
            if (this.pendingInventoryUpdates > 0) {
                Multiset<Integer> currentInventorySnapshot = this.getInventorySnapshot();
                Multiset itemsReceived = Multisets.difference(currentInventorySnapshot, this.previousInventorySnapshot);
                this.previousInventorySnapshot = currentInventorySnapshot;
                if (this.containerChangedCount > 1) {
                    Set set = itemsReceived.elementSet();
                    log.debug("Items delta: " + set.size());
                    for (Integer itemId : set) {
                        int count = itemsReceived.count((Object)itemId);
                        if (this.config.debugMessagesCheckbox()) {
                            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Got " + count + " of " + itemId, null);
                        }
                        this.snitchClient.sendItem(new ItemDrop(itemId, count, apiKey, accountHash));
                    }
                }
                Integer n = this.pendingInventoryUpdates;
                this.pendingInventoryUpdates = this.pendingInventoryUpdates - 1;
                Integer n2 = this.pendingInventoryUpdates;
            } else if (this.pendingInventoryUpdates == 0) {
                this.previousInventorySnapshot = this.getInventorySnapshot();
            } else {
                log.error("Somehow managed to get pendingInvUpdates < 0. This is a problem");
            }
        }
        Integer n = this.containerChangedCount;
        Integer n3 = this.containerChangedCount = Integer.valueOf(this.containerChangedCount + 1);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.isTempWorld()) {
            return;
        }
        String message = event.getMessage();
        if (event.getType() != ChatMessageType.SPAM) {
            return;
        }
        if (WOOD_CUT_PATTERN.matcher(message).matches()) {
            Integer n = this.pendingInventoryUpdates;
            Integer n2 = this.pendingInventoryUpdates = Integer.valueOf(this.pendingInventoryUpdates + 1);
            log.debug("Woodcutting increasing pending inv");
        } else if (MINING_PATTERN.matcher(event.getMessage()).matches()) {
            Integer n = this.pendingInventoryUpdates;
            Integer n3 = this.pendingInventoryUpdates = Integer.valueOf(this.pendingInventoryUpdates + 1);
            log.debug("Mining increasing pending inv");
        } else if (message.contains("You catch a") || message.contains("You catch some") || message.equals("Your cormorant returns with its catch.")) {
            Integer n = this.pendingInventoryUpdates;
            Integer n4 = this.pendingInventoryUpdates = Integer.valueOf(this.pendingInventoryUpdates + 1);
            log.debug("Fishing increasing pending inv");
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (this.isTempWorld()) {
            return;
        }
        Skill skill = statChanged.getSkill();
        int xp = statChanged.getXp();
        Long accountHash = this.client.getAccountHash();
        String apiKey = this.config.apiKey();
        Integer previous = this.previousSkillExpTable.put(skill, xp);
        if (!this.config.apiKey().isEmpty()) {
            if (previous != null) {
                int delta = xp - previous;
                if (delta > 0) {
                    if (this.config.debugMessagesCheckbox()) {
                        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", delta + "XP acquired in " + skill.name(), null);
                    }
                    this.snitchClient.sendXP(new XpDrop(skill.name(), delta, xp, apiKey, accountHash));
                    if (statChanged.getSkill() == Skill.RUNECRAFT) {
                        Integer n = this.pendingInventoryUpdates;
                        Integer n2 = this.pendingInventoryUpdates = Integer.valueOf(this.pendingInventoryUpdates + 1);
                        log.debug("Runecrafting increasing pending inv");
                    }
                }
            } else {
                this.snitchClient.sendXP(new XpDrop(skill.name(), 0, xp, apiKey, accountHash));
            }
        }
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        if (this.isTempWorld()) {
            return;
        }
        if (this.config.killAndDropTrackingCheckbox()) {
            Long accountHash = this.client.getAccountHash();
            String apiKey = this.config.apiKey();
            NPC npc = npcLootReceived.getNpc();
            if (this.config.debugMessagesCheckbox()) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", npc.getName() + " Killed", null);
            }
            this.snitchClient.sendKill(new NpcKill(npc.getId(), apiKey, accountHash));
            for (ItemStack item : npcLootReceived.getItems()) {
                if (this.config.debugMessagesCheckbox()) {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", item.getQuantity() + " of item " + item.getId(), null);
                }
                this.snitchClient.sendItem(new ItemDrop(item.getId(), item.getQuantity(), npc.getId(), apiKey, accountHash));
            }
        }
    }

    @Subscribe
    public void onLootReceived(LootReceived lootReceived) {
        if (this.isTempWorld()) {
            return;
        }
        if (this.config.killAndDropTrackingCheckbox()) {
            Long accountHash = this.client.getAccountHash();
            String apiKey = this.config.apiKey();
            if (lootReceived.getType() != LootRecordType.NPC) {
                log.debug("Adding loot from non-npc Loot Recieved");
                for (ItemStack item : lootReceived.getItems()) {
                    if (this.config.debugMessagesCheckbox()) {
                        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", item.getQuantity() + " of item " + item.getId(), null);
                    }
                    this.snitchClient.sendItem(new ItemDrop(item.getId(), item.getQuantity(), apiKey, accountHash));
                }
            }
        }
    }

    @Provides
    OldSchoolSnitchConfig provideConfig(ConfigManager configManager) {
        return (OldSchoolSnitchConfig)configManager.getConfig(OldSchoolSnitchConfig.class);
    }

    private static /* synthetic */ void lambda$getInventorySnapshot$0(Multiset inventorySnapshot, Item item) {
        inventorySnapshot.add((Object)item.getId(), item.getQuantity());
    }
}

