/*
 * Decompiled with CFR 0.152.
 */
package ch.oldschoolsnit;

import ch.oldschoolsnit.OldSchoolSnitchConfig;
import ch.oldschoolsnit.records.ItemDrop;
import ch.oldschoolsnit.records.NameSignIn;
import ch.oldschoolsnit.records.NpcKill;
import ch.oldschoolsnit.records.UserLocation;
import ch.oldschoolsnit.records.XpDrop;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import java.io.IOException;
import javax.inject.Inject;
import net.runelite.api.Client;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldSchoolSnitchClient {
    private static final Logger log = LoggerFactory.getLogger(OldSchoolSnitchClient.class);
    @Inject
    private OldSchoolSnitchConfig config;
    @Inject
    private Client gameClient;
    private final OkHttpClient client;
    private final Gson gson;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final String baseUrl = "https://oldschoolsnit.ch";
    private final Callback callback = new Callback(){

        public void onFailure(Call call, IOException e) {
            log.error("Error in OldSchoolSnitchClient", (Throwable)e);
        }

        public void onResponse(Call call, Response response) throws IOException {
            response.close();
        }
    };

    @Inject
    private OldSchoolSnitchClient(OkHttpClient client, Gson gson) {
        this.client = client;
        this.gson = gson.newBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    }

    public void SignIn(NameSignIn name) {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson((Object)name));
        Request request = new Request.Builder().url("https://oldschoolsnit.ch/api/name").post(body).build();
        this.makeRequest(request);
    }

    public void sendXP(XpDrop xpDrop) {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson((Object)xpDrop));
        Request request = new Request.Builder().url("https://oldschoolsnit.ch/api/xp").post(body).build();
        this.makeRequest(request);
    }

    public void sendKill(NpcKill kill) {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson((Object)kill));
        Request request = new Request.Builder().url("https://oldschoolsnit.ch/api/kill").post(body).build();
        this.makeRequest(request);
    }

    public void sendItem(ItemDrop itemDrop) {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson((Object)itemDrop));
        Request request = new Request.Builder().url("https://oldschoolsnit.ch/api/item").post(body).build();
        this.makeRequest(request);
    }

    public void sendLocation(UserLocation location) {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson((Object)location));
        Request request = new Request.Builder().url("https://oldschoolsnit.ch/api/location").post(body).build();
        this.makeRequest(request);
    }

    public void makeRequest(Request request) {
        this.client.newCall(request).enqueue(this.callback);
    }
}

