/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats;

import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;

public enum NylocasType {
    MELEE_SMALL(8342, 8348),
    MELEE_BIG(8345, 8351),
    RANGE_SMALL(8343, 8349),
    RANGE_BIG(8346, 8352),
    MAGE_SMALL(8344, 8350),
    MAGE_BIG(8347, 8353),
    SM_MELEE_SMALL(10774, 10780),
    SM_MELEE_BIG(10777, 10783),
    SM_RANGE_SMALL(10775, 10781),
    SM_RANGE_BIG(10778, 10784),
    SM_MAGE_SMALL(10776, 10782),
    SM_MAGE_BIG(10779, 10785),
    HM_MELEE_SMALL(10791, 10797),
    HM_MELEE_BIG(10794, 10800),
    HM_RANGE_SMALL(10792, 10798),
    HM_RANGE_BIG(10795, 10801),
    HM_MAGE_SMALL(10793, 10799),
    HM_MAGE_BIG(10796, 10802);

    private final int normalId;
    private final int aggressiveId;
    public static final HashMap<Integer, NylocasType> lookupMap;

    private NylocasType(int normalId, int aggressiveId) {
        this.normalId = normalId;
        this.aggressiveId = aggressiveId;
    }

    static boolean isNylocas(int npcId) {
        return lookupMap.get(npcId) != null;
    }

    public static boolean isMeleeNylocas(int npcId) {
        return ArrayUtils.contains((Object[])new Integer[]{NylocasType.MELEE_SMALL.normalId, NylocasType.MELEE_SMALL.aggressiveId, NylocasType.MELEE_BIG.normalId, NylocasType.MELEE_BIG.aggressiveId, NylocasType.SM_MELEE_SMALL.normalId, NylocasType.SM_MELEE_SMALL.aggressiveId, NylocasType.SM_MELEE_BIG.normalId, NylocasType.SM_MELEE_BIG.aggressiveId, NylocasType.HM_MELEE_SMALL.normalId, NylocasType.HM_MELEE_SMALL.aggressiveId, NylocasType.HM_MELEE_BIG.normalId, NylocasType.HM_MELEE_BIG.aggressiveId}, (Object)npcId);
    }

    public static boolean isMeleeSmall(int npcId) {
        return ArrayUtils.contains((Object[])new Integer[]{NylocasType.MELEE_SMALL.normalId, NylocasType.MELEE_SMALL.aggressiveId, NylocasType.SM_MELEE_SMALL.normalId, NylocasType.SM_MELEE_SMALL.aggressiveId, NylocasType.HM_MELEE_SMALL.normalId, NylocasType.HM_MELEE_SMALL.aggressiveId}, (Object)npcId);
    }

    public static boolean isRangeNylocas(int npcId) {
        return ArrayUtils.contains((Object[])new Integer[]{NylocasType.RANGE_SMALL.normalId, NylocasType.RANGE_SMALL.aggressiveId, NylocasType.RANGE_BIG.normalId, NylocasType.RANGE_BIG.aggressiveId, NylocasType.SM_RANGE_SMALL.normalId, NylocasType.SM_RANGE_SMALL.aggressiveId, NylocasType.SM_RANGE_BIG.normalId, NylocasType.SM_RANGE_BIG.aggressiveId, NylocasType.HM_RANGE_SMALL.normalId, NylocasType.HM_RANGE_SMALL.aggressiveId, NylocasType.HM_RANGE_BIG.normalId, NylocasType.HM_RANGE_BIG.aggressiveId}, (Object)npcId);
    }

    public static boolean isRangeSmall(int npcId) {
        return ArrayUtils.contains((Object[])new Integer[]{NylocasType.RANGE_SMALL.normalId, NylocasType.RANGE_SMALL.aggressiveId, NylocasType.SM_RANGE_SMALL.normalId, NylocasType.SM_RANGE_SMALL.aggressiveId, NylocasType.HM_RANGE_SMALL.normalId, NylocasType.HM_RANGE_SMALL.aggressiveId}, (Object)npcId);
    }

    public static boolean isMageNylocas(int npcId) {
        return ArrayUtils.contains((Object[])new Integer[]{NylocasType.MAGE_SMALL.normalId, NylocasType.MAGE_SMALL.aggressiveId, NylocasType.MAGE_BIG.normalId, NylocasType.MAGE_BIG.aggressiveId, NylocasType.SM_MAGE_SMALL.normalId, NylocasType.SM_MAGE_SMALL.aggressiveId, NylocasType.SM_MAGE_BIG.normalId, NylocasType.SM_MAGE_BIG.aggressiveId, NylocasType.HM_MAGE_SMALL.normalId, NylocasType.HM_MAGE_SMALL.aggressiveId, NylocasType.HM_MAGE_BIG.normalId, NylocasType.HM_MAGE_BIG.aggressiveId}, (Object)npcId);
    }

    public static boolean isMageSmall(int npcId) {
        return ArrayUtils.contains((Object[])new Integer[]{NylocasType.MAGE_SMALL.normalId, NylocasType.MAGE_SMALL.aggressiveId, NylocasType.SM_MAGE_SMALL.normalId, NylocasType.SM_MAGE_SMALL.aggressiveId, NylocasType.HM_MAGE_SMALL.normalId, NylocasType.HM_MAGE_SMALL.aggressiveId}, (Object)npcId);
    }

    public static boolean isAggressive(int npcId) {
        NylocasType type = lookupMap.get(npcId);
        if (type == null) {
            return false;
        }
        return npcId == type.aggressiveId;
    }

    public String toString() {
        return "NylocasType{normalId=" + this.normalId + ", aggressiveId=" + this.aggressiveId + "}";
    }

    static {
        lookupMap = new HashMap();
        for (NylocasType type : NylocasType.values()) {
            lookupMap.put(type.normalId, type);
            lookupMap.put(type.aggressiveId, type);
        }
    }
}

