/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats;

import com.google.common.annotations.VisibleForTesting;
import com.infernostats.NpcDamaged;
import com.infernostats.Nylocas;
import com.infernostats.NylocasType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.GraphicsObject;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.Renderable;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.FakeXpDrop;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.StatChanged;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.callback.Hooks;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.party.PartyMember;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.ArrayUtils;

@PluginDescriptor(name="Nylo Death Indicators", description="Hide dead nylos faster")
public class NyloDeathIndicatorsPlugin
extends Plugin {
    private int partySize = 0;
    private boolean isInNyloRegion = false;
    private final ArrayList<Nylocas> nylos = new ArrayList();
    private final ArrayList<Nylocas> deadNylos = new ArrayList();
    private final Map<Skill, Integer> fakeXpMap = new EnumMap<Skill, Integer>(Skill.class);
    private final Map<Skill, Integer> previousXpMap = new EnumMap<Skill, Integer>(Skill.class);
    private static final Set<Integer> CHINCHOMPAS = new HashSet<Integer>(Arrays.asList(10033, 10034, 11959));
    private static final Set<Integer> POWERED_STAVES = new HashSet<Integer>(Arrays.asList(22323, 11905, 11907, 12899, 22292, 25731, 27275, 28547));
    private static final Set<Integer> NYLO_MELEE_WEAPONS = new HashSet<Integer>(Arrays.asList(24219, 23360, 12727, 13652, 4587, 13263, 24417, 11838, 12809, 22324, 25734, 4151, 26482, 12774, 12773, 12006, 26484, 23995, 24551, 24553, 25870, 25872, 25874, 25876, 25878, 25880, 25882, 28039, 28534, 27690));
    private static final Set<Integer> MULTIKILL_MELEE_WEAPONS = new HashSet<Integer>(Arrays.asList(22486, 22325, 25738, 25736, 25741, 25739, 28543, 28545, 21015));
    private static final int BARRAGE_ANIMATION = 1979;
    private static final int NYLOCAS_REGION_ID = 13122;
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private WSClient wsClient;
    @Inject
    private PartyService party;
    @Inject
    private Hooks hooks;

    protected void startUp() {
        this.clientThread.invoke(this::initializePreviousXpMap);
        this.hooks.registerRenderableDrawListener(this.drawListener);
        this.wsClient.registerMessage(NpcDamaged.class);
    }

    protected void shutDown() {
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
        this.wsClient.unregisterMessage(NpcDamaged.class);
    }

    private void initializePreviousXpMap() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            this.previousXpMap.clear();
        } else {
            for (Skill skill : Skill.values()) {
                this.previousXpMap.put(skill, this.client.getSkillExperience(skill));
            }
        }
    }

    @Subscribe
    protected void onGameTick(GameTick event) {
        if (!this.isInNyloRegion) {
            this.isInNyloRegion = this.isInNylocasRegion();
            if (this.isInNyloRegion) {
                this.partySize = this.getParty().size();
            }
        } else {
            this.isInNyloRegion = this.isInNylocasRegion();
            if (!this.isInNyloRegion) {
                this.nylos.clear();
            }
        }
        for (Map.Entry<Skill, Integer> xp : this.fakeXpMap.entrySet()) {
            this.processXpDrop(xp.getKey(), xp.getValue());
        }
        this.fakeXpMap.clear();
        Iterator<Nylocas> nylocasIterator = this.deadNylos.iterator();
        while (nylocasIterator.hasNext()) {
            boolean isDead;
            Nylocas nylocas = nylocasIterator.next();
            nylocas.setHidden(nylocas.getHidden() + 1);
            boolean bl = isDead = nylocas.getNpc().getHealthRatio() == 0;
            if (nylocas.getHidden() <= 5 || isDead) continue;
            nylocas.setHidden(0);
            nylocasIterator.remove();
        }
    }

    @Subscribe
    protected void onNpcSpawned(NpcSpawned event) {
        if (!this.isInNyloRegion) {
            return;
        }
        int smSmallHP = -1;
        int smBigHP = -1;
        int bigHP = -1;
        int smallHP = -1;
        switch (this.partySize) {
            case 1: {
                bigHP = 16;
                smallHP = 8;
                smSmallHP = 2;
                smBigHP = 3;
                break;
            }
            case 2: {
                bigHP = 16;
                smallHP = 8;
                smSmallHP = 3;
                smBigHP = 5;
                break;
            }
            case 3: {
                bigHP = 16;
                smallHP = 8;
                smSmallHP = 6;
                smBigHP = 9;
                break;
            }
            case 4: {
                bigHP = 19;
                smallHP = 9;
                smSmallHP = 8;
                smBigHP = 12;
                break;
            }
            case 5: {
                bigHP = 22;
                smallHP = 11;
                smSmallHP = 10;
                smBigHP = 15;
            }
        }
        NPC npc = event.getNpc();
        int index = npc.getIndex();
        switch (npc.getId()) {
            case 8342: 
            case 8343: 
            case 8344: 
            case 10791: 
            case 10792: 
            case 10793: {
                this.nylos.add(new Nylocas(npc, index, smallHP));
                break;
            }
            case 8345: 
            case 8346: 
            case 8347: 
            case 8351: 
            case 8352: 
            case 8353: 
            case 10783: 
            case 10784: 
            case 10785: 
            case 10794: 
            case 10795: 
            case 10796: 
            case 10800: 
            case 10801: 
            case 10802: {
                this.nylos.add(new Nylocas(npc, index, bigHP));
                break;
            }
            case 10774: 
            case 10775: 
            case 10776: {
                this.nylos.add(new Nylocas(npc, index, smSmallHP));
                break;
            }
            case 10777: 
            case 10778: 
            case 10779: {
                this.nylos.add(new Nylocas(npc, index, smBigHP));
            }
        }
    }

    @Subscribe
    protected void onNpcDespawned(NpcDespawned event) {
        if (!this.isInNyloRegion) {
            return;
        }
        this.nylos.removeIf(nylo -> nylo.getNpcIndex() == event.getNpc().getIndex());
        this.deadNylos.removeIf(nylo -> nylo.getNpcIndex() == event.getNpc().getIndex());
    }

    @Subscribe
    protected void onHitsplatApplied(HitsplatApplied event) {
        if (!this.isInNyloRegion) {
            return;
        }
        Actor actor = event.getActor();
        if (actor instanceof NPC) {
            int npcIndex = ((NPC)actor).getIndex();
            int damage = event.getHitsplat().getAmount();
            for (Nylocas nylocas : this.nylos) {
                if (nylocas.getNpcIndex() != npcIndex) continue;
                if (event.getHitsplat().getHitsplatType() == 6) {
                    nylocas.setHp(nylocas.getHp() + damage);
                } else {
                    nylocas.setHp(nylocas.getHp() - damage);
                }
                nylocas.setQueuedDamage(Math.max(0, nylocas.getQueuedDamage() - damage));
            }
        }
    }

    @Subscribe
    protected void onNpcDamaged(NpcDamaged event) {
        if (!this.isInNyloRegion) {
            return;
        }
        PartyMember member = this.party.getLocalMember();
        if (member != null && member.getMemberId() == event.getMemberId()) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            int npcIndex = event.getNpcIndex();
            int damage = event.getDamage();
            for (Nylocas nylocas : this.nylos) {
                if (nylocas.getNpcIndex() != npcIndex) continue;
                nylocas.setQueuedDamage(nylocas.getQueuedDamage() + damage);
                if (nylocas.getHp() - nylocas.getQueuedDamage() > 0 || !this.deadNylos.stream().noneMatch(deadNylo -> deadNylo.getNpcIndex() == npcIndex)) continue;
                this.deadNylos.add(nylocas);
                nylocas.getNpc().setDead(true);
            }
        });
    }

    @Subscribe
    protected void onFakeXpDrop(FakeXpDrop event) {
        int currentXp = this.fakeXpMap.getOrDefault(event.getSkill(), 0);
        this.fakeXpMap.put(event.getSkill(), currentXp + event.getXp());
    }

    @Subscribe
    protected void onStatChanged(StatChanged event) {
        this.preProcessXpDrop(event.getSkill(), event.getXp());
    }

    private void preProcessXpDrop(Skill skill, int xp) {
        int xpAfter = this.client.getSkillExperience(skill);
        int xpBefore = this.previousXpMap.getOrDefault(skill, -1);
        this.previousXpMap.put(skill, xpAfter);
        if (xpBefore == -1 || xpAfter <= xpBefore) {
            return;
        }
        this.processXpDrop(skill, xpAfter - xpBefore);
    }

    private void processXpDrop(Skill skill, int xp) {
        if (!this.isInNylocasRegion()) {
            return;
        }
        int damage = 0;
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        PlayerComposition playerComposition = player.getPlayerComposition();
        if (playerComposition == null) {
            return;
        }
        int weaponUsed = playerComposition.getEquipmentId(KitType.WEAPON);
        int attackStyle = this.client.getVarpValue(43);
        boolean isBarrageCast = player.getAnimation() == 1979;
        boolean isChinchompa = CHINCHOMPAS.contains(weaponUsed);
        boolean isPoweredStaff = POWERED_STAVES.contains(weaponUsed);
        boolean isDefensiveCast = false;
        if (isBarrageCast && !isPoweredStaff) {
            isDefensiveCast = this.client.getVarbitValue(2668) == 1;
        } else if (isPoweredStaff) {
            isDefensiveCast = attackStyle == 3;
        }
        switch (skill) {
            case MAGIC: {
                if (isBarrageCast && !isDefensiveCast) {
                    damage = xp % 2 == 0 ? (xp - 52) / 2 : (xp - 51) / 2;
                    this.handleAreaOfEffectAttack(damage, player.getInteracting(), true);
                    return;
                }
                if (!isPoweredStaff || isDefensiveCast) break;
                damage = (int)((double)xp / 2.0);
                break;
            }
            case ATTACK: 
            case STRENGTH: 
            case DEFENCE: {
                if (MULTIKILL_MELEE_WEAPONS.contains(weaponUsed)) {
                    return;
                }
                if (NYLO_MELEE_WEAPONS.contains(weaponUsed)) {
                    damage = (int)((double)xp / 4.0);
                    break;
                }
                if (isBarrageCast && isDefensiveCast) {
                    this.handleAreaOfEffectAttack(xp, player.getInteracting(), true);
                    return;
                }
                if (!isPoweredStaff || !isDefensiveCast) break;
                damage = xp;
                break;
            }
            case RANGED: {
                damage = attackStyle == 3 ? (int)((double)xp / 2.0) : (int)((double)xp / 4.0);
                if (!isChinchompa) break;
                this.handleAreaOfEffectAttack(damage, player.getInteracting(), false);
                return;
            }
        }
        this.sendDamage(player, damage);
    }

    private void handleAreaOfEffectAttack(long hit, Actor interacted, boolean isBarrage) {
        Predicate<Integer> type = isBarrage ? NylocasType::isMageNylocas : NylocasType::isRangeNylocas;
        if (interacted instanceof NPC) {
            NPC interactedNPC = (NPC)interacted;
            WorldPoint targetPoint = interactedNPC.getWorldLocation();
            List<Nylocas> clump = this.nylos.stream().filter(nylo -> nylo.getNpc().getWorldLocation().distanceTo(targetPoint) <= 1).filter(nylo -> type.test(nylo.getNpc().getId())).collect(Collectors.toList());
            int clumpHp = clump.stream().mapToInt(Nylocas::getHp).sum();
            if ((long)clumpHp > hit) {
                return;
            }
            this.sendClumpDamage(clump);
        }
    }

    private void sendDamage(Player player, int damage) {
        if (damage <= 0) {
            return;
        }
        Actor interacted = player.getInteracting();
        if (interacted instanceof NPC) {
            NPC interactedNPC = (NPC)interacted;
            int npcIndex = interactedNPC.getIndex();
            NpcDamaged npcDamaged = new NpcDamaged(npcIndex, damage);
            if (this.party.isInParty()) {
                this.clientThread.invokeLater(() -> this.party.send((PartyMessage)npcDamaged));
            }
            this.onNpcDamaged(npcDamaged);
        }
    }

    private void sendClumpDamage(List<Nylocas> clump) {
        for (Nylocas nylocas : clump) {
            int npcIndex = nylocas.getNpcIndex();
            NpcDamaged npcDamaged = new NpcDamaged(npcIndex, nylocas.getHp());
            if (this.party.isInParty()) {
                this.clientThread.invokeLater(() -> this.party.send((PartyMessage)npcDamaged));
            }
            this.onNpcDamaged(npcDamaged);
        }
    }

    public List<String> getParty() {
        ArrayList<String> team = new ArrayList<String>();
        for (int i = 330; i < 335; ++i) {
            team.add(this.client.getVarcStrValue(i));
        }
        return team.stream().map(Text::sanitize).filter(name -> !name.isEmpty()).collect(Collectors.toList());
    }

    private boolean isInNylocasRegion() {
        return this.client.getMapRegions() != null && ArrayUtils.contains((int[])this.client.getMapRegions(), (int)13122);
    }

    @VisibleForTesting
    boolean shouldDraw(Renderable renderable, boolean drawingUI) {
        if (renderable instanceof NPC) {
            return this.deadNylos.stream().noneMatch(nylocas -> nylocas.getNpcIndex() == ((NPC)renderable).getIndex());
        }
        if (renderable instanceof GraphicsObject) {
            switch (((GraphicsObject)renderable).getId()) {
                case 1562: 
                case 1563: 
                case 1564: 
                case 1565: 
                case 1566: 
                case 1567: {
                    return false;
                }
            }
        }
        return true;
    }
}

