/*
 * Decompiled with CFR 0.152.
 */
package com.erishiongamesllc.totalsellingprice;

import com.erishiongamesllc.totalsellingprice.ItemData;
import com.erishiongamesllc.totalsellingprice.ShopCalculator;
import com.erishiongamesllc.totalsellingprice.ShopInfo;
import com.erishiongamesllc.totalsellingprice.TotalSellingPriceConfig;
import com.erishiongamesllc.totalsellingprice.TotalSellingPricePlugin;
import com.erishiongamesllc.totalsellingprice.inventoryType;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.Text;

public class WidgetHandler {
    public static final int SHOP_WIDGET_ID = 19660801;
    public static final int SHOP_WIDGET_CHILD_TEXT_FIELD = 1;
    public static final int SHOP_INVENTORY_WIDGET_ID = 19660816;
    public static final int SHOP_PLAYER_INVENTORY_WIDGET_ID = 19726336;
    private Widget clickedWidget = null;
    private int clickedWidgetID = 0;
    private MenuOptionClicked menuOptionClicked = null;
    private inventoryType clickedInventory = inventoryType.NONE;
    private String currentShopName = null;
    private ItemComposition itemComposition = null;
    private Widget[] shopItems = null;
    private Widget[] playerItems = null;
    private ItemData itemData = new ItemData();
    private ShopInfo currentShop = null;
    private int amountOfItemInShopInventory = 0;
    private int amountOfItemInPlayerInventory = 0;
    @Inject
    private Client client;
    @Inject
    private TotalSellingPricePlugin totalSellingPricePlugin;
    @Inject
    private ItemManager itemManager;
    @Inject
    private TotalSellingPriceConfig config;
    @Inject
    private ShopCalculator shopCalculator;

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked clicked) {
        this.menuOptionClicked = clicked;
        if (!this.isShopOpen() || !this.isCheckingValue()) {
            return;
        }
        this.currentShopName = this.getCurrentShopName();
        this.currentShop = this.getCurrentShopValue();
        if (this.currentShop == null) {
            return;
        }
        this.assignWidgetVariables();
        if (this.clickedInventory == inventoryType.NONE) {
            return;
        }
        if (this.clickedInventory == inventoryType.SHOP_INVENTORY) {
            this.createChatMessage("Buying from shops is not supported right now");
            return;
        }
        this.assignItemVariables();
        this.amountOfItemInPlayerInventory = this.findAmountOfItemInInventory(this.playerItems);
        this.amountOfItemInShopInventory = this.findAmountOfItemInInventory(this.shopItems);
        this.shopCalculator.calculateAllGoldSellingOptions();
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.currentShop != null && !this.isShopOpen()) {
            this.resetVariables();
        }
    }

    private void assignWidgetVariables() {
        this.clickedWidget = this.menuOptionClicked.getWidget();
        assert (this.clickedWidget != null);
        this.clickedWidgetID = this.clickedWidget.getId();
        this.clickedInventory = this.getClickedInventory(this.clickedWidgetID);
    }

    private void assignItemVariables() {
        this.itemComposition = this.itemManager.getItemComposition(this.menuOptionClicked.getItemId());
        this.itemData.setName(this.itemComposition.getName());
        this.itemData.setId(this.itemComposition.getId());
        this.itemData.setValue(this.itemComposition.getPrice());
        this.shopItems = Objects.requireNonNull(this.client.getWidget(19660816)).getChildren();
        this.playerItems = Objects.requireNonNull(this.client.getWidget(19726336)).getChildren();
    }

    private void resetVariables() {
        this.clickedWidget = null;
        this.clickedWidgetID = 0;
        this.menuOptionClicked = null;
        this.clickedInventory = inventoryType.NONE;
        this.currentShopName = null;
        this.currentShop = null;
        this.itemComposition = null;
        this.itemData = new ItemData();
        this.shopItems = null;
        this.playerItems = null;
        this.amountOfItemInShopInventory = 0;
        this.amountOfItemInPlayerInventory = 0;
    }

    private boolean isShopOpen() {
        return this.client.getWidget(WidgetInfo.SHOP_INVENTORY_ITEMS_CONTAINER) != null;
    }

    private boolean isCheckingValue() {
        return Text.removeTags((String)this.menuOptionClicked.getMenuOption()).equals("Value");
    }

    private String getCurrentShopName() {
        return Objects.requireNonNull(this.client.getWidget(19660801)).getChild(1).getText();
    }

    private inventoryType getClickedInventory(int widgetID) {
        switch (widgetID) {
            case 19660816: {
                return inventoryType.SHOP_INVENTORY;
            }
            case 19726336: {
                return inventoryType.PLAYER_INVENTORY;
            }
        }
        return inventoryType.NONE;
    }

    private ShopInfo getCurrentShopValue() {
        for (ShopInfo shopInfo : ShopInfo.values()) {
            if (!shopInfo.getName().equals(this.currentShopName)) continue;
            return shopInfo;
        }
        this.createChatMessage("this shop is not supported right now");
        return null;
    }

    private int findAmountOfItemInInventory(Widget[] inventory) {
        for (Widget item : inventory) {
            if (!item.getName().contains(this.itemData.getName())) continue;
            return item.getItemQuantity();
        }
        return 0;
    }

    public void createChatMessage(String message) {
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, null);
    }

    public ItemData getItemData() {
        return this.itemData;
    }

    public ShopInfo getCurrentShop() {
        return this.currentShop;
    }

    public int getAmountOfItemInShopInventory() {
        return this.amountOfItemInShopInventory;
    }

    public int getAmountOfItemInPlayerInventory() {
        return this.amountOfItemInPlayerInventory;
    }
}

