/*
 * Decompiled with CFR 0.152.
 */
package com.erishiongamesllc.totalsellingprice;

import com.erishiongamesllc.totalsellingprice.ShopInfo;
import com.erishiongamesllc.totalsellingprice.TotalSellingPriceConfig;
import com.erishiongamesllc.totalsellingprice.WidgetHandler;
import javax.inject.Inject;

public class ShopCalculator {
    @Inject
    private TotalSellingPriceConfig config;
    @Inject
    private WidgetHandler widgetHandler;

    public void calculateAllGoldSellingOptions() {
        if (this.config == null) {
            return;
        }
        if (this.config.sell10()) {
            this.calculateGoldEarnedFromSelling(10);
        }
        if (this.config.sell20()) {
            this.calculateGoldEarnedFromSelling(20);
        }
        if (this.config.sell30()) {
            this.calculateGoldEarnedFromSelling(30);
        }
        if (this.config.sell40()) {
            this.calculateGoldEarnedFromSelling(40);
        }
        if (this.config.sell50()) {
            this.calculateGoldEarnedFromSelling(50);
        }
        if (this.config.sellAll()) {
            this.calculateGoldEarnedFromSelling(this.widgetHandler.getAmountOfItemInPlayerInventory());
        }
        if (this.config.sellCustom()) {
            this.calculateGoldEarnedFromSelling(this.config.amountPerWorldToSell());
        }
    }

    private void calculateGoldEarnedFromSelling(int amountPerWorld) {
        int amountOfItemInShopInventory = this.widgetHandler.getAmountOfItemInShopInventory();
        int amountOfItemInPlayerInventory = this.widgetHandler.getAmountOfItemInPlayerInventory();
        int goldPerWorld = this.calculateGoldPerWorld(amountPerWorld, amountOfItemInShopInventory);
        int totalGold = (int)Math.floor((double)goldPerWorld * ((double)amountOfItemInPlayerInventory / (double)amountPerWorld));
        int averageGold = goldPerWorld / amountPerWorld;
        double percentOfMaxGold = this.calculateMaxGoldPercent(totalGold, amountOfItemInPlayerInventory);
        String colorAmountPerWorld = this.colorMessage(String.format("%,d", amountPerWorld));
        String colorGoldPerWorld = this.colorMessage(String.format("%,d", goldPerWorld));
        String colorAverageGold = this.colorMessage(String.format("%,d", averageGold));
        String colorTotalGold = this.colorMessage(String.format("%,d", totalGold));
        String colorPercent = this.colorMessage(String.format("%.2f", percentOfMaxGold));
        this.widgetHandler.createChatMessage("Sell " + colorAmountPerWorld + ": " + colorGoldPerWorld + " gold. Average: " + colorAverageGold + ". Total: " + colorTotalGold + ". Percent: " + colorPercent + ".");
        this.displayAmountOfWorldHopsNeeded(amountPerWorld);
    }

    private int calculateGoldPerWorld(int amountPerWorld, int amountInInventory) {
        int amountInShopInventory = amountInInventory;
        ShopInfo currentShop = this.widgetHandler.getCurrentShop();
        int currentGold = 0;
        float shopChange = currentShop.getChangePercent();
        for (int i = 0; i < amountPerWorld; ++i) {
            float buyPercent = currentShop.getBuyPercent() - shopChange * (float)amountInShopInventory;
            if (buyPercent < 0.1f) {
                buyPercent = 0.1f;
            }
            int shopBuyPrice = (int)Math.floor(buyPercent * (float)this.widgetHandler.getItemData().getValue());
            currentGold += shopBuyPrice;
            ++amountInShopInventory;
        }
        return currentGold;
    }

    private float calculateMaxGoldPercent(int totalGold, int amountInPlayerInventory) {
        int maxGoldPossible = this.calculateGoldPerWorld(1, 0) * amountInPlayerInventory;
        return (float)totalGold / (float)maxGoldPossible;
    }

    private void displayAmountOfWorldHopsNeeded(int amountPerWorld) {
        if (!this.config.calculateAmountOfWorldHopsNeeded()) {
            return;
        }
        int hopsNeeded = this.widgetHandler.getAmountOfItemInPlayerInventory() / amountPerWorld;
        String colorHopsNeeded = this.colorMessage(String.format("%,d", hopsNeeded));
        this.widgetHandler.createChatMessage("World hops needed: " + colorHopsNeeded);
    }

    public String colorMessage(String message) {
        String color = Integer.toHexString(this.config.highlightColor().getRGB()).substring(2);
        return "<col=" + color + ">" + message + "</col>";
    }
}

