/*
 * Decompiled with CFR 0.152.
 */
package com.splitter;

import com.google.inject.Provides;
import com.splitter.SplitterConfig;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.CommandExecuted;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.http.api.item.ItemPrice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Splitter")
public class SplitterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SplitterPlugin.class);
    private static final String SPLIT_COMMAND_STRING = "split";
    @Inject
    private Client client;
    @Inject
    private SplitterConfig config;
    @Inject
    private ChatCommandManager chatCommandManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private ChatMessageManager chatMessageManager;

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        if (commandExecuted.getCommand().equals(SPLIT_COMMAND_STRING)) {
            this.computeSplit(commandExecuted.getArguments());
        }
    }

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
    }

    void computeSplit(String[] args) {
        int[] splitReturn;
        int CoinID = 995;
        int PlatTokenID = 13204;
        ItemPrice item = null;
        ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
        if (container == null && args.length == 0) {
            this.inventoryHasNotLoaded();
            return;
        }
        int splitSize = this.config.splitSize();
        boolean hasPlatinum = false;
        int valueToSplit = 0;
        String itemName = null;
        if (container != null) {
            hasPlatinum = container.contains(PlatTokenID);
            int n = valueToSplit = hasPlatinum ? container.count(PlatTokenID) : container.count(CoinID);
        }
        if (args.length == 0 && valueToSplit == 0) {
            this.noCashMessage();
            return;
        }
        if (args.length == 1) {
            splitReturn = this.extractSplitSize(args);
            int n = splitSize = splitReturn[0] == -1 ? splitSize : splitReturn[1];
            if (splitReturn[0] >= 0 && valueToSplit == 0) {
                this.noCashMessage();
                return;
            }
            if (splitReturn[0] == -1) {
                itemName = this.itemNameConcat(args, splitReturn[0]);
                valueToSplit = this.getValueOfItem(itemName);
                if (valueToSplit == -1) {
                    this.printUnableToFindItem(itemName);
                    return;
                }
                item = this.itemPrice(itemName);
            }
        } else if (args.length > 1) {
            splitReturn = this.extractSplitSize(args);
            splitSize = splitReturn[0] == -1 ? splitSize : splitReturn[1];
            itemName = this.itemNameConcat(args, splitReturn[0]);
            valueToSplit = this.getValueOfItem(itemName);
            if (valueToSplit == -1) {
                this.printUnableToFindItem(itemName);
                return;
            }
            item = this.itemPrice(itemName);
        }
        if (splitSize == 0) {
            this.cannotSplitByZero();
            return;
        }
        int splitValue = valueToSplit / splitSize;
        if (item != null) {
            this.printSplitItem(item.getName(), splitValue, valueToSplit, splitSize);
        } else {
            this.printSplit(hasPlatinum, splitValue, valueToSplit, splitSize);
        }
    }

    private String itemNameConcat(String[] args, int splitSizeIndex) {
        CharSequence[] argsExtracted = splitSizeIndex == 1 ? Arrays.copyOf(args, args.length - 1) : (splitSizeIndex == 0 ? Arrays.copyOfRange(args, 1, args.length) : args);
        return String.join((CharSequence)" ", argsExtracted);
    }

    private int getValueOfItem(String itemName) {
        ItemPrice item = this.itemPrice(itemName);
        if (item != null) {
            return this.runeLiteConfig.useWikiItemPrices() ? this.itemManager.getWikiPrice(item) : item.getPrice();
        }
        return -1;
    }

    private int[] extractSplitSize(String[] args) {
        if (args.length == 0) {
            log.debug("Bad code, don't run extractSplitSize with an empty array");
            return new int[]{-1, 0};
        }
        try {
            int splitSize = Integer.parseInt(args[args.length - 1]);
            return new int[]{1, splitSize};
        }
        catch (NumberFormatException e) {
            try {
                int splitSize = Integer.parseInt(args[0]);
                return new int[]{0, splitSize};
            }
            catch (NumberFormatException f) {
                return new int[]{-1, 0};
            }
        }
    }

    private void cannotSplitByZero() {
        log.debug("Split size was 0");
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).value("Unable to split by 0.").build());
    }

    private void inventoryHasNotLoaded() {
        log.debug("Inventory is empty and hasn't loaded.");
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).value("No Coin(s) or Platinum token(s) in the inventory.").build());
    }

    private void noCashMessage() {
        log.debug("No money in the inventory.");
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).value("No Coin(s) or Platinum token(s) in the inventory.").build());
    }

    private void printSplit(boolean hasPlatinum, int splitValue, int valueToSplit, int splitSize) {
        String coinSplit = "Coin";
        String platinumSplit = "Platinum token";
        String splitType = hasPlatinum ? platinumSplit : coinSplit;
        String response = new ChatMessageBuilder().append("Splitting " + splitType + "s ").append(ChatColorType.HIGHLIGHT).append(QuantityFormatter.formatNumber((long)splitValue)).append(ChatColorType.NORMAL).append(", ( ").append(ChatColorType.HIGHLIGHT).append(QuantityFormatter.formatNumber((long)valueToSplit)).append(ChatColorType.NORMAL).append(" / ").append(ChatColorType.HIGHLIGHT).append(QuantityFormatter.formatNumber((long)splitSize)).append(ChatColorType.NORMAL).append(" )").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(response).build());
        log.debug("Split:" + splitValue);
    }

    private void printSplitItem(String itemName, int splitValue, int valueToSplit, int splitSize) {
        String response = new ChatMessageBuilder().append("Splitting ").append(ChatColorType.HIGHLIGHT).append(itemName).append(ChatColorType.NORMAL).append(": ").append(ChatColorType.HIGHLIGHT).append(QuantityFormatter.formatNumber((long)splitValue)).append(ChatColorType.NORMAL).append(", ( ").append(ChatColorType.HIGHLIGHT).append(QuantityFormatter.formatNumber((long)valueToSplit)).append(ChatColorType.NORMAL).append(" / ").append(ChatColorType.HIGHLIGHT).append(QuantityFormatter.formatNumber((long)splitSize)).append(ChatColorType.NORMAL).append(" )").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(response).build());
        log.debug("Split:" + splitValue);
    }

    private void printUnableToFindItem(String searchString) {
        String response = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Unable to find item '").append(ChatColorType.NORMAL).append(searchString).append(ChatColorType.HIGHLIGHT).append("'.").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(response).build());
        log.debug("Unable to find item");
    }

    private ItemPrice itemPrice(String substring) {
        List results = this.itemManager.search(substring);
        if (!results.isEmpty()) {
            return this.retrieveFromList(results, substring);
        }
        return null;
    }

    private ItemPrice retrieveFromList(List<ItemPrice> items, String originalInput) {
        ItemPrice shortest = null;
        for (ItemPrice item : items) {
            if (item.getName().equalsIgnoreCase(originalInput)) {
                return item;
            }
            if (shortest != null && item.getName().length() >= shortest.getName().length()) continue;
            shortest = item;
        }
        return shortest;
    }

    @Provides
    SplitterConfig provideConfig(ConfigManager configManager) {
        return (SplitterConfig)configManager.getConfig(SplitterConfig.class);
    }
}

