/*
 * Decompiled with CFR 0.152.
 */
package com.motherlodeprofit;

import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MotherlodeProfitSession {
    private static final Logger log = LoggerFactory.getLogger(MotherlodeProfitSession.class);
    private int nuggetsCount;
    private int coalCount;
    private int goldCount;
    private int mithrilCount;
    private int adamantiteCount;
    private int runiteCount;
    private int coalProfit;
    private int goldProfit;
    private int mithrilProfit;
    private int adamantiteProfit;
    private int runiteProfit;
    @Inject
    private ItemManager itemManager;

    public int getTotalProfit() {
        return this.coalProfit + this.goldProfit + this.mithrilProfit + this.adamantiteProfit + this.runiteProfit;
    }

    public void updateOreFound(int item, int count) {
        switch (item) {
            case 12012: {
                this.nuggetsCount += count;
                break;
            }
            case 453: {
                this.coalCount += count;
                this.coalProfit += count * this.itemManager.getItemPrice(453);
                break;
            }
            case 444: {
                this.goldCount += count;
                this.goldProfit += count * this.itemManager.getItemPrice(444);
                break;
            }
            case 447: {
                this.mithrilCount += count;
                this.mithrilProfit += count * this.itemManager.getItemPrice(447);
                break;
            }
            case 449: {
                this.adamantiteCount += count;
                this.adamantiteProfit += count * this.itemManager.getItemPrice(449);
                break;
            }
            case 451: {
                this.runiteCount += count;
                this.runiteProfit += count * this.itemManager.getItemPrice(451);
                break;
            }
            default: {
                log.debug("Invalid ore specified. The quantity and profit will not be updated.");
            }
        }
    }

    int getNuggetsCount() {
        return this.nuggetsCount;
    }

    int getCoalCount() {
        return this.coalCount;
    }

    int getGoldCount() {
        return this.goldCount;
    }

    int getMithrilCount() {
        return this.mithrilCount;
    }

    int getAdamantiteCount() {
        return this.adamantiteCount;
    }

    int getRuniteCount() {
        return this.runiteCount;
    }

    int getCoalProfit() {
        return this.coalProfit;
    }

    int getGoldProfit() {
        return this.goldProfit;
    }

    int getMithrilProfit() {
        return this.mithrilProfit;
    }

    int getAdamantiteProfit() {
        return this.adamantiteProfit;
    }

    int getRuniteProfit() {
        return this.runiteProfit;
    }
}

