/*
 * Decompiled with CFR 0.152.
 */
package com.motherlodeprofit;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.inject.Provides;
import com.motherlodeprofit.MotherlodeProfitConfig;
import com.motherlodeprofit.MotherlodeProfitOverlay;
import com.motherlodeprofit.MotherlodeProfitSession;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Motherlode Profit Tracker", description="Show profit collected at MLM", tags={"pay", "dirt", "mining", "mlm", "skilling", "overlay"}, enabledByDefault=true)
public class MotherlodeProfitPlugin
extends Plugin {
    private static final Set<Integer> MOTHERLODE_MAP_REGIONS = ImmutableSet.of((Object)14679, (Object)14680, (Object)14681, (Object)14935, (Object)14936, (Object)14937, (Object[])new Integer[]{15191, 15192, 15193});
    private static final Set<Integer> MLM_ORE_TYPES = ImmutableSet.of((Object)451, (Object)449, (Object)447, (Object)444, (Object)453, (Object)12012, (Object[])new Integer[0]);
    private static final int SACK_LARGE_SIZE = 162;
    private static final int SACK_SIZE = 81;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MotherlodeProfitOverlay motherlodeProfitOverlay;
    @Inject
    private MotherlodeProfitConfig config;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private boolean inMlm;
    private int curSackSize;
    private int maxSackSize;
    private Integer depositsLeft;
    @Inject
    private MotherlodeProfitSession session;
    private boolean shouldUpdateOres;
    private Multiset<Integer> inventorySnapshot;

    @Provides
    MotherlodeProfitConfig getConfig(ConfigManager configManager) {
        return (MotherlodeProfitConfig)configManager.getConfig(MotherlodeProfitConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.motherlodeProfitOverlay);
        this.inMlm = this.checkInMlm();
        if (this.inMlm) {
            this.clientThread.invokeLater(this::refreshSackValues);
        }
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.motherlodeProfitOverlay);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (this.inMlm) {
            ItemContainer itemContainer;
            int lastSackValue = this.curSackSize;
            this.refreshSackValues();
            boolean bl = this.shouldUpdateOres = this.curSackSize < lastSackValue;
            if (this.shouldUpdateOres && (itemContainer = this.client.getItemContainer(InventoryID.INVENTORY)) != null) {
                this.inventorySnapshot = HashMultiset.create();
                Arrays.stream(itemContainer.getItems()).filter(item -> MLM_ORE_TYPES.contains(item.getId())).forEach(item -> this.inventorySnapshot.add((Object)item.getId(), item.getQuantity()));
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.inMlm = this.checkInMlm();
        } else if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.inMlm = false;
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer container = event.getItemContainer();
        if (!this.inMlm || !this.shouldUpdateOres || this.inventorySnapshot == null || container != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        HashMultiset current = HashMultiset.create();
        Arrays.stream(container.getItems()).filter(item -> MLM_ORE_TYPES.contains(item.getId())).forEach(arg_0 -> MotherlodeProfitPlugin.lambda$onItemContainerChanged$3((Multiset)current, arg_0));
        Multiset delta = Multisets.difference((Multiset)current, this.inventorySnapshot);
        delta.forEachEntry(this.session::updateOreFound);
        this.inventorySnapshot = null;
        this.shouldUpdateOres = false;
    }

    private boolean checkInMlm() {
        int[] currentMapRegions;
        GameState gameState = this.client.getGameState();
        if (gameState != GameState.LOGGED_IN && gameState != GameState.LOADING) {
            return false;
        }
        for (int region : currentMapRegions = this.client.getMapRegions()) {
            if (MOTHERLODE_MAP_REGIONS.contains(region)) continue;
            return false;
        }
        return true;
    }

    private void refreshSackValues() {
        this.curSackSize = this.client.getVarbitValue(5558);
        boolean sackUpgraded = this.client.getVarbitValue(5556) == 1;
        this.maxSackSize = sackUpgraded ? 162 : 81;
    }

    boolean isInMlm() {
        return this.inMlm;
    }

    int getCurSackSize() {
        return this.curSackSize;
    }

    int getMaxSackSize() {
        return this.maxSackSize;
    }

    Integer getDepositsLeft() {
        return this.depositsLeft;
    }

    private static /* synthetic */ void lambda$onItemContainerChanged$3(Multiset current, Item item) {
        current.add((Object)item.getId(), item.getQuantity());
    }
}

