/*
 * Decompiled with CFR 0.152.
 */
package com.motherlodeprofit;

import com.motherlodeprofit.MotherlodeProfitConfig;
import com.motherlodeprofit.MotherlodeProfitPlugin;
import com.motherlodeprofit.MotherlodeProfitSession;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.inject.Inject;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.util.QuantityFormatter;

public class MotherlodeProfitOverlay
extends OverlayPanel {
    private final MotherlodeProfitPlugin plugin;
    private final MotherlodeProfitSession motherlodeProfitSession;
    private final MotherlodeProfitConfig config;
    private final ItemManager itemManager;
    private final long startTime;
    private int maxPanelWidth = 129;

    @Inject
    MotherlodeProfitOverlay(MotherlodeProfitPlugin plugin, MotherlodeProfitSession motherlodeProfitSession, MotherlodeProfitConfig config, ItemManager itemManager) {
        this.setPriority(OverlayPriority.HIGH);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.plugin = plugin;
        this.motherlodeProfitSession = motherlodeProfitSession;
        this.config = config;
        this.itemManager = itemManager;
        this.startTime = System.currentTimeMillis();
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInMlm()) {
            return null;
        }
        MotherlodeProfitSession session = this.motherlodeProfitSession;
        int totalProfit = session.getTotalProfit();
        int nuggetCount = session.getNuggetsCount();
        if (totalProfit == 0 && nuggetCount == 0) {
            return null;
        }
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Motherlode Tracker").color(Color.GREEN).build());
        this.panelComponent.setOrientation(ComponentOrientation.VERTICAL);
        if (this.config.showNuggets() && this.config.showQuantity() && nuggetCount > 0) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Nuggets:").right(String.valueOf(nuggetCount)).build());
        }
        this.maxPanelWidth = 129;
        this.addOreLine("Coal", session.getCoalCount(), session.getCoalProfit(), graphics);
        this.addOreLine("Gold", session.getGoldCount(), session.getGoldProfit(), graphics);
        this.addOreLine("Mithril", session.getMithrilCount(), session.getMithrilProfit(), graphics);
        this.addOreLine("Adamantite", session.getAdamantiteCount(), session.getAdamantiteProfit(), graphics);
        this.addOreLine("Runite", session.getRuniteCount(), session.getRuniteProfit(), graphics);
        if (this.config.showQuantity() || this.config.showProfit()) {
            this.panelComponent.getChildren().add(LineComponent.builder().build());
        }
        if (this.config.showProfitPerHour()) {
            double profitPerHour = this.calculateProfitPerHour(totalProfit);
            this.panelComponent.getChildren().add(LineComponent.builder().left("GP/H:").right(QuantityFormatter.quantityToRSDecimalStack((int)((int)profitPerHour)) + " GP").build());
        }
        if (totalProfit > 0) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Total:").right(this.formatIntegerWithCommas(totalProfit) + " GP").build());
        }
        this.panelComponent.setPreferredSize(new Dimension(this.maxPanelWidth, 0));
        return super.render(graphics);
    }

    private void addOreLine(String oreName, int oreCount, int oreProfit, Graphics2D graphics) {
        if (oreProfit > 0 && (this.config.showQuantity() || this.config.showProfit())) {
            String quantityString;
            Object object = this.config.showQuantity() ? oreCount + (this.config.showProfit() ? " x " : "") : (quantityString = "");
            String profitString = this.config.showProfit() ? (oreProfit > this.config.profitThreshold() && this.config.useRSDecimalStack() ? QuantityFormatter.quantityToRSDecimalStack((int)oreProfit) : this.formatIntegerWithCommas(oreProfit)) + " GP" : "";
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int panelWidth = Math.max(129, fontMetrics.stringWidth(oreName + ": " + quantityString + profitString) + 4 + 4);
            this.maxPanelWidth = Math.max(this.maxPanelWidth, panelWidth);
            this.panelComponent.getChildren().add(LineComponent.builder().left(oreName + ":").right(quantityString + profitString).build());
        }
    }

    private double calculateProfitPerHour(int totalProfit) {
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.startTime;
        double hoursElapsed = (double)elapsedTime / 3600000.0;
        return (double)totalProfit / hoursElapsed;
    }

    private String formatIntegerWithCommas(long value) {
        DecimalFormat df = new DecimalFormat("###,###,###");
        return df.format(value);
    }
}

