/*
 * Decompiled with CFR 0.152.
 */
package dekvall.leftclickonly;

import dekvall.leftclickonly.RightClickConsumer;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuOpened;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Left Click Only", description="Only allow leftclicks")
public class LeftClickOnlyPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LeftClickOnlyPlugin.class);
    @Inject
    private Client client;
    @Inject
    private RightClickConsumer rightClickConsumer;
    @Inject
    private MouseManager mouseManager;

    protected void startUp() throws Exception {
        log.info("Left Click Only started!");
        this.mouseManager.registerMouseListener((MouseListener)this.rightClickConsumer);
    }

    protected void shutDown() throws Exception {
        log.info("Left Click Only stopped!");
        this.mouseManager.unregisterMouseListener((MouseListener)this.rightClickConsumer);
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        MenuEntry first = event.getFirstEntry();
        this.client.setMenuEntries(new MenuEntry[]{first});
    }
}

