/*
 * Decompiled with CFR 0.152.
 */
package com.zom;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.zom.TOAKerisCamConfig;
import com.zom.TOAKerisCamOverlay;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.ImageUploadStyle;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.OSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Toa Keris Cam")
public class TOAKerisCamPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TOAKerisCamPlugin.class);
    @Inject
    private Client client;
    @Inject
    private TOAKerisCamConfig config;
    @Inject
    private DrawManager drawManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TOAKerisCamOverlay screenshotOverlay;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private SpriteManager spriteManager;
    private BufferedImage reportButton;
    @Inject
    private ClientUI clientUi;
    @Inject
    private ImageCapture imageCapture;
    private static final Set<Integer> REPORT_BUTTON_TLIS = ImmutableSet.of((Object)548, (Object)161, (Object)164);
    public static final String SD_KERIS = "Keris";
    private static final int KERIS_SPEC_ANIMID = 9546;
    private final int[] RAID_REGIONS = new int[]{15698, 15700, 14162, 14164, 15186, 15188, 14674, 14676, 15184, 15696, 14160};
    private int clientTickCounter;
    int currentRegion;
    int previousRegion;
    HashMap<String, Integer> playersKerised;
    boolean enabled;

    protected void startUp() throws Exception {
        this.currentRegion = -1;
        this.previousRegion = -1;
        this.enabled = false;
        this.clientTickCounter = 0;
        this.overlayManager.add((Overlay)this.screenshotOverlay);
        this.playersKerised = new HashMap();
        this.spriteManager.getSpriteAsync(3057, 0, s -> {
            this.reportButton = s;
        });
    }

    protected void shutDown() throws Exception {
        this.currentRegion = -1;
        this.previousRegion = -1;
        this.enabled = false;
        this.clientTickCounter = 0;
        this.playersKerised = null;
        this.overlayManager.remove((Overlay)this.screenshotOverlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equals("toa-keris-cam")) {
            return;
        }
        this.previousRegion = -1;
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (!this.enabled) {
            return;
        }
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        if (event.getActor().getAnimation() != 9546) {
            return;
        }
        if (event.getActor() == this.client.getLocalPlayer() && !this.config.selfie()) {
            return;
        }
        if (!this.playersKerised.containsKey(event.getActor().getName())) {
            this.playersKerised.put(event.getActor().getName(), this.clientTickCounter + 30);
        }
    }

    @Subscribe
    protected void onGameTick(GameTick t) {
        LocalPoint lp = this.client.getLocalPlayer().getLocalLocation();
        int n = this.currentRegion = lp == null ? -1 : WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)lp).getRegionID();
        if (Arrays.stream(this.RAID_REGIONS).noneMatch(region -> region == this.currentRegion)) {
            this.enabled = false;
            this.previousRegion = this.currentRegion;
            return;
        }
        if (this.currentRegion != this.previousRegion) {
            switch (this.currentRegion) {
                case 15698: {
                    this.enabled = this.config.crondis();
                    break;
                }
                case 15700: {
                    this.enabled = this.config.zebak();
                    break;
                }
                case 14162: {
                    this.enabled = this.config.scabaras();
                    break;
                }
                case 14164: {
                    this.enabled = this.config.kephri();
                    break;
                }
                case 15186: {
                    this.enabled = this.config.ampeken();
                    break;
                }
                case 15188: {
                    this.enabled = this.config.baba();
                    break;
                }
                case 14674: {
                    this.enabled = this.config.het();
                    break;
                }
                case 14676: {
                    this.enabled = this.config.akkha();
                    break;
                }
                case 15184: 
                case 15696: {
                    this.enabled = this.config.wardens();
                    break;
                }
                case 14160: {
                    this.enabled = true;
                    break;
                }
                default: {
                    this.enabled = false;
                }
            }
        }
        this.previousRegion = this.currentRegion;
    }

    @Subscribe
    protected void onClientTick(ClientTick t) {
        ++this.clientTickCounter;
        if (this.playersKerised.isEmpty()) {
            return;
        }
        this.playersKerised.entrySet().removeIf(p -> this.tookPicture((String)p.getKey()));
    }

    private boolean tookPicture(String playerName) {
        if (this.playersKerised.get(playerName) > this.clientTickCounter) {
            return false;
        }
        this.takeScreenshot("Keris " + playerName, SD_KERIS);
        return true;
    }

    void takeScreenshot(String fileName, String subDir) {
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            log.info("Login screenshot prevented");
            return;
        }
        Consumer<Image> imageCallback = img -> this.executor.submit(() -> this.takeScreenshot(fileName, subDir, (Image)img));
        if (this.config.displayDate() && REPORT_BUTTON_TLIS.contains(this.client.getTopLevelInterfaceId())) {
            this.screenshotOverlay.queueForTimestamp(imageCallback);
        } else {
            this.drawManager.requestNextFrameListener(imageCallback);
        }
    }

    private static int getScaledValue(double scale, int value) {
        return (int)((double)value * scale + 0.5);
    }

    private void takeScreenshot(String fileName, String subDir, Image image) {
        BufferedImage screenshot;
        if (!this.config.includeFrame()) {
            screenshot = ImageUtil.bufferedImageFromImage((Image)image);
        } else {
            AffineTransform transform = OSType.getOSType() == OSType.MacOS ? new AffineTransform() : this.clientUi.getGraphicsConfiguration().getDefaultTransform();
            int clientWidth = TOAKerisCamPlugin.getScaledValue(transform.getScaleX(), this.clientUi.getWidth());
            int clientHeight = TOAKerisCamPlugin.getScaledValue(transform.getScaleY(), this.clientUi.getHeight());
            screenshot = new BufferedImage(clientWidth, clientHeight, 2);
            Graphics2D graphics = (Graphics2D)screenshot.getGraphics();
            AffineTransform originalTransform = graphics.getTransform();
            graphics.setTransform(transform);
            try {
                SwingUtilities.invokeAndWait(() -> this.clientUi.paint((Graphics)graphics));
            }
            catch (InterruptedException | InvocationTargetException e) {
                log.warn("unable to paint client UI on screenshot", (Throwable)e);
            }
            Point canvasOffset = this.clientUi.getCanvasOffset();
            int gameOffsetX = TOAKerisCamPlugin.getScaledValue(transform.getScaleX(), canvasOffset.getX());
            int gameOffsetY = TOAKerisCamPlugin.getScaledValue(transform.getScaleY(), canvasOffset.getY());
            graphics.setTransform(originalTransform);
            graphics.drawImage(image, gameOffsetX, gameOffsetY, null);
            graphics.dispose();
        }
        this.imageCapture.takeScreenshot(screenshot, fileName, subDir, this.config.notifyWhenTaken(), this.config.copyToClipboard() ? ImageUploadStyle.CLIPBOARD : ImageUploadStyle.NEITHER);
    }

    @Provides
    TOAKerisCamConfig provideConfig(ConfigManager configManager) {
        return (TOAKerisCamConfig)configManager.getConfig(TOAKerisCamConfig.class);
    }

    BufferedImage getReportButton() {
        return this.reportButton;
    }
}

