/*
 * Decompiled with CFR 0.152.
 */
package dev.davidv.prifddinas;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Prifddinas", description="Removes scenery from Prifddinas to improve performance")
public class PrifddinasPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PrifddinasPlugin.class);
    private static final Set<Integer> HIDE = ImmutableSet.of((Object)8770, (Object)36672, (Object)36674, (Object)37975, (Object)36550, (Object)36551, (Object[])new Integer[]{36549, 36492, 3906, 3904, 3902, 1196, 3901, 1198});
    private static final Set<Integer> ElvenMapRegions = ImmutableSet.of((Object)8756, (Object)8757, (Object)9012, (Object)9013, (Object)9268, (Object)9269, (Object[])new Integer[]{12638, 12639, 12640, 12894, 12895, 12896, 13150, 13151, 13152, 8758, 9014, 9270});
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;

    protected void startUp() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invoke(this::hide);
        }
    }

    protected void shutDown() {
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.client.setGameState(GameState.LOADING);
            }
        });
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.hide();
        }
    }

    private void hide() {
        if (!this.isInPrif()) {
            return;
        }
        Scene scene = this.client.getScene();
        Tile[][] tiles = scene.getTiles()[0];
        Player player = this.client.getLocalPlayer();
        int cnt = 0;
        for (int x = 0; x < 104; ++x) {
            block1: for (int y = 0; y < 104; ++y) {
                Tile tile = tiles[x][y];
                if (tile == null) continue;
                for (GameObject gameObject : tile.getGameObjects()) {
                    if (gameObject == null || !HIDE.contains(gameObject.getId())) continue;
                    scene.removeGameObject(gameObject);
                    ++cnt;
                    continue block1;
                }
            }
        }
        log.debug("Removed {} objects", (Object)cnt);
    }

    private boolean isInPrif() {
        Integer[] asd = ArrayUtils.toObject((int[])this.client.getMapRegions());
        HashSet<Integer> currentRegions = new HashSet<Integer>(Arrays.asList(asd));
        currentRegions.retainAll(ElvenMapRegions);
        return currentRegions.stream().count() > 0L;
    }
}

