/*
 * Decompiled with CFR 0.152.
 */
package dev.dkvl.gunsgains;

import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import net.runelite.api.NPC;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="The Guns' Gains")
public class TheGunsGainsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TheGunsGainsPlugin.class);
    private static ZonedDateTime RELEASE_DATE = ZonedDateTime.of(2007, 2, 19, 11, 0, 0, 0, ZoneId.of("GMT"));
    private NPC theGuns;

    protected void startUp() throws Exception {
        log.info("The Guns' Gains started!");
    }

    protected void shutDown() throws Exception {
        this.theGuns = null;
        log.info("The Guns' Gains stopped!");
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (event.getNpc().getId() == 3599) {
            this.theGuns = event.getNpc();
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (event.getNpc().getId() == 3599) {
            this.theGuns = null;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.theGuns != null) {
            this.theGuns.setOverheadText(this.calculateRepCount());
        }
    }

    private String calculateRepCount() {
        long millis = ChronoUnit.MILLIS.between(RELEASE_DATE, ZonedDateTime.now(ZoneId.of("GMT")));
        long reps = millis * 100L / 180000L;
        return NumberFormat.getNumberInstance(Locale.US).format(reps);
    }
}

