/*
 * Decompiled with CFR 0.152.
 */
package com.bankmultisearch;

import com.bankmultisearch.BankMultisearchConfig;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bank slot/multisearch", tags={"search", "utility", "utilties"})
public class BankMultisearchPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BankMultisearchPlugin.class);
    @Inject
    private Client client;
    @Inject
    private BankMultisearchConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    private String lastSearch = "";
    private List<String> split = Collections.emptyList();
    private int slotsBitfield = 0;
    private Boolean twohand = null;

    @Subscribe(priority=-1.0f)
    public void onScriptCallbackEvent(ScriptCallbackEvent e) {
        if (!"bankSearchFilter".equals(e.getEventName())) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        String[] stringStack = this.client.getStringStack();
        int intStackSize = this.client.getIntStackSize();
        int stringStackSize = this.client.getStringStackSize();
        String search = stringStack[stringStackSize - 1];
        if (search.isEmpty()) {
            return;
        }
        this.updateSearch(search);
        int itemId = intStack[intStackSize - 1];
        if (this.slotsBitfield != 0) {
            ItemStats itemStats = this.itemManager.getItemStats(itemId, false);
            boolean wrongSlot = itemStats == null || !itemStats.isEquipable() || (this.slotsBitfield & 1 << itemStats.getEquipment().getSlot()) == 0 || itemStats.getEquipment().getSlot() == EquipmentInventorySlot.WEAPON.getSlotIdx() && this.twohand != null && itemStats.getEquipment().isTwoHanded() != this.twohand.booleanValue();
            int n = intStack[intStackSize - 2] = wrongSlot ? 0 : 1;
            if (wrongSlot) {
                return;
            }
        }
        if (this.split != null) {
            intStack[intStackSize - 2] = 0;
            String itemName = this.itemManager.getItemComposition(itemId).getName().toLowerCase();
            for (String s : this.split) {
                if (!itemName.contains(s)) continue;
                intStack[intStackSize - 2] = 1;
                break;
            }
        }
    }

    private void updateSearch(String search) {
        if (search.equals(this.lastSearch)) {
            return;
        }
        this.lastSearch = search;
        this.split = null;
        this.slotsBitfield = 0;
        this.twohand = null;
        if (search.matches(".*[<>=].*")) {
            return;
        }
        this.split = new ArrayList<String>(Arrays.asList(search.toLowerCase().split("\\s+")));
        if (this.config.slotSearchEnabled()) {
            for (int i = 0; i < this.split.size(); ++i) {
                String s = this.split.get(i);
                if (s.endsWith("slot")) {
                    s = s.substring(0, s.length() - "slot".length());
                }
                boolean found = true;
                switch (s) {
                    case "leg": 
                    case "legs": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.LEGS.getSlotIdx();
                        break;
                    }
                    case "chest": 
                    case "body": 
                    case "torso": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.BODY.getSlotIdx();
                        break;
                    }
                    case "glove": 
                    case "gloves": 
                    case "hand": 
                    case "hands": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.GLOVES.getSlotIdx();
                        break;
                    }
                    case "head": 
                    case "helm": 
                    case "hat": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.HEAD.getSlotIdx();
                        break;
                    }
                    case "boot": 
                    case "boots": 
                    case "foot": 
                    case "feet": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.BOOTS.getSlotIdx();
                        break;
                    }
                    case "amulet": 
                    case "necklace": 
                    case "neck": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.AMULET.getSlotIdx();
                        break;
                    }
                    case "ring": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.RING.getSlotIdx();
                        break;
                    }
                    case "shield": 
                    case "offhand": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.SHIELD.getSlotIdx();
                        break;
                    }
                    case "cape": 
                    case "cloak": 
                    case "back": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.CAPE.getSlotIdx();
                        break;
                    }
                    case "ammo": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.AMMO.getSlotIdx();
                        break;
                    }
                    case "weapon": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.WEAPON.getSlotIdx();
                        break;
                    }
                    case "1h": 
                    case "mainhand": 
                    case "1hweapon": 
                    case "weaponslot1h": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.WEAPON.getSlotIdx();
                        this.twohand = Boolean.FALSE;
                        break;
                    }
                    case "2h": 
                    case "2hweapon": 
                    case "weaponslot2h": {
                        this.slotsBitfield |= 1 << EquipmentInventorySlot.WEAPON.getSlotIdx();
                        this.twohand = Boolean.TRUE;
                        break;
                    }
                    default: {
                        found = false;
                    }
                }
                if (!found) continue;
                this.split.remove(i);
                --i;
            }
        }
        if (!this.config.multiSearchEnabled() && this.slotsBitfield == 0 || this.split.size() == 0) {
            this.split = null;
        }
    }

    public void startUp() {
        this.migrate();
    }

    @Subscribe
    public void onProfileChanged(ProfileChanged e) {
        this.migrate();
    }

    public void migrate() {
        this.configManager.setConfiguration("bankmultisearch", "serialVersion", (Object)0);
    }

    @Provides
    BankMultisearchConfig provideConfig(ConfigManager configManager) {
        return (BankMultisearchConfig)configManager.getConfig(BankMultisearchConfig.class);
    }
}

