/*
 * Decompiled with CFR 0.152.
 */
package com.toasupplies;

import com.google.inject.Provides;
import com.toasupplies.RaidsPotions;
import com.toasupplies.ToaSuppliesConfig;
import com.toasupplies.ToaSuppliesOverlay;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Toa Supplies")
public class ToaSuppliesPlugin
extends Plugin {
    private final int SUPPLY_ID = 810;
    private boolean checkSnapshot = false;
    private int waitTicks = 1;
    private final Map<Integer, Integer> itemHash = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> inventorySnapshot = new HashMap<Integer, Integer>();
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ToaSuppliesOverlay overlay;
    @Inject
    private Client client;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() != 778) {
            return;
        }
        this.updateValue(this.itemHash, 810);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != 810) {
            return;
        }
        this.updateValue(this.itemHash, 810);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getWidget() != null) {
            if (event.getWidget().getItemId() == 27314 && (event.getMenuOption().equals("Withdraw 1") || event.getMenuOption().equals("Withdraw All") || event.getMenuOption().equals("Resupply"))) {
                if (this.updateValue(this.inventorySnapshot, InventoryID.INVENTORY.getId()).booleanValue()) {
                    this.checkSnapshot = true;
                }
            } else if (event.getMenuOption().equals("Use") && event.getMenuAction() == MenuAction.WIDGET_TARGET_ON_WIDGET && this.client.getSelectedWidget() != null) {
                int firstSelectedItemID = this.client.getSelectedWidget().getItemId();
                int secondSelectedItemID = event.getWidget().getItemId();
                RaidsPotions raidsPotion = RaidsPotions.findItem(firstSelectedItemID);
                if (raidsPotion != null && secondSelectedItemID == 27314) {
                    this.itemHash.merge(raidsPotion.getPotionType(), raidsPotion.getCharges(), Integer::sum);
                }
            }
        }
    }

    @Subscribe
    private void onGameTick(GameTick event) {
        if (!this.checkSnapshot) {
            return;
        }
        if (this.waitTicks > 0) {
            --this.waitTicks;
            return;
        }
        this.checkSnapshot = false;
        this.waitTicks = 1;
        Set<Integer> prevInventoryItemIdsSet = this.inventorySnapshot.keySet();
        LinkedHashMap<Integer, Integer> currentInventoryHash = new LinkedHashMap<Integer, Integer>();
        this.updateValue(currentInventoryHash, InventoryID.INVENTORY.getId());
        Set currentInventoryItemIdsSet = currentInventoryHash.keySet();
        HashSet<Integer> allPossibleItemIds = new HashSet<Integer>();
        allPossibleItemIds.addAll(prevInventoryItemIdsSet);
        allPossibleItemIds.addAll(currentInventoryItemIdsSet);
        for (Integer itemId : allPossibleItemIds) {
            int prevAmount = this.inventorySnapshot.get(itemId) != null ? this.inventorySnapshot.get(itemId) : 0;
            int currentAmount = currentInventoryHash.get(itemId) != null ? (Integer)currentInventoryHash.get(itemId) : 0;
            int changeAmount = prevAmount - currentAmount;
            this.itemHash.merge(itemId, changeAmount, Integer::sum);
        }
    }

    private Boolean updateValue(Map<Integer, Integer> hashMap, int inventoryId) {
        ItemContainer itemContainer = this.client.getItemContainer(inventoryId);
        if (itemContainer == null) {
            return false;
        }
        hashMap.clear();
        Arrays.stream(itemContainer.getItems()).filter(item -> RaidsPotions.findItem(item.getId()) != null).forEach(i -> hashMap.merge(RaidsPotions.findItem(i.getId()).getPotionType(), RaidsPotions.findItem(i.getId()).getCharges(), Integer::sum));
        return true;
    }

    public int getAmount(int id) {
        return this.itemHash.get(id) != null ? this.itemHash.get(id) : 0;
    }

    @Provides
    ToaSuppliesConfig provideConfig(ConfigManager configManager) {
        return (ToaSuppliesConfig)configManager.getConfig(ToaSuppliesConfig.class);
    }
}

