/*
 * Decompiled with CFR 0.152.
 */
package com.toasupplies;

import com.toasupplies.ToaSuppliesConfig;
import com.toasupplies.ToaSuppliesPlugin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.math.BigDecimal;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.overlay.WidgetItemOverlay;

class ToaSuppliesOverlay
extends WidgetItemOverlay {
    private final ToaSuppliesConfig config;
    private final ToaSuppliesPlugin plugin;
    private static final int[] potions = new int[]{27315, 27327, 27347};
    private static final int[] potionMax = new int[]{4, 4, 2};
    private static final Color[] potionColors = new Color[]{Color.yellow, Color.magenta, Color.white};

    @Inject
    ToaSuppliesOverlay(ToaSuppliesConfig config, ToaSuppliesPlugin plugin) {
        this.config = config;
        this.plugin = plugin;
        this.showOnInventory();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        if (itemId != 27314) {
            return;
        }
        for (int i = 0; i < potions.length; ++i) {
            String text;
            BigDecimal amount = BigDecimal.valueOf(this.plugin.getAmount(potions[i]));
            if (this.config.showSips()) {
                text = "" + amount;
                this.drawString(graphics, text, widgetItem, potionColors[i], i);
                continue;
            }
            text = "" + amount.divide(BigDecimal.valueOf(potionMax[i]));
            this.drawString(graphics, text, widgetItem, potionColors[i], i);
        }
    }

    private void drawString(Graphics2D graphics, String text, WidgetItem widgetItem, Color color, int i) {
        graphics.setColor(color);
        graphics.drawString(text, widgetItem.getCanvasBounds().x, widgetItem.getCanvasBounds().y + 10 + i * 10);
    }
}

