/*
 * Decompiled with CFR 0.152.
 */
package com.betternpchighlight;

import com.betternpchighlight.BetterNpcHighlightConfig;
import com.betternpchighlight.BetterNpcHighlightPlugin;
import com.betternpchighlight.HighlightColor;
import net.runelite.api.NPC;
import net.runelite.client.plugins.slayer.SlayerPluginService;

public class NPCInfo {
    NPC npc;
    HighlightColor tile;
    HighlightColor trueTile;
    HighlightColor swTile;
    HighlightColor swTrueTile;
    HighlightColor hull;
    HighlightColor area;
    HighlightColor outline;
    HighlightColor clickbox;
    HighlightColor turbo;
    boolean isTask;
    boolean ignoreDead;

    public NPCInfo(NPC npc, BetterNpcHighlightPlugin plugin, SlayerPluginService slayerPluginService, BetterNpcHighlightConfig config) {
        this.npc = npc;
        this.tile = plugin.checkSpecificList(plugin.tileNames, plugin.tileIds, npc, config.tileColor(), config.tileFillColor());
        this.trueTile = plugin.checkSpecificList(plugin.trueTileNames, plugin.trueTileIds, npc, config.trueTileColor(), config.trueTileFillColor());
        this.swTile = plugin.checkSpecificList(plugin.swTileNames, plugin.swTileIds, npc, config.swTileColor(), config.swTileFillColor());
        this.swTrueTile = plugin.checkSpecificList(plugin.swTrueTileNames, plugin.swTrueTileIds, npc, config.swTrueTileColor(), config.swTrueTileFillColor());
        this.hull = plugin.checkSpecificList(plugin.hullNames, plugin.hullIds, npc, config.hullColor(), config.hullFillColor());
        this.area = plugin.checkSpecificList(plugin.areaNames, plugin.areaIds, npc, config.areaColor(), null);
        this.outline = plugin.checkSpecificList(plugin.outlineNames, plugin.outlineIds, npc, config.outlineColor(), null);
        this.clickbox = plugin.checkSpecificList(plugin.clickboxNames, plugin.clickboxIds, npc, config.clickboxColor(), config.clickboxFillColor());
        this.turbo = plugin.checkSpecificList(plugin.turboNames, plugin.turboIds, npc, null, null);
        this.isTask = plugin.checkSlayerPluginEnabled() && slayerPluginService != null && slayerPluginService.getTargets().contains(npc);
        this.ignoreDead = plugin.checkSpecificNameList(plugin.ignoreDeadExclusionList, npc) || plugin.checkSpecificIdList(plugin.ignoreDeadExclusionIDList, npc);
    }

    public NPC getNpc() {
        return this.npc;
    }

    public HighlightColor getTile() {
        return this.tile;
    }

    public HighlightColor getTrueTile() {
        return this.trueTile;
    }

    public HighlightColor getSwTile() {
        return this.swTile;
    }

    public HighlightColor getSwTrueTile() {
        return this.swTrueTile;
    }

    public HighlightColor getHull() {
        return this.hull;
    }

    public HighlightColor getArea() {
        return this.area;
    }

    public HighlightColor getOutline() {
        return this.outline;
    }

    public HighlightColor getClickbox() {
        return this.clickbox;
    }

    public HighlightColor getTurbo() {
        return this.turbo;
    }

    public boolean isTask() {
        return this.isTask;
    }

    public boolean isIgnoreDead() {
        return this.ignoreDead;
    }

    public void setNpc(NPC npc) {
        this.npc = npc;
    }

    public void setTile(HighlightColor tile) {
        this.tile = tile;
    }

    public void setTrueTile(HighlightColor trueTile) {
        this.trueTile = trueTile;
    }

    public void setSwTile(HighlightColor swTile) {
        this.swTile = swTile;
    }

    public void setSwTrueTile(HighlightColor swTrueTile) {
        this.swTrueTile = swTrueTile;
    }

    public void setHull(HighlightColor hull) {
        this.hull = hull;
    }

    public void setArea(HighlightColor area) {
        this.area = area;
    }

    public void setOutline(HighlightColor outline) {
        this.outline = outline;
    }

    public void setClickbox(HighlightColor clickbox) {
        this.clickbox = clickbox;
    }

    public void setTurbo(HighlightColor turbo) {
        this.turbo = turbo;
    }

    public void setTask(boolean isTask) {
        this.isTask = isTask;
    }

    public void setIgnoreDead(boolean ignoreDead) {
        this.ignoreDead = ignoreDead;
    }
}

