/*
 * Decompiled with CFR 0.152.
 */
package com.betternpchighlight;

import com.betternpchighlight.BetterNpcHighlightConfig;
import com.betternpchighlight.BetterNpcHighlightPlugin;
import com.betternpchighlight.NPCInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.Text;

public class BetterNpcMinimapOverlay
extends Overlay {
    private final Client client;
    private final BetterNpcHighlightPlugin plugin;
    private final BetterNpcHighlightConfig config;

    @Inject
    private BetterNpcMinimapOverlay(Client client, BetterNpcHighlightPlugin plugin, BetterNpcHighlightConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        for (NPCInfo npcInfo : this.plugin.npcList) {
            Point minimapLocation;
            NPC npc = npcInfo.getNpc();
            if (npc.getName() == null || this.config.npcMinimapMode() == BetterNpcHighlightConfig.npcMinimapMode.OFF) continue;
            Color color = this.plugin.getSpecificColor(npcInfo);
            NPCComposition npcComposition = npc.getTransformedComposition();
            if (color == null || npcComposition == null || !npcComposition.isInteractible() || (minimapLocation = npc.getMinimapLocation()) == null) continue;
            if (this.config.npcMinimapMode() == BetterNpcHighlightConfig.npcMinimapMode.DOT || this.config.npcMinimapMode() == BetterNpcHighlightConfig.npcMinimapMode.BOTH) {
                OverlayUtil.renderMinimapLocation((Graphics2D)graphics, (Point)minimapLocation, (Color)color);
            }
            if (this.config.npcMinimapMode() != BetterNpcHighlightConfig.npcMinimapMode.NAME && this.config.npcMinimapMode() != BetterNpcHighlightConfig.npcMinimapMode.BOTH) continue;
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)minimapLocation, (String)Text.removeTags((String)npc.getName()), (Color)color);
        }
        return null;
    }
}

