/*
 * Decompiled with CFR 0.152.
 */
package com.betternpchighlight;

import com.betternpchighlight.BetterNpcHighlightConfig;
import com.betternpchighlight.BetterNpcHighlightOverlay;
import com.betternpchighlight.BetterNpcMinimapOverlay;
import com.betternpchighlight.HighlightColor;
import com.betternpchighlight.NPCInfo;
import com.betternpchighlight.NpcSpawn;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.Renderable;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.vars.InputType;
import net.runelite.client.callback.Hooks;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.NpcUtil;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.slayer.SlayerPlugin;
import net.runelite.client.plugins.slayer.SlayerPluginService;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Better NPC Highlight", description="A more customizable NPC highlight", tags={"npc", "highlight", "indicators", "respawn", "hide", "entity", "custom", "id", "name"})
@PluginDependency(value=SlayerPlugin.class)
public class BetterNpcHighlightPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(BetterNpcHighlightPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BetterNpcHighlightOverlay overlay;
    @Inject
    private BetterNpcHighlightConfig config;
    @Inject
    private BetterNpcMinimapOverlay mapOverlay;
    @Inject
    private NpcUtil npcUtil;
    @Inject
    private ConfigManager configManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private Hooks hooks;
    @Inject
    private SlayerPluginService slayerPluginService;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    private static final Set<MenuAction> NPC_MENU_ACTIONS = ImmutableSet.of((Object)MenuAction.NPC_FIRST_OPTION, (Object)MenuAction.NPC_SECOND_OPTION, (Object)MenuAction.NPC_THIRD_OPTION, (Object)MenuAction.NPC_FOURTH_OPTION, (Object)MenuAction.NPC_FIFTH_OPTION, (Object)MenuAction.WIDGET_TARGET_ON_NPC, (Object[])new MenuAction[]{MenuAction.ITEM_USE_ON_NPC});
    public ArrayList<NPCInfo> npcList = new ArrayList();
    public String currentTask = "";
    public ArrayList<String> tileNames = new ArrayList();
    public ArrayList<String> tileIds = new ArrayList();
    public ArrayList<String> trueTileNames = new ArrayList();
    public ArrayList<String> trueTileIds = new ArrayList();
    public ArrayList<String> swTileNames = new ArrayList();
    public ArrayList<String> swTileIds = new ArrayList();
    public ArrayList<String> swTrueTileNames = new ArrayList();
    public ArrayList<String> swTrueTileIds = new ArrayList();
    public ArrayList<String> hullNames = new ArrayList();
    public ArrayList<String> hullIds = new ArrayList();
    public ArrayList<String> areaNames = new ArrayList();
    public ArrayList<String> areaIds = new ArrayList();
    public ArrayList<String> outlineNames = new ArrayList();
    public ArrayList<String> outlineIds = new ArrayList();
    public ArrayList<String> clickboxNames = new ArrayList();
    public ArrayList<String> clickboxIds = new ArrayList();
    public ArrayList<String> turboNames = new ArrayList();
    public ArrayList<String> turboIds = new ArrayList();
    public ArrayList<Color> turboColors = new ArrayList();
    public ArrayList<NpcSpawn> npcSpawns = new ArrayList();
    public ArrayList<String> namesToDisplay = new ArrayList();
    public ArrayList<String> ignoreDeadExclusionList = new ArrayList();
    public ArrayList<String> ignoreDeadExclusionIDList = new ArrayList();
    public ArrayList<String> hiddenNames = new ArrayList();
    public ArrayList<String> hiddenIds = new ArrayList();
    public ArrayList<String> beneathNPCs = new ArrayList();
    public Instant lastTickUpdate;
    public int turboModeStyle = 0;
    public int turboTileWidth = 0;
    public int turboOutlineWidth = 0;
    public int turboOutlineFeather = 0;
    public boolean confirmedWarning = false;
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;
    private static final String HIDE_COMMAND = "!hide";
    private static final String UNHIDE_COMMAND = "!unhide";
    private static final String TAG_COMMAND = "!tag";
    private static final String UNTAG_COMMAND = "!untag";

    @Provides
    BetterNpcHighlightConfig providesConfig(ConfigManager configManager) {
        return (BetterNpcHighlightConfig)configManager.getConfig(BetterNpcHighlightConfig.class);
    }

    protected void startUp() {
        this.reset();
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.mapOverlay);
        this.splitList(this.config.tileNames(), this.tileNames);
        this.splitList(this.config.tileIds(), this.tileIds);
        this.splitList(this.config.trueTileNames(), this.trueTileNames);
        this.splitList(this.config.trueTileIds(), this.trueTileIds);
        this.splitList(this.config.swTileNames(), this.swTileNames);
        this.splitList(this.config.swTileIds(), this.swTileIds);
        this.splitList(this.config.swTrueTileNames(), this.swTrueTileNames);
        this.splitList(this.config.swTrueTileIds(), this.swTrueTileIds);
        this.splitList(this.config.hullNames(), this.hullNames);
        this.splitList(this.config.hullIds(), this.hullIds);
        this.splitList(this.config.areaNames(), this.areaNames);
        this.splitList(this.config.areaIds(), this.areaIds);
        this.splitList(this.config.outlineNames(), this.outlineNames);
        this.splitList(this.config.outlineIds(), this.outlineIds);
        this.splitList(this.config.clickboxNames(), this.clickboxNames);
        this.splitList(this.config.clickboxIds(), this.clickboxIds);
        this.splitList(this.config.turboNames(), this.turboNames);
        this.splitList(this.config.turboIds(), this.turboIds);
        this.splitList(this.config.displayName(), this.namesToDisplay);
        this.splitList(this.config.ignoreDeadExclusion(), this.ignoreDeadExclusionList);
        this.splitList(this.config.ignoreDeadExclusionID(), this.ignoreDeadExclusionIDList);
        this.splitList(this.config.entityHiderNames(), this.hiddenNames);
        this.splitList(this.config.entityHiderIds(), this.hiddenIds);
        this.splitList(this.config.drawBeneathList(), this.beneathNPCs);
        this.hooks.registerRenderableDrawListener(this.drawListener);
        this.keyManager.registerKeyListener((KeyListener)this);
        this.enableSlayerPlugin();
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.recreateList();
        }
    }

    protected void shutDown() {
        this.reset();
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.mapOverlay);
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
        this.keyManager.unregisterKeyListener((KeyListener)this);
    }

    private void reset() {
        this.npcList.clear();
        this.currentTask = "";
        this.tileNames.clear();
        this.tileIds.clear();
        this.trueTileNames.clear();
        this.trueTileIds.clear();
        this.swTileNames.clear();
        this.swTileIds.clear();
        this.swTrueTileNames.clear();
        this.swTrueTileIds.clear();
        this.hullNames.clear();
        this.hullIds.clear();
        this.areaNames.clear();
        this.areaIds.clear();
        this.outlineNames.clear();
        this.outlineIds.clear();
        this.clickboxNames.clear();
        this.clickboxIds.clear();
        this.turboNames.clear();
        this.turboIds.clear();
        this.hiddenNames.clear();
        this.hiddenIds.clear();
        this.beneathNPCs.clear();
        this.ignoreDeadExclusionList.clear();
        this.ignoreDeadExclusionIDList.clear();
        this.namesToDisplay.clear();
        this.npcSpawns.clear();
        this.turboModeStyle = 0;
        this.turboTileWidth = 0;
        this.turboOutlineWidth = 0;
        this.turboOutlineFeather = 0;
        this.confirmedWarning = false;
    }

    private void splitList(String configStr, ArrayList<String> strList) {
        if (!configStr.equals("")) {
            for (String str : configStr.split(",")) {
                if (str.trim().equals("")) continue;
                strList.add(str.trim().toLowerCase());
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("BetterNpcHighlight")) {
            switch (event.getKey()) {
                case "tileNames": {
                    this.tileNames.clear();
                    this.splitList(this.config.tileNames(), this.tileNames);
                    this.recreateList();
                    break;
                }
                case "tileIds": {
                    this.tileIds.clear();
                    this.splitList(this.config.tileIds(), this.tileIds);
                    this.recreateList();
                    break;
                }
                case "trueTileNames": {
                    this.trueTileNames.clear();
                    this.splitList(this.config.trueTileNames(), this.trueTileNames);
                    this.recreateList();
                    break;
                }
                case "trueTileIds": {
                    this.trueTileIds.clear();
                    this.splitList(this.config.trueTileIds(), this.trueTileIds);
                    this.recreateList();
                    break;
                }
                case "swTileNames": {
                    this.swTileNames.clear();
                    this.splitList(this.config.swTileNames(), this.swTileNames);
                    this.recreateList();
                    break;
                }
                case "swTileIds": {
                    this.swTileIds.clear();
                    this.splitList(this.config.swTileIds(), this.swTileIds);
                    this.recreateList();
                    break;
                }
                case "swTrueTileNames": {
                    this.swTrueTileNames.clear();
                    this.splitList(this.config.swTrueTileNames(), this.swTrueTileNames);
                    this.recreateList();
                    break;
                }
                case "swTrueTileIds": {
                    this.swTrueTileIds.clear();
                    this.splitList(this.config.swTrueTileIds(), this.swTrueTileIds);
                    this.recreateList();
                    break;
                }
                case "hullNames": {
                    this.hullNames.clear();
                    this.splitList(this.config.hullNames(), this.hullNames);
                    this.recreateList();
                    break;
                }
                case "hullIds": {
                    this.hullIds.clear();
                    this.splitList(this.config.hullIds(), this.hullIds);
                    this.recreateList();
                    break;
                }
                case "areaNames": {
                    this.areaNames.clear();
                    this.splitList(this.config.areaNames(), this.areaNames);
                    this.recreateList();
                    break;
                }
                case "areaIds": {
                    this.areaIds.clear();
                    this.splitList(this.config.areaIds(), this.areaIds);
                    this.recreateList();
                    break;
                }
                case "outlineNames": {
                    this.outlineNames.clear();
                    this.splitList(this.config.outlineNames(), this.outlineNames);
                    this.recreateList();
                    break;
                }
                case "outlineIds": {
                    this.outlineIds.clear();
                    this.splitList(this.config.outlineIds(), this.outlineIds);
                    this.recreateList();
                    break;
                }
                case "clickboxNames": {
                    this.clickboxNames.clear();
                    this.splitList(this.config.clickboxNames(), this.clickboxNames);
                    this.recreateList();
                    break;
                }
                case "clickboxIds": {
                    this.clickboxIds.clear();
                    this.splitList(this.config.clickboxIds(), this.clickboxIds);
                    this.recreateList();
                    break;
                }
                case "turboNames": {
                    this.turboNames.clear();
                    this.splitList(this.config.turboNames(), this.turboNames);
                    this.recreateList();
                    break;
                }
                case "turboIds": {
                    this.turboIds.clear();
                    this.splitList(this.config.turboIds(), this.turboIds);
                    this.recreateList();
                    break;
                }
                case "displayName": {
                    this.namesToDisplay.clear();
                    this.splitList(this.config.displayName(), this.namesToDisplay);
                    break;
                }
                case "ignoreDeadExclusion": {
                    this.ignoreDeadExclusionList.clear();
                    this.splitList(this.config.ignoreDeadExclusion(), this.ignoreDeadExclusionList);
                    this.recreateList();
                    break;
                }
                case "ignoreDeadExclusionID": {
                    this.ignoreDeadExclusionIDList.clear();
                    this.splitList(this.config.ignoreDeadExclusionID(), this.ignoreDeadExclusionIDList);
                    this.recreateList();
                    break;
                }
                case "turboHighlight": {
                    if (!event.getNewValue().equals("true")) break;
                    if (!this.confirmedWarning) {
                        this.showEpilepsyWarning();
                        break;
                    }
                    this.confirmedWarning = false;
                    break;
                }
                case "entityHiderNames": {
                    this.hiddenNames.clear();
                    this.splitList(this.config.entityHiderNames(), this.hiddenNames);
                    break;
                }
                case "entityHiderIds": {
                    this.hiddenIds.clear();
                    this.splitList(this.config.entityHiderIds(), this.hiddenIds);
                    break;
                }
                case "drawBeneathList": {
                    this.beneathNPCs.clear();
                    this.splitList(this.config.drawBeneathList(), this.beneathNPCs);
                    break;
                }
                case "slayerHighlight": {
                    this.enableSlayerPlugin();
                    break;
                }
                case "tileColor": 
                case "tileFillColor": 
                case "trueTileColor": 
                case "trueTileFillColor": 
                case "swTileColor": 
                case "swTileFillColor": 
                case "swTrueTileColor": 
                case "swTrueTileFillColor": 
                case "hullColor": 
                case "hullFillColor": 
                case "areaColor": 
                case "outlineColor": 
                case "clickboxColor": 
                case "clickboxFillColor": 
                case "taskColor": 
                case "taskFillColor": 
                case "presetColor1": 
                case "presetFillColor1": 
                case "presetColor2": 
                case "presetFillColor2": 
                case "presetColor3": 
                case "presetFillColor3": 
                case "presetColor4": 
                case "presetFillColor4": 
                case "presetColor5": 
                case "presetFillColor5": {
                    this.recreateList();
                }
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.npcSpawns.clear();
            this.npcList.clear();
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        MenuAction menuAction;
        int type = event.getType();
        if (type >= 2000) {
            type -= 2000;
        }
        if (NPC_MENU_ACTIONS.contains(menuAction = MenuAction.of((int)type))) {
            NPC npc = this.client.getCachedNPCs()[event.getIdentifier()];
            Color color = null;
            if (this.npcUtil.isDying(npc)) {
                color = this.config.deadNpcMenuColor();
            } else if (this.config.highlightMenuNames() && npc.getName() != null) {
                for (NPCInfo npcInfo : this.npcList) {
                    if (npcInfo.getNpc() != npc) continue;
                    color = this.getSpecificColor(npcInfo);
                    break;
                }
            }
            if (color != null) {
                MenuEntry[] menuEntries = this.client.getMenuEntries();
                MenuEntry menuEntry = menuEntries[menuEntries.length - 1];
                String target = ColorUtil.prependColorTag((String)Text.removeTags((String)event.getTarget()), (Color)color);
                menuEntry.setTarget(target);
                this.client.setMenuEntries(menuEntries);
            }
        } else if (menuAction == MenuAction.EXAMINE_NPC) {
            int id = event.getIdentifier();
            NPC npc = this.client.getCachedNPCs()[id];
            if (npc != null && npc.getName() != null && this.config.tagStyleMode() != BetterNpcHighlightConfig.tagStyleMode.NONE) {
                String option;
                if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.TILE) {
                    option = this.checkSpecificNameList(this.tileNames, npc) ? "Untag-Tile" : "Tag-Tile";
                } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.TRUE_TILE) {
                    option = this.checkSpecificNameList(this.trueTileNames, npc) ? "Untag-True-Tile" : "Tag-True-Tile";
                } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.SW_TILE) {
                    option = this.checkSpecificNameList(this.swTileNames, npc) ? "Untag-SW-Tile" : "Tag-SW-Tile";
                } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.SW_TRUE_TILE) {
                    option = this.checkSpecificNameList(this.swTrueTileNames, npc) ? "Untag-SW-True-Tile" : "Tag-SW-True-Tile";
                } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.HULL) {
                    option = this.checkSpecificNameList(this.hullNames, npc) ? "Untag-Hull" : "Tag-Hull";
                } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.AREA) {
                    option = this.checkSpecificNameList(this.areaNames, npc) ? "Untag-Area" : "Tag-Area";
                } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.OUTLINE) {
                    option = this.checkSpecificNameList(this.outlineNames, npc) ? "Untag-Outline" : "Tag-Outline";
                } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.CLICKBOX) {
                    option = this.checkSpecificNameList(this.clickboxNames, npc) ? "Untag-Clickbox" : "Tag-Clickbox";
                } else {
                    String string = option = this.checkSpecificNameList(this.turboNames, npc) ? "Untag-Turbo" : "Tag-Turbo";
                }
                if (option.contains("Untag-") && (this.config.highlightMenuNames() || npc.isDead() && this.config.deadNpcMenuColor() != null)) {
                    String target;
                    MenuEntry[] menuEntries = this.client.getMenuEntries();
                    MenuEntry menuEntry = menuEntries[menuEntries.length - 1];
                    if (option.contains("Turbo")) {
                        target = ColorUtil.prependColorTag((String)Text.removeTags((String)event.getTarget()), (Color)Color.getHSBColor(new Random().nextFloat(), 1.0f, 1.0f));
                    } else {
                        Color color = npc.isDead() ? this.config.deadNpcMenuColor() : this.getTagColor();
                        target = ColorUtil.prependColorTag((String)Text.removeTags((String)event.getTarget()), (Color)color);
                    }
                    menuEntry.setTarget(target);
                    this.client.setMenuEntries(menuEntries);
                }
                if (this.client.isKeyPressed(81)) {
                    Object tagAllEntry;
                    if (this.config.highlightMenuNames() || npc.isDead() && this.config.deadNpcMenuColor() != null) {
                        String colorCode = this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.TURBO ? (this.turboColors.size() == 0 && this.turboNames.contains(npc.getName().toLowerCase()) ? Integer.toHexString(this.turboColors.get(this.turboNames.indexOf(npc.getName().toLowerCase())).getRGB()) : Integer.toHexString(Color.getHSBColor(new Random().nextFloat(), 1.0f, 1.0f).getRGB())) : (npc.isDead() ? Integer.toHexString(this.config.deadNpcMenuColor().getRGB()) : Integer.toHexString(this.getTagColor().getRGB()));
                        tagAllEntry = "<col=" + colorCode.substring(2) + ">" + Text.removeTags((String)event.getTarget());
                    } else {
                        tagAllEntry = event.getTarget();
                    }
                    int idx = -1;
                    MenuEntry parent = this.client.createMenuEntry(idx).setOption(option).setTarget((String)tagAllEntry).setIdentifier(event.getIdentifier()).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setType(this.config.presetColorAmount() == BetterNpcHighlightConfig.presetColorAmount.ZERO ? MenuAction.RUNELITE : MenuAction.RUNELITE_SUBMENU).onClick(this::tagNPC);
                    if (parent != null) {
                        this.customColorTag(idx, npc, parent);
                    }
                }
            }
        }
    }

    public void tagNPC(MenuEntry event) {
        if ((event.getType() == MenuAction.RUNELITE_SUBMENU || event.getType() == MenuAction.RUNELITE) && (event.getOption().contains("Tag") || event.getOption().contains("Untag")) && (event.getOption().contains("-Tile") || event.getOption().contains("-True-Tile") || event.getOption().contains("-SW-Tile") || event.getOption().contains("-SW-True-Tile") || event.getOption().contains("-Hull") || event.getOption().contains("-Area") || event.getOption().contains("-Outline") || event.getOption().contains("-Clickbox") || event.getOption().contains("-Turbo"))) {
            int id = event.getIdentifier();
            NPC npc = this.client.getCachedNPCs()[id];
            boolean tag = event.getOption().contains("Tag");
            if (npc.getName() != null) {
                this.updateListConfig(tag, npc.getName().toLowerCase(), 0);
            }
        }
    }

    private void customColorTag(int idx, NPC npc, MenuEntry parent) {
        ArrayList<Color> colors = new ArrayList<Color>();
        if (this.config.presetColorAmount() != BetterNpcHighlightConfig.presetColorAmount.ZERO) {
            if (this.config.presetColorAmount() == BetterNpcHighlightConfig.presetColorAmount.ONE) {
                colors.add(this.config.presetColor1());
            } else if (this.config.presetColorAmount() == BetterNpcHighlightConfig.presetColorAmount.TWO) {
                colors.add(this.config.presetColor1());
                colors.add(this.config.presetColor2());
            } else if (this.config.presetColorAmount() == BetterNpcHighlightConfig.presetColorAmount.THREE) {
                colors.add(this.config.presetColor1());
                colors.add(this.config.presetColor2());
                colors.add(this.config.presetColor3());
            } else if (this.config.presetColorAmount() == BetterNpcHighlightConfig.presetColorAmount.FOUR) {
                colors.add(this.config.presetColor1());
                colors.add(this.config.presetColor2());
                colors.add(this.config.presetColor3());
                colors.add(this.config.presetColor4());
            } else if (this.config.presetColorAmount() == BetterNpcHighlightConfig.presetColorAmount.FIVE) {
                colors.add(this.config.presetColor1());
                colors.add(this.config.presetColor2());
                colors.add(this.config.presetColor3());
                colors.add(this.config.presetColor4());
                colors.add(this.config.presetColor5());
            }
            if (colors.size() > 0) {
                int index = 1;
                for (Color c : colors) {
                    if (c == null) continue;
                    int preset = index;
                    this.client.createMenuEntry(idx--).setOption(ColorUtil.prependColorTag((String)("Preset color " + index), (Color)c)).setType(MenuAction.RUNELITE).setParent(parent).onClick(e -> {
                        if (npc.getName() != null) {
                            this.updateListConfig(true, npc.getName().toLowerCase(), preset);
                        }
                    });
                    ++index;
                }
            }
        }
        for (NPCInfo n : this.npcList) {
            if (n.getNpc() != npc) continue;
            this.client.createMenuEntry(idx--).setOption("Reset color").setType(MenuAction.RUNELITE).setParent(parent).onClick(e -> {
                if (npc.getName() != null) {
                    this.updateListConfig(true, npc.getName().toLowerCase(), 0);
                }
            });
            break;
        }
    }

    private void updateListConfig(boolean add, String name, int preset) {
        if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.TILE) {
            this.config.setTileNames(this.configListToString(add, name, this.tileNames, preset));
        } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.TRUE_TILE) {
            this.config.setTrueTileNames(this.configListToString(add, name, this.trueTileNames, preset));
        } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.SW_TILE) {
            this.config.setSwTileNames(this.configListToString(add, name, this.swTileNames, preset));
        } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.SW_TRUE_TILE) {
            this.config.setSwTrueTileNames(this.configListToString(add, name, this.swTrueTileNames, preset));
        } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.HULL) {
            this.config.setHullNames(this.configListToString(add, name, this.hullNames, preset));
        } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.AREA) {
            this.config.setAreaNames(this.configListToString(add, name, this.areaNames, preset));
        } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.OUTLINE) {
            this.config.setOutlineNames(this.configListToString(add, name, this.outlineNames, preset));
        } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.CLICKBOX) {
            this.config.setClickboxNames(this.configListToString(add, name, this.clickboxNames, preset));
        } else if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.TURBO) {
            this.config.setTurboNames(this.configListToString(add, name, this.turboNames, 0));
        }
    }

    private String configListToString(boolean tagOrHide, String name, ArrayList<String> strList, int preset) {
        if (tagOrHide) {
            boolean foundName = false;
            String newName = preset > 0 ? name + ":" + preset : name;
            for (String str2 : strList) {
                if (!str2.startsWith(name + ":") && !str2.equalsIgnoreCase(name)) continue;
                strList.set(strList.indexOf(str2), newName);
                foundName = true;
            }
            if (!foundName) {
                strList.add(newName);
            }
        } else {
            strList.removeIf(str -> str.toLowerCase().startsWith(name + ":") || str.equalsIgnoreCase(name));
        }
        return Text.toCSV(strList);
    }

    @Subscribe(priority=-1.0f)
    public void onNpcSpawned(NpcSpawned event) {
        NPCInfo npcInfo;
        NPC npc = event.getNpc();
        for (NpcSpawn n : this.npcSpawns) {
            if (npc.getIndex() != n.index || npc.getId() != n.id) continue;
            if (n.spawnPoint == null && n.diedOnTick != -1) {
                WorldPoint wp;
                WorldPoint worldPoint = wp = this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)npc.getLocalLocation()) : WorldPoint.fromLocal((Client)this.client, (LocalPoint)npc.getLocalLocation());
                if (n.spawnLocations.contains(wp)) {
                    n.spawnPoint = wp;
                    n.respawnTime = this.client.getTickCount() - n.diedOnTick + 1;
                } else {
                    n.spawnLocations.add(wp);
                }
            }
            n.dead = false;
            break;
        }
        if ((npcInfo = this.checkValidNPC(npc)) != null) {
            this.npcList.add(npcInfo);
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        NPC npc = event.getNpc();
        if (npc.isDead()) {
            if (this.npcList.stream().anyMatch(n -> n.getNpc() == npc) && this.npcSpawns.stream().noneMatch(n -> n.index == npc.getIndex())) {
                this.npcSpawns.add(new NpcSpawn(npc));
            } else {
                for (NpcSpawn n2 : this.npcSpawns) {
                    if (npc.getIndex() != n2.index || npc.getId() != n2.id) continue;
                    n2.diedOnTick = this.client.getTickCount();
                    n2.dead = true;
                    break;
                }
            }
        }
        this.npcList.removeIf(n -> n.getNpc().getIndex() == npc.getIndex());
    }

    @Subscribe(priority=-1.0f)
    public void onNpcChanged(NpcChanged event) {
        NPC npc = event.getNpc();
        this.npcList.removeIf(n -> n.getNpc().getIndex() == npc.getIndex());
        NPCInfo npcInfo = this.checkValidNPC(npc);
        if (npcInfo != null) {
            this.npcList.add(npcInfo);
        }
    }

    @Subscribe(priority=-1.0f)
    public void onGameTick(GameTick event) {
        if (this.checkSlayerPluginEnabled() && !this.currentTask.equals(this.slayerPluginService.getTask())) {
            this.recreateList();
        }
        this.lastTickUpdate = Instant.now();
        this.turboColors.clear();
        for (int i = 0; i < this.npcList.size(); ++i) {
            this.turboColors.add(Color.getHSBColor(new Random().nextFloat(), 1.0f, 1.0f));
        }
        this.turboModeStyle = new Random().nextInt(6);
        this.turboTileWidth = new Random().nextInt(10) + 1;
        this.turboOutlineWidth = new Random().nextInt(50) + 1;
        this.turboOutlineFeather = new Random().nextInt(4);
    }

    public void recreateList() {
        if (this.client.getGameState() == GameState.LOGGED_IN && this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getPlayerComposition() != null) {
            this.npcList.clear();
            for (NPC npc : this.client.getNpcs()) {
                NPCInfo npcInfo = this.checkValidNPC(npc);
                if (npcInfo == null) continue;
                this.npcList.add(npcInfo);
            }
            this.currentTask = this.slayerPluginService.getTask();
        }
    }

    public NPCInfo checkValidNPC(NPC npc) {
        NPCInfo n = new NPCInfo(npc, this, this.slayerPluginService, this.config);
        if (n.getTile().isHighlight() || n.getTrueTile().isHighlight() || n.getSwTile().isHighlight() || n.getSwTrueTile().isHighlight() || n.getHull().isHighlight() || n.getArea().isHighlight() || n.getOutline().isHighlight() || n.getClickbox().isHighlight() || n.getTurbo().isHighlight() || n.isTask()) {
            return n;
        }
        return null;
    }

    public HighlightColor checkSpecificList(ArrayList<String> strList, ArrayList<String> idList, NPC npc, Color configColor, Color configFillColor) {
        for (String entry : idList) {
            int id = -1;
            String preset = "";
            if (entry.contains(":")) {
                String[] strArr = entry.split(":");
                if (StringUtils.isNumeric((CharSequence)strArr[0])) {
                    id = Integer.parseInt(strArr[0]);
                }
                preset = strArr[1];
            } else if (StringUtils.isNumeric((CharSequence)entry)) {
                id = Integer.parseInt(entry);
            }
            if (id != npc.getId()) continue;
            return new HighlightColor(true, this.getHighlightColor(preset, configColor), this.getHighlightFillColor(preset, configFillColor));
        }
        if (npc.getName() != null) {
            String name = npc.getName().toLowerCase();
            Iterator<String> iterator = strList.iterator();
            while (iterator.hasNext()) {
                String entry;
                String nameStr = entry = iterator.next();
                String preset = "";
                if (entry.contains(":")) {
                    String[] strArr = entry.split(":");
                    nameStr = strArr[0];
                    preset = strArr[1];
                }
                if (!WildcardMatcher.matches((String)nameStr, (String)name)) continue;
                return new HighlightColor(true, this.getHighlightColor(preset, configColor), this.getHighlightFillColor(preset, configFillColor));
            }
        }
        return new HighlightColor(false, configColor, configFillColor);
    }

    public boolean checkSpecificNameList(ArrayList<String> strList, NPC npc) {
        if (npc.getName() != null) {
            String name = npc.getName().toLowerCase();
            Iterator<String> iterator = strList.iterator();
            while (iterator.hasNext()) {
                String entry;
                String nameStr = entry = iterator.next();
                if (entry.contains(":")) {
                    String[] strArr = entry.split(":");
                    nameStr = strArr[0];
                }
                if (!WildcardMatcher.matches((String)nameStr, (String)name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkSpecificIdList(ArrayList<String> strList, NPC npc) {
        int id = npc.getId();
        for (String entry : strList) {
            if (!StringUtils.isNumeric((CharSequence)entry) || Integer.parseInt(entry) != id) continue;
            return true;
        }
        return false;
    }

    public boolean checkSlayerPluginEnabled() {
        Optional<Plugin> slayerPlugin = this.pluginManager.getPlugins().stream().filter(p -> p.getName().equals("Slayer")).findFirst();
        return slayerPlugin.isPresent() && this.pluginManager.isPluginEnabled(slayerPlugin.get());
    }

    public void enableSlayerPlugin() {
        try {
            Optional<Plugin> slayerPlugin = this.pluginManager.getPlugins().stream().filter(p -> p.getName().equals("Slayer")).findFirst();
            if (slayerPlugin.isPresent() && !this.pluginManager.isPluginEnabled(slayerPlugin.get()) && this.config.slayerHighlight()) {
                this.pluginManager.setPluginEnabled(slayerPlugin.get(), true);
                this.pluginManager.startPlugin(slayerPlugin.get());
                this.currentTask = "";
            }
        }
        catch (PluginInstantiationException ex) {
            log.error("error starting slayer plugin", (Throwable)ex);
        }
    }

    public Color getTagColor() {
        if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.TILE) {
            return this.config.tileColor();
        }
        if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.TRUE_TILE) {
            return this.config.trueTileColor();
        }
        if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.SW_TILE) {
            return this.config.swTileColor();
        }
        if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.SW_TRUE_TILE) {
            return this.config.swTrueTileColor();
        }
        if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.HULL) {
            return this.config.hullColor();
        }
        if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.AREA) {
            return this.config.areaColor();
        }
        if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.OUTLINE) {
            return this.config.outlineColor();
        }
        if (this.config.tagStyleMode() == BetterNpcHighlightConfig.tagStyleMode.CLICKBOX) {
            return this.config.clickboxColor();
        }
        return Color.getHSBColor(new Random().nextFloat(), 1.0f, 1.0f);
    }

    public Color getSpecificColor(NPCInfo n) {
        if (n.isTask() && this.config.slayerHighlight()) {
            return this.config.slayerRave() ? this.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskColor();
        }
        if (n.getTile().isHighlight() && this.config.tileHighlight()) {
            return this.config.tileRave() ? this.getRaveColor(this.config.tileRaveSpeed()) : n.getTile().getColor();
        }
        if (n.getTrueTile().isHighlight() && this.config.trueTileHighlight()) {
            return this.config.trueTileRave() ? this.getRaveColor(this.config.trueTileRaveSpeed()) : n.getTrueTile().getColor();
        }
        if (n.getSwTile().isHighlight() && this.config.swTileHighlight()) {
            return this.config.swTileRave() ? this.getRaveColor(this.config.swTileRaveSpeed()) : n.getSwTile().getColor();
        }
        if (n.getSwTrueTile().isHighlight() && this.config.swTrueTileHighlight()) {
            return this.config.swTrueTileRave() ? this.getRaveColor(this.config.swTrueTileRaveSpeed()) : n.getSwTrueTile().getColor();
        }
        if (n.getHull().isHighlight() && this.config.hullHighlight()) {
            return this.config.hullRave() ? this.getRaveColor(this.config.hullRaveSpeed()) : n.getHull().getColor();
        }
        if (n.getArea().isHighlight() && this.config.areaHighlight()) {
            return this.config.areaRave() ? this.getRaveColor(this.config.areaRaveSpeed()) : n.getArea().getColor();
        }
        if (n.getOutline().isHighlight() && this.config.outlineHighlight()) {
            return this.config.outlineRave() ? this.getRaveColor(this.config.outlineRaveSpeed()) : n.getOutline().getColor();
        }
        if (n.getClickbox().isHighlight() && this.config.clickboxHighlight()) {
            return this.config.clickboxRave() ? this.getRaveColor(this.config.clickboxRaveSpeed()) : n.getClickbox().getColor();
        }
        if (n.getTurbo().isHighlight() && this.config.turboHighlight()) {
            return this.getTurboIndex(n.getNpc().getId(), n.getNpc().getName()) != -1 ? this.turboColors.get(this.getTurboIndex(n.getNpc().getId(), n.getNpc().getName())) : Color.WHITE;
        }
        return null;
    }

    public Color getHighlightColor(String preset, Color color) {
        switch (preset) {
            case "1": {
                return this.config.presetColor1();
            }
            case "2": {
                return this.config.presetColor2();
            }
            case "3": {
                return this.config.presetColor3();
            }
            case "4": {
                return this.config.presetColor4();
            }
            case "5": {
                return this.config.presetColor5();
            }
        }
        return color;
    }

    public Color getHighlightFillColor(String preset, Color color) {
        switch (preset) {
            case "1": {
                return this.config.presetFillColor1();
            }
            case "2": {
                return this.config.presetFillColor2();
            }
            case "3": {
                return this.config.presetFillColor3();
            }
            case "4": {
                return this.config.presetFillColor4();
            }
            case "5": {
                return this.config.presetFillColor5();
            }
        }
        return color;
    }

    public Color getRaveColor(int speed) {
        int ticks = speed / 20;
        return Color.getHSBColor((float)(this.client.getGameCycle() % ticks) / (float)ticks, 1.0f, 1.0f);
    }

    public int getTurboIndex(int id, String name) {
        if (this.turboIds.contains(String.valueOf(id))) {
            return this.turboIds.indexOf(String.valueOf(id));
        }
        if (name != null) {
            int index = this.turboIds.size() - 1;
            for (String str : this.turboNames) {
                if (WildcardMatcher.matches((String)str, (String)name)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    private void showEpilepsyWarning() {
        this.configManager.setConfiguration("BetterNpcHighlight", "turboHighlight", (Object)false);
        Font font = (Font)UIManager.get("OptionPane.buttonFont");
        Object[] options = new Object[]{"Okay, I accept the risk", "No, this is an affront to my eyes"};
        JLabel label = new JLabel("<html><p>Turning this on will cause any NPCs highlighted with this style to change colors and styles rapidly.</p></html>");
        if (JOptionPane.showOptionDialog(new JFrame(), label, "EPILEPSY WARNING - Occular Abhorrence", 0, 2, null, options, options[1]) == 0) {
            this.confirmedWarning = true;
            this.configManager.setConfiguration("BetterNpcHighlight", "turboHighlight", (Object)true);
        }
        UIManager.put("OptionPane.buttonFont", font);
    }

    @VisibleForTesting
    boolean shouldDraw(Renderable renderable, boolean drawingUI) {
        if (renderable instanceof NPC) {
            NPC npc = (NPC)renderable;
            if (this.config.entityHiderToggle()) {
                return !this.hiddenIds.contains(String.valueOf(npc.getId())) && npc.getName() != null && !this.hiddenNames.contains(npc.getName().toLowerCase());
            }
        }
        return true;
    }

    public void keyPressed(KeyEvent e) {
        int var;
        int inputType;
        if (!(e.getKeyCode() != 10 || (inputType = this.client.getVarcIntValue(5)) != InputType.PRIVATE_MESSAGE.getType() && inputType != InputType.NONE.getType() || this.client.getVarcStrValue(var = inputType == InputType.PRIVATE_MESSAGE.getType() ? 359 : 335) == null || this.client.getVarcStrValue(var).isEmpty())) {
            String text = this.client.getVarcStrValue(var).toLowerCase();
            if (this.config.entityHiderCommands() && (text.startsWith(HIDE_COMMAND) || text.startsWith(UNHIDE_COMMAND))) {
                this.hideNPCCommand(text, var);
            } else if (this.config.tagCommands() && (text.startsWith(TAG_COMMAND) || text.startsWith(UNTAG_COMMAND))) {
                this.tagNPCCommand(text, var);
            }
        }
    }

    private void hideNPCCommand(String text, int var) {
        String npcToHide = text.replace(text.startsWith(HIDE_COMMAND) ? HIDE_COMMAND : UNHIDE_COMMAND, "").trim();
        boolean hide = text.startsWith(HIDE_COMMAND);
        if (!npcToHide.isEmpty()) {
            if (StringUtils.isNumeric((CharSequence)npcToHide)) {
                this.config.setEntityHiderIds(this.configListToString(hide, npcToHide, this.hiddenIds, 0));
            } else {
                this.config.setEntityHiderNames(this.configListToString(hide, npcToHide, this.hiddenNames, 0));
            }
        } else {
            this.printMessage("Please enter a valid NPC name or ID!");
        }
        this.client.setVarcStrValue(var, "");
    }

    private void tagNPCCommand(String text, int var) {
        if (text.trim().equals(TAG_COMMAND) || text.trim().equals(UNTAG_COMMAND)) {
            this.printMessage("Please enter a tag abbreviation followed by a valid NPC name or ID!");
        } else if (text.contains("!tag ") || text.contains("!untag ")) {
            this.printMessage("Please enter a valid tag abbreviation!");
        } else if (!text.trim().contains(" ")) {
            this.printMessage("Please enter a valid NPC name or ID!");
        } else {
            String npcToTag = text.substring(text.indexOf(" ") + 1).toLowerCase().trim();
            int preset = 0;
            if (npcToTag.contains(":")) {
                String[] strArr = npcToTag.split(":");
                npcToTag = strArr[0];
                if (StringUtils.isNumeric((CharSequence)strArr[1])) {
                    preset = Integer.parseInt(strArr[1]);
                }
            }
            boolean tag = text.startsWith(TAG_COMMAND);
            if (!npcToTag.isEmpty()) {
                if (this.validateCommand(text, "t ") || this.validateCommand(text, "tile ")) {
                    if (StringUtils.isNumeric((CharSequence)npcToTag)) {
                        this.config.setTileIds(this.configListToString(tag, npcToTag, this.tileIds, preset));
                    } else {
                        this.config.setTileNames(this.configListToString(tag, npcToTag, this.tileNames, preset));
                    }
                } else if (this.validateCommand(text, "tt ") || this.validateCommand(text, "truetile ")) {
                    if (StringUtils.isNumeric((CharSequence)npcToTag)) {
                        this.config.setTrueTileIds(this.configListToString(tag, npcToTag, this.trueTileIds, preset));
                    } else {
                        this.config.setTrueTileNames(this.configListToString(tag, npcToTag, this.trueTileNames, preset));
                    }
                } else if (this.validateCommand(text, "sw ") || this.validateCommand(text, "swt ") || this.validateCommand(text, "southwesttile ") || this.validateCommand(text, "southwest ") || this.validateCommand(text, "swtile ") || this.validateCommand(text, "southwestt ")) {
                    if (StringUtils.isNumeric((CharSequence)npcToTag)) {
                        this.config.setSwTileIds(this.configListToString(tag, npcToTag, this.swTileIds, preset));
                    } else {
                        this.config.setSwTileNames(this.configListToString(tag, npcToTag, this.swTileNames, preset));
                    }
                } else if (this.validateCommand(text, "swtt ") || this.validateCommand(text, "swtruetile ") || this.validateCommand(text, "southwesttruetile ") || this.validateCommand(text, "southwesttt ")) {
                    if (StringUtils.isNumeric((CharSequence)npcToTag)) {
                        this.config.setSwTrueTileIds(this.configListToString(tag, npcToTag, this.swTrueTileIds, preset));
                    } else {
                        this.config.setSwTrueTileNames(this.configListToString(tag, npcToTag, this.swTrueTileNames, preset));
                    }
                } else if (this.validateCommand(text, "h ") || this.validateCommand(text, "hull ")) {
                    if (StringUtils.isNumeric((CharSequence)npcToTag)) {
                        this.config.setHullIds(this.configListToString(tag, npcToTag, this.hullIds, preset));
                    } else {
                        this.config.setHullNames(this.configListToString(tag, npcToTag, this.hullNames, preset));
                    }
                } else if (this.validateCommand(text, "a ") || this.validateCommand(text, "area ")) {
                    if (StringUtils.isNumeric((CharSequence)npcToTag)) {
                        this.config.setAreaIds(this.configListToString(tag, npcToTag, this.areaIds, preset));
                    } else {
                        this.config.setAreaNames(this.configListToString(tag, npcToTag, this.areaNames, preset));
                    }
                } else if (this.validateCommand(text, "o ") || this.validateCommand(text, "outline ")) {
                    if (StringUtils.isNumeric((CharSequence)npcToTag)) {
                        this.config.setOutlineIds(this.configListToString(tag, npcToTag, this.outlineIds, preset));
                    } else {
                        this.config.setOutlineNames(this.configListToString(tag, npcToTag, this.outlineNames, preset));
                    }
                } else if (this.validateCommand(text, "c ") || this.validateCommand(text, "clickbox ") || this.validateCommand(text, "box ")) {
                    if (StringUtils.isNumeric((CharSequence)npcToTag)) {
                        this.config.setClickboxIds(this.configListToString(tag, npcToTag, this.clickboxIds, preset));
                    } else {
                        this.config.setClickboxNames(this.configListToString(tag, npcToTag, this.clickboxNames, preset));
                    }
                } else if (this.validateCommand(text, "tu ") || this.validateCommand(text, "turbo ")) {
                    if (StringUtils.isNumeric((CharSequence)npcToTag)) {
                        this.config.setTurboIds(this.configListToString(tag, npcToTag, this.turboIds, preset));
                    } else {
                        this.config.setTurboNames(this.configListToString(tag, npcToTag, this.turboNames, preset));
                    }
                }
            }
        }
        this.client.setVarcStrValue(var, "");
    }

    public boolean validateCommand(String command, String type) {
        return command.startsWith(TAG_COMMAND + type) || command.startsWith(UNTAG_COMMAND + type);
    }

    public void printMessage(String msg) {
        ChatMessageBuilder message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(msg);
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message.build()).build());
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

