/*
 * Decompiled with CFR 0.152.
 */
package com.betternpchighlight;

import com.betternpchighlight.BetterNpcHighlightConfig;
import com.betternpchighlight.BetterNpcHighlightPlugin;
import com.betternpchighlight.NPCInfo;
import com.betternpchighlight.NpcSpawn;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.game.NpcUtil;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;

public class BetterNpcHighlightOverlay
extends Overlay {
    private final Client client;
    private final BetterNpcHighlightPlugin plugin;
    private final BetterNpcHighlightConfig config;
    private final ModelOutlineRenderer modelOutlineRenderer;
    private final NpcUtil npcUtil;

    @Inject
    private BetterNpcHighlightOverlay(Client client, BetterNpcHighlightPlugin plugin, BetterNpcHighlightConfig config, ModelOutlineRenderer modelOutlineRenderer, NpcUtil npcUtil) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.modelOutlineRenderer = modelOutlineRenderer;
        this.npcUtil = npcUtil;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        LocalPoint lp;
        block0: for (NPCInfo npcInfo : this.plugin.npcList) {
            NPC npc = npcInfo.getNpc();
            NPCComposition npcComposition = npc.getTransformedComposition();
            if (npcComposition == null || (npc.getName() == null || npc.getName().equals("") || npc.getName().equals("null")) && BetterNpcHighlightOverlay.isInvisible(npc.getModel())) continue;
            boolean showWhileDead = !npc.isDead() && !this.npcUtil.isDying(npc) || !this.config.ignoreDeadNpcs() || npcInfo.isIgnoreDead();
            boolean showNPC = npcComposition.isFollower() && this.config.highlightPets() || !npcComposition.isFollower() && showWhileDead;
            if (!showNPC || !this.withinDistanceLimit(npc)) continue;
            if (this.config.slayerHighlight() && npcInfo.isTask()) {
                for (BetterNpcHighlightConfig.tagStyleMode mode : BetterNpcHighlightConfig.tagStyleMode.values()) {
                    if (!this.config.taskHighlightStyle().contains((Object)mode)) continue;
                    this.renderNpcOverlay(graphics, npcInfo, mode.getKey());
                }
            } else {
                if (this.config.tileHighlight() && npcInfo.getTile().isHighlight()) {
                    this.renderNpcOverlay(graphics, npcInfo, "tile");
                }
                if (this.config.trueTileHighlight() && npcInfo.getTrueTile().isHighlight()) {
                    this.renderNpcOverlay(graphics, npcInfo, "trueTile");
                }
                if (this.config.swTileHighlight() && npcInfo.getSwTile().isHighlight()) {
                    this.renderNpcOverlay(graphics, npcInfo, "swTile");
                }
                if (this.config.swTrueTileHighlight() && npcInfo.getSwTrueTile().isHighlight()) {
                    this.renderNpcOverlay(graphics, npcInfo, "swTrueTile");
                }
                if (this.config.hullHighlight() && npcInfo.getHull().isHighlight()) {
                    this.renderNpcOverlay(graphics, npcInfo, "hull");
                }
                if (this.config.areaHighlight() && npcInfo.getArea().isHighlight()) {
                    this.renderNpcOverlay(graphics, npcInfo, "area");
                }
                if (this.config.outlineHighlight() && npcInfo.getOutline().isHighlight()) {
                    this.renderNpcOverlay(graphics, npcInfo, "outline");
                }
                if (this.config.clickboxHighlight() && npcInfo.getClickbox().isHighlight()) {
                    this.renderNpcOverlay(graphics, npcInfo, "clickbox");
                }
                if (this.config.turboHighlight() && npcInfo.getTurbo().isHighlight()) {
                    this.renderNpcOverlay(graphics, npcInfo, "turbo");
                }
            }
            if (this.plugin.namesToDisplay.size() <= 0 || npc.getName() == null) continue;
            for (String str : this.plugin.namesToDisplay) {
                String text;
                Point textLoc;
                if (!WildcardMatcher.matches((String)str, (String)npc.getName().toLowerCase()) || (textLoc = npc.getCanvasTextLocation(graphics, text = Text.removeTags((String)npc.getName()), npc.getLogicalHeight() + 40)) == null) continue;
                this.drawTextBackground(graphics, textLoc, text);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLoc, (String)text, (Color)this.plugin.getSpecificColor(npcInfo));
                continue block0;
            }
        }
        if (this.config.drawBeneath() && this.client.isGpu() && this.client.getLocalPlayer() != null && (lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.client.getLocalPlayer().getWorldLocation())) != null) {
            ArrayList<NPCInfo> closestNPCs = this.plugin.npcList;
            if (!this.plugin.beneathNPCs.isEmpty()) {
                closestNPCs = new ArrayList();
                block3: for (NPCInfo npcInfo : this.plugin.npcList) {
                    if (npcInfo.getNpc().isDead() || this.npcUtil.isDying(npcInfo.getNpc())) continue;
                    for (String str : this.plugin.beneathNPCs) {
                        if (npcInfo.getNpc().getName() == null || !WildcardMatcher.matches((String)str, (String)npcInfo.getNpc().getName().toLowerCase())) continue;
                        closestNPCs.add(npcInfo);
                        continue block3;
                    }
                }
            }
            closestNPCs.stream().sorted(Comparator.comparingInt(n -> n.getNpc().getLocalLocation().distanceTo(lp))).limit(this.config.drawBeneathLimit()).collect(Collectors.toList()).forEach(nInfo -> this.removeActor(graphics, (Actor)nInfo.getNpc()));
        }
        if (this.config.debugNPC()) {
            for (NPC npc : this.client.getNpcs()) {
                Polygon tilePoly;
                LocalPoint lp2;
                NPCComposition npcComposition = npc.getTransformedComposition();
                if (npcComposition == null || (npc.getName() == null || npc.getName().equals("") || npc.getName().equals("null")) && BetterNpcHighlightOverlay.isInvisible(npc.getModel()) || (lp2 = npc.getLocalLocation()) == null || (tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)lp2, (int)npcComposition.getSize())) == null) continue;
                this.renderPoly(graphics, Color.GRAY, new Color(0, 0, 0, 0), 255, 0, tilePoly, this.config.tileWidth(), true);
                String text = "N: " + npc.getName() + " | ID: " + npc.getId();
                Point textLoc = npc.getCanvasTextLocation(graphics, text, npc.getLogicalHeight() + 40);
                if (textLoc == null) continue;
                this.drawTextBackground(graphics, textLoc, text);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLoc, (String)text, (Color)Color.WHITE);
            }
        }
        if (this.config.respawnTimer() != BetterNpcHighlightConfig.respawnTimerMode.OFF) {
            for (NpcSpawn n2 : this.plugin.npcSpawns) {
                Point textLoc;
                String text;
                Polygon tilePoly;
                LocalPoint lp3;
                if (n2.spawnPoint == null || n2.respawnTime == -1 || !n2.dead || (lp3 = LocalPoint.fromWorld((Client)this.client, (int)n2.spawnPoint.getX(), (int)n2.spawnPoint.getY())) == null) continue;
                LocalPoint centerLp = new LocalPoint(lp3.getX() + 128 * (n2.size - 1) / 2, lp3.getY() + 128 * (n2.size - 1) / 2);
                Color outlineColor = this.config.respawnOutlineColor();
                Color fillColor = this.config.respawnFillColor();
                Color raveColor = Color.WHITE;
                int width = this.config.respawnTileWidth();
                if (this.plugin.getTurboIndex(n2.id, n2.name.toLowerCase()) != -1) {
                    raveColor = this.plugin.turboColors.get(this.plugin.getTurboIndex(n2.id, n2.name.toLowerCase()));
                    outlineColor = new Color(raveColor.getRed(), raveColor.getGreen(), raveColor.getBlue(), new Random().nextInt(254) + 1);
                    fillColor = new Color(raveColor.getRed(), raveColor.getGreen(), raveColor.getBlue(), new Random().nextInt(254) + 1);
                    width = this.plugin.turboTileWidth;
                }
                if ((tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)centerLp, (int)n2.size)) != null) {
                    this.renderPoly(graphics, outlineColor, fillColor, outlineColor.getAlpha(), fillColor.getAlpha(), tilePoly, width, true);
                }
                if (this.config.respawnTimer() == BetterNpcHighlightConfig.respawnTimerMode.SECONDS) {
                    double sinceLast;
                    Instant now = Instant.now();
                    double baseTick = (double)(n2.respawnTime - (this.client.getTickCount() - n2.diedOnTick)) * 0.6;
                    double timeLeft = Math.max(0.0, baseTick - (sinceLast = (double)(now.toEpochMilli() - this.plugin.lastTickUpdate.toEpochMilli()) / 1000.0));
                    text = String.valueOf(timeLeft);
                    if (text.contains(".")) {
                        text = text.substring(0, text.indexOf(".") + 2);
                    }
                } else {
                    text = String.valueOf(Math.max(0, n2.respawnTime - (this.client.getTickCount() - n2.diedOnTick)));
                }
                if ((textLoc = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)centerLp, (String)text, (int)0)) == null) continue;
                this.drawTextBackground(graphics, textLoc, text);
                if (raveColor != Color.WHITE) {
                    OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLoc, (String)text, (Color)new Color(raveColor.getRed(), raveColor.getGreen(), raveColor.getBlue(), new Random().nextInt(205) + 50));
                    continue;
                }
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLoc, (String)text, (Color)this.config.respawnTimerColor());
            }
        }
        return null;
    }

    protected void renderNpcOverlay(Graphics2D graphics, NPCInfo npcInfo, String highlight) {
        NPC npc = npcInfo.getNpc();
        NPCComposition npcComposition = npc.getTransformedComposition();
        if (npcComposition != null) {
            int size = npcComposition.getSize();
            boolean isTask = npcInfo.isTask() && this.config.slayerHighlight();
            switch (highlight) {
                case "hull": {
                    Color line;
                    Color color = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskColor()) : (line = this.config.hullRave() ? this.plugin.getRaveColor(this.config.hullRaveSpeed()) : npcInfo.getHull().getColor());
                    Color fill = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskFillColor()) : (this.config.hullRave() ? this.plugin.getRaveColor(this.config.hullRaveSpeed()) : npcInfo.getHull().getFill());
                    int lineAlpha = isTask ? this.config.taskColor().getAlpha() : npcInfo.getHull().getColor().getAlpha();
                    int fillAlpha = isTask ? this.config.taskFillColor().getAlpha() : npcInfo.getHull().getFill().getAlpha();
                    boolean antialias = isTask ? this.config.slayerAA() : this.config.hullAA();
                    Shape hull = npc.getConvexHull();
                    if (hull == null) break;
                    this.renderPoly(graphics, line, fill, lineAlpha, fillAlpha, hull, this.config.hullWidth(), antialias);
                    break;
                }
                case "tile": {
                    Polygon tilePoly;
                    Color line;
                    Color color = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskColor()) : (line = this.config.tileRave() ? this.plugin.getRaveColor(this.config.tileRaveSpeed()) : npcInfo.getTile().getColor());
                    Color fill = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskFillColor()) : (this.config.tileRave() ? this.plugin.getRaveColor(this.config.tileRaveSpeed()) : npcInfo.getTile().getFill());
                    int lineAlpha = isTask ? this.config.taskColor().getAlpha() : npcInfo.getTile().getColor().getAlpha();
                    int fillAlpha = isTask ? this.config.taskFillColor().getAlpha() : npcInfo.getTile().getFill().getAlpha();
                    boolean antialias = isTask ? this.config.slayerAA() : this.config.tileAA();
                    LocalPoint lp = npc.getLocalLocation();
                    if (lp == null || (tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)lp, (int)size)) == null) break;
                    switch (this.config.tileLines()) {
                        case REG: {
                            this.renderPoly(graphics, line, fill, lineAlpha, fillAlpha, tilePoly, this.config.tileWidth(), antialias);
                            break;
                        }
                        case DASH: {
                            BetterNpcHighlightOverlay.renderPolygonDashed(graphics, line, fill, lineAlpha, fillAlpha, tilePoly, this.config.tileWidth(), size, antialias);
                            break;
                        }
                        case CORNER: {
                            BetterNpcHighlightOverlay.renderPolygonCorners(graphics, line, fill, lineAlpha, fillAlpha, tilePoly, this.config.tileWidth(), antialias);
                        }
                    }
                    break;
                }
                case "trueTile": {
                    Polygon tilePoly;
                    Color line;
                    Color color = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskColor()) : (line = this.config.trueTileRave() ? this.plugin.getRaveColor(this.config.trueTileRaveSpeed()) : npcInfo.getTrueTile().getColor());
                    Color fill = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskFillColor()) : (this.config.trueTileRave() ? this.plugin.getRaveColor(this.config.trueTileRaveSpeed()) : npcInfo.getTrueTile().getFill());
                    int lineAlpha = isTask ? this.config.taskColor().getAlpha() : npcInfo.getTrueTile().getColor().getAlpha();
                    int fillAlpha = isTask ? this.config.taskFillColor().getAlpha() : npcInfo.getTrueTile().getFill().getAlpha();
                    boolean antialias = isTask ? this.config.slayerAA() : this.config.trueTileAA();
                    LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)npc.getWorldLocation());
                    if (lp == null || (tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)(lp = new LocalPoint(lp.getX() + size * 128 / 2 - 64, lp.getY() + size * 128 / 2 - 64)), (int)size)) == null) break;
                    switch (this.config.trueTileLines()) {
                        case REG: {
                            this.renderPoly(graphics, line, fill, lineAlpha, fillAlpha, tilePoly, this.config.trueTileWidth(), antialias);
                            break;
                        }
                        case DASH: {
                            BetterNpcHighlightOverlay.renderPolygonDashed(graphics, line, fill, lineAlpha, fillAlpha, tilePoly, this.config.trueTileWidth(), size, antialias);
                            break;
                        }
                        case CORNER: {
                            BetterNpcHighlightOverlay.renderPolygonCorners(graphics, line, fill, lineAlpha, fillAlpha, tilePoly, this.config.trueTileWidth(), antialias);
                        }
                    }
                    break;
                }
                case "swTile": {
                    int y;
                    Color line;
                    Color color = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskColor()) : (line = this.config.swTileRave() ? this.plugin.getRaveColor(this.config.swTileRaveSpeed()) : npcInfo.getSwTile().getColor());
                    Color fill = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskFillColor()) : (this.config.swTileRave() ? this.plugin.getRaveColor(this.config.swTileRaveSpeed()) : npcInfo.getSwTile().getFill());
                    int lineAlpha = isTask ? this.config.taskColor().getAlpha() : npcInfo.getSwTile().getColor().getAlpha();
                    int fillAlpha = isTask ? this.config.taskFillColor().getAlpha() : npcInfo.getSwTile().getFill().getAlpha();
                    boolean antialias = isTask ? this.config.slayerAA() : this.config.swTileAA();
                    LocalPoint lp = npc.getLocalLocation();
                    if (lp == null) break;
                    int x = lp.getX() - (size - 1) * 128 / 2;
                    Polygon tilePoly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)new LocalPoint(x, y = lp.getY() - (size - 1) * 128 / 2));
                    if (tilePoly != null) {
                        switch (this.config.swTileLines()) {
                            case REG: {
                                this.renderPoly(graphics, line, fill, lineAlpha, fillAlpha, tilePoly, this.config.swTileWidth(), antialias);
                                break;
                            }
                            case DASH: {
                                BetterNpcHighlightOverlay.renderPolygonDashed(graphics, line, fill, lineAlpha, fillAlpha, tilePoly, this.config.swTileWidth(), size, antialias);
                                break;
                            }
                            case CORNER: {
                                BetterNpcHighlightOverlay.renderPolygonCorners(graphics, line, fill, lineAlpha, fillAlpha, tilePoly, this.config.swTileWidth(), antialias);
                            }
                        }
                    }
                    break;
                }
                case "swTrueTile": {
                    Polygon tilePoly;
                    Color line;
                    Color color = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskColor()) : (line = this.config.swTrueTileRave() ? this.plugin.getRaveColor(this.config.swTrueTileRaveSpeed()) : npcInfo.getSwTrueTile().getColor());
                    Color fill = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskFillColor()) : (this.config.swTrueTileRave() ? this.plugin.getRaveColor(this.config.swTrueTileRaveSpeed()) : npcInfo.getSwTrueTile().getFill());
                    int lineAlpha = isTask ? this.config.taskColor().getAlpha() : npcInfo.getSwTrueTile().getColor().getAlpha();
                    int fillAlpha = isTask ? this.config.taskFillColor().getAlpha() : npcInfo.getSwTrueTile().getFill().getAlpha();
                    boolean antialias = isTask ? this.config.slayerAA() : this.config.swTrueTileAA();
                    LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)npc.getWorldLocation());
                    if (lp == null || (tilePoly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp)) == null) break;
                    switch (this.config.swTrueTileLines()) {
                        case REG: {
                            this.renderPoly(graphics, line, fill, lineAlpha, fillAlpha, tilePoly, this.config.swTrueTileWidth(), antialias);
                            break;
                        }
                        case DASH: {
                            BetterNpcHighlightOverlay.renderPolygonDashed(graphics, line, fill, lineAlpha, fillAlpha, tilePoly, this.config.swTrueTileWidth(), size, antialias);
                            break;
                        }
                        case CORNER: {
                            BetterNpcHighlightOverlay.renderPolygonCorners(graphics, line, fill, lineAlpha, fillAlpha, tilePoly, this.config.swTrueTileWidth(), antialias);
                        }
                    }
                    break;
                }
                case "outline": {
                    Color line = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskColor()) : (this.config.outlineRave() ? this.plugin.getRaveColor(this.config.outlineRaveSpeed()) : npcInfo.getOutline().getColor());
                    this.modelOutlineRenderer.drawOutline(npc, this.config.outlineWidth(), line, this.config.outlineFeather());
                    break;
                }
                case "area": {
                    Color color;
                    Color color2 = color = npcInfo.getArea().getFill() != null ? npcInfo.getArea().getFill() : npcInfo.getArea().getColor();
                    Color fill = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskFillColor()) : (this.config.areaRave() ? this.plugin.getRaveColor(this.config.areaRaveSpeed()) : color);
                    int fillAlpha = isTask ? this.config.taskFillColor().getAlpha() : color.getAlpha();
                    Shape area = npc.getConvexHull();
                    if (area == null) break;
                    graphics.setColor(fill.getAlpha() == 0 ? new Color(fill.getRed(), fill.getGreen(), fill.getGreen(), 50) : new Color(fill.getRed(), fill.getGreen(), fill.getBlue(), fillAlpha));
                    graphics.fill(area);
                    break;
                }
                case "clickbox": {
                    Color line;
                    Color color = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskColor()) : (line = this.config.clickboxRave() ? this.plugin.getRaveColor(this.config.clickboxRaveSpeed()) : npcInfo.getClickbox().getColor());
                    Color fill = isTask ? (this.config.slayerRave() ? this.plugin.getRaveColor(this.config.slayerRaveSpeed()) : this.config.taskFillColor()) : (this.config.clickboxRave() ? this.plugin.getRaveColor(this.config.clickboxRaveSpeed()) : npcInfo.getClickbox().getFill());
                    int lineAlpha = isTask ? this.config.taskColor().getAlpha() : npcInfo.getClickbox().getColor().getAlpha();
                    int fillAlpha = isTask ? this.config.taskFillColor().getAlpha() : npcInfo.getClickbox().getFill().getAlpha();
                    LocalPoint lp = npc.getLocalLocation();
                    if (lp == null) break;
                    Shape clickbox = Perspective.getClickbox((Client)this.client, (Model)npc.getModel(), (int)npc.getCurrentOrientation(), (int)lp.getX(), (int)lp.getY(), (int)Perspective.getTileHeight((Client)this.client, (LocalPoint)lp, (int)npc.getWorldLocation().getPlane()));
                    BetterNpcHighlightOverlay.renderClickbox(graphics, clickbox, this.client.getMouseCanvasPosition(), line, fill, lineAlpha, fillAlpha, line.darker(), this.config.clickboxAA());
                    break;
                }
                case "turbo": {
                    Color raveColor = this.plugin.turboColors.get(this.plugin.npcList.indexOf(npcInfo));
                    if (raveColor == null) break;
                    Color line = new Color(raveColor.getRed(), raveColor.getGreen(), raveColor.getBlue(), new Random().nextInt(254) + 1);
                    Color fill = new Color(raveColor.getRed(), raveColor.getGreen(), raveColor.getBlue(), new Random().nextInt(254) + 1);
                    int tileMode = new Random().nextInt(3);
                    if (this.plugin.turboModeStyle == 0) {
                        Polygon tilePoly;
                        LocalPoint lp = npc.getLocalLocation();
                        if (lp == null || (tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)lp, (int)size)) == null) break;
                        if (tileMode == 0) {
                            this.renderPoly(graphics, line, fill, line.getAlpha(), fill.getAlpha(), tilePoly, this.plugin.turboTileWidth, true);
                            break;
                        }
                        if (tileMode == 1) {
                            BetterNpcHighlightOverlay.renderPolygonDashed(graphics, line, fill, line.getAlpha(), fill.getAlpha(), tilePoly, this.plugin.turboTileWidth, size, true);
                            break;
                        }
                        BetterNpcHighlightOverlay.renderPolygonCorners(graphics, line, fill, line.getAlpha(), fill.getAlpha(), tilePoly, this.plugin.turboTileWidth, true);
                        break;
                    }
                    if (this.plugin.turboModeStyle == 1) {
                        Polygon tilePoly;
                        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)npc.getWorldLocation());
                        if (lp == null || (tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)(lp = new LocalPoint(lp.getX() + size * 128 / 2 - 64, lp.getY() + size * 128 / 2 - 64)), (int)size)) == null) break;
                        if (tileMode == 0) {
                            this.renderPoly(graphics, line, fill, line.getAlpha(), fill.getAlpha(), tilePoly, this.plugin.turboTileWidth, true);
                            break;
                        }
                        if (tileMode == 1) {
                            BetterNpcHighlightOverlay.renderPolygonDashed(graphics, line, fill, line.getAlpha(), fill.getAlpha(), tilePoly, this.plugin.turboTileWidth, size, true);
                            break;
                        }
                        BetterNpcHighlightOverlay.renderPolygonCorners(graphics, line, fill, line.getAlpha(), fill.getAlpha(), tilePoly, this.plugin.turboTileWidth, true);
                        break;
                    }
                    if (this.plugin.turboModeStyle == 2) {
                        int y;
                        int x;
                        Polygon tilePoly;
                        LocalPoint lp = npc.getLocalLocation();
                        if (lp == null || (tilePoly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)new LocalPoint(x = lp.getX() - (size - 1) * 128 / 2, y = lp.getY() - (size - 1) * 128 / 2))) == null) break;
                        if (tileMode == 0) {
                            this.renderPoly(graphics, line, fill, line.getAlpha(), fill.getAlpha(), tilePoly, this.plugin.turboTileWidth, true);
                            break;
                        }
                        if (tileMode == 1) {
                            BetterNpcHighlightOverlay.renderPolygonDashed(graphics, line, fill, line.getAlpha(), fill.getAlpha(), tilePoly, this.plugin.turboTileWidth, size, true);
                            break;
                        }
                        BetterNpcHighlightOverlay.renderPolygonCorners(graphics, line, fill, line.getAlpha(), fill.getAlpha(), tilePoly, this.plugin.turboTileWidth, true);
                        break;
                    }
                    if (this.plugin.turboModeStyle == 3) {
                        if (npc.getConvexHull() == null) break;
                        this.renderPoly(graphics, line, fill, line.getAlpha(), fill.getAlpha(), npc.getConvexHull(), this.plugin.turboTileWidth, true);
                        break;
                    }
                    if (this.plugin.turboModeStyle == 4) {
                        if (npc.getConvexHull() == null) break;
                        graphics.setColor(fill);
                        graphics.fill(npc.getConvexHull());
                        break;
                    }
                    this.modelOutlineRenderer.drawOutline(npc, this.plugin.turboTileWidth, line, this.plugin.turboOutlineFeather);
                }
            }
        }
    }

    private void renderPoly(Graphics2D graphics, Color outlineColor, Color fillColor, int lineAlpha, int fillAlpha, Shape polygon, double width, boolean antiAlias) {
        if (polygon != null) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(new Color(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue(), lineAlpha));
            graphics.setStroke(new BasicStroke((float)width));
            graphics.draw(polygon);
            graphics.setColor(new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), fillAlpha));
            graphics.fill(polygon);
        }
    }

    public static void renderClickbox(Graphics2D graphics, Shape area, Point mousePosition, Color line, Color fill, int lineAlpha, int fillAlpha, Color hovered, boolean antiAlias) {
        if (area != null) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            if (area.contains(mousePosition.getX(), mousePosition.getY())) {
                graphics.setColor(new Color(hovered.getRed(), hovered.getGreen(), hovered.getBlue(), lineAlpha));
            } else {
                graphics.setColor(new Color(line.getRed(), line.getGreen(), line.getBlue(), lineAlpha));
            }
            graphics.draw(area);
            graphics.setColor(new Color(fill.getRed(), fill.getGreen(), fill.getBlue(), fillAlpha));
            graphics.fill(area);
        }
    }

    private static void renderPolygonCorners(Graphics2D graphics, Color outlineColor, Color fillColor, int lineAlpha, int fillAlpha, Shape poly, double width, boolean antiAlias) {
        if (poly instanceof Polygon) {
            Polygon p = (Polygon)poly;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(new Color(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue(), lineAlpha));
            graphics.setStroke(new BasicStroke((float)width));
            int divisor = 7;
            for (int i = 0; i < p.npoints; ++i) {
                int ptx = p.xpoints[i];
                int pty = p.ypoints[i];
                int prev = i - 1 < 0 ? 3 : i - 1;
                int next = i + 1 > 3 ? 0 : i + 1;
                int ptxN = (p.xpoints[next] - ptx) / divisor + ptx;
                int ptyN = (p.ypoints[next] - pty) / divisor + pty;
                int ptxP = (p.xpoints[prev] - ptx) / divisor + ptx;
                int ptyP = (p.ypoints[prev] - pty) / divisor + pty;
                graphics.drawLine(ptx, pty, ptxN, ptyN);
                graphics.drawLine(ptx, pty, ptxP, ptyP);
            }
            graphics.setColor(new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), fillAlpha));
            graphics.fill(poly);
        }
    }

    private static void renderPolygonDashed(Graphics2D graphics, Color outlineColor, Color fillColor, int lineAlpha, int fillAlpha, Shape poly, double width, int tiles, boolean antiAlias) {
        if (poly instanceof Polygon) {
            Polygon p = (Polygon)poly;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(new Color(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue(), lineAlpha));
            graphics.setStroke(new BasicStroke((float)width));
            int divisor = 7 * tiles;
            for (int i = 0; i < p.npoints; ++i) {
                int ptx = p.xpoints[i];
                int pty = p.ypoints[i];
                int next = i + 1 > 3 ? 0 : i + 1;
                int ptxN = p.xpoints[next] - ptx;
                int ptyN = p.ypoints[next] - pty;
                float length = (float)Point2D.distance(ptx, pty, ptx + ptxN, pty + ptyN);
                float dashLength = length * 2.0f / (float)divisor;
                float spaceLength = length * 5.0f / (float)divisor;
                BasicStroke s = new BasicStroke((float)width, 2, 0, 10.0f, new float[]{dashLength, spaceLength}, dashLength / 2.0f);
                graphics.setStroke(s);
                graphics.drawLine(ptx, pty, ptx + ptxN, pty + ptyN);
            }
            graphics.setColor(new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), fillAlpha));
            graphics.fill(poly);
        }
    }

    private void drawTextBackground(Graphics2D graphics, Point textLoc, String text) {
        switch (this.config.fontBackground()) {
            case OUTLINE: {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX(), textLoc.getY() + 1), (String)text, (Color)Color.BLACK);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX(), textLoc.getY() - 1), (String)text, (Color)Color.BLACK);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX() + 1, textLoc.getY()), (String)text, (Color)Color.BLACK);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX() - 1, textLoc.getY()), (String)text, (Color)Color.BLACK);
                break;
            }
            case SHADOW: {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLoc.getX() + 1, textLoc.getY() + 1), (String)text, (Color)Color.BLACK);
                break;
            }
        }
    }

    private static boolean isInvisible(Model model) {
        for (int value : model.getFaceColors3()) {
            if (value == -1) continue;
            return false;
        }
        return true;
    }

    private void removeActor(Graphics2D graphics, Actor actor) {
        NPCComposition composition;
        int clipX1 = this.client.getViewportXOffset();
        int clipY1 = this.client.getViewportYOffset();
        int clipX2 = this.client.getViewportWidth() + clipX1;
        int clipY2 = this.client.getViewportHeight() + clipY1;
        Object origAA = graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Model model = actor.getModel();
        int vCount = model.getVerticesCount();
        int[] x3d = model.getVerticesX();
        int[] y3d = model.getVerticesY();
        int[] z3d = model.getVerticesZ();
        int[] x2d = new int[vCount];
        int[] y2d = new int[vCount];
        int size = 1;
        if (actor instanceof NPC && (composition = ((NPC)actor).getTransformedComposition()) != null) {
            size = composition.getSize();
        }
        LocalPoint lp = actor.getLocalLocation();
        int localX = lp.getX();
        int localY = lp.getY();
        int northEastX = lp.getX() + 128 * (size - 1) / 2;
        int northEastY = lp.getY() + 128 * (size - 1) / 2;
        LocalPoint northEastLp = new LocalPoint(northEastX, northEastY);
        int localZ = Perspective.getTileHeight((Client)this.client, (LocalPoint)northEastLp, (int)this.client.getPlane());
        int rotation = actor.getCurrentOrientation();
        Perspective.modelToCanvas((Client)this.client, (int)vCount, (int)localX, (int)localY, (int)localZ, (int)rotation, (int[])x3d, (int[])z3d, (int[])y3d, (int[])x2d, (int[])y2d);
        boolean anyVisible = false;
        for (int i = 0; i < vCount; ++i) {
            int x = x2d[i];
            int y = y2d[i];
            boolean visibleX = x >= clipX1 && x < clipX2;
            boolean visibleY = y >= clipY1 && y < clipY2;
            anyVisible |= visibleX && visibleY;
        }
        if (!anyVisible) {
            return;
        }
        int tCount = model.getFaceCount();
        int[] tx = model.getFaceIndices1();
        int[] ty = model.getFaceIndices2();
        int[] tz = model.getFaceIndices3();
        Composite orig = graphics.getComposite();
        graphics.setComposite(AlphaComposite.Clear);
        graphics.setColor(Color.WHITE);
        for (int i = 0; i < tCount; ++i) {
            if (this.getTriDirection(x2d[tx[i]], y2d[tx[i]], x2d[ty[i]], y2d[ty[i]], x2d[tz[i]], y2d[tz[i]]) >= 0) continue;
            Polygon p = new Polygon(new int[]{x2d[tx[i]], x2d[ty[i]], x2d[tz[i]]}, new int[]{y2d[tx[i]], y2d[ty[i]], y2d[tz[i]]}, 3);
            graphics.fill(p);
        }
        graphics.setComposite(orig);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, origAA);
    }

    private int getTriDirection(int x1, int y1, int x2, int y2, int x3, int y3) {
        int x4 = x2 - x1;
        int y4 = y2 - y1;
        int x5 = x3 - x1;
        int y5 = y3 - y1;
        return x4 * y5 - y4 * x5;
    }

    private boolean withinDistanceLimit(NPC npc) {
        int maxDistance = this.config.renderDistance().getDistance();
        return maxDistance == 0 || npc.getWorldArea().distanceTo(this.client.getLocalPlayer().getWorldArea()) - 1 <= maxDistance;
    }
}

