/*
 * Decompiled with CFR 0.152.
 */
package dev.wannaknow.raidplayernames;

import dev.wannaknow.raidplayernames.RaidPlayerNamesPanel;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;

@PluginDescriptor(name="Raid Player Names", description="A plugin which automaticlly saves all the names with the people you raid with", tags={"combat", "raid", "pve", "pvm", "bosses", "cox", "tob", "names", "log"})
public class RaidPlayerNamesPlugin
extends Plugin {
    private static final String PLUGIN_NAME = "Raid name logger";
    private static final String ICON_FILE = "cox.png";
    @Inject
    private ClientThread clientThread;
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    private static final String RAID_START_MESSAGE = "The raid has begun!";
    private static final String TOB_START = "You enter the Theatre of Blood";
    private boolean inRaidChambers;
    private RaidPlayerNamesPanel panel;
    private NavigationButton navigationButton;
    private static final int PARTY_LIST_ID_TOB = 0x1C000C;

    protected void startUp() throws Exception {
        this.panel = new RaidPlayerNamesPanel(this);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)ICON_FILE);
        this.navigationButton = NavigationButton.builder().tooltip(PLUGIN_NAME).icon(icon).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
        this.clientThread.invokeLater(() -> this.checkRaidPresence());
    }

    protected void shutDown() throws Exception {
        this.inRaidChambers = false;
        this.clientToolbar.removeNavigation(this.navigationButton);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.checkRaidPresence();
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String m = Text.removeTags((String)event.getMessage());
        if (this.inRaidChambers && event.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION) {
            if (m.startsWith(RAID_START_MESSAGE)) {
                List players = this.client.getPlayers();
                ArrayList<String> people = new ArrayList<String>();
                for (Player player : players) {
                    people.add(player.getName());
                }
                SwingUtilities.invokeLater(() -> this.panel.addRaid("CoX", people));
            }
        } else if (event.getType() == ChatMessageType.GAMEMESSAGE && m.startsWith(TOB_START)) {
            Widget raidingPartyWidget = this.client.getWidget(0x1C000C);
            if (raidingPartyWidget == null) {
                return;
            }
            String[] playerNames = raidingPartyWidget.getText().split("<br>");
            ArrayList<String> people = new ArrayList<String>();
            for (int i = 0; i < playerNames.length; ++i) {
                String name = playerNames[i];
                if (StringUtils.isEmpty((CharSequence)name) || name.equals("-")) continue;
                people.add(name);
            }
            SwingUtilities.invokeLater(() -> this.panel.addRaid("ToB", people));
        }
    }

    private void checkRaidPresence() {
        boolean setting;
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        boolean bl = setting = this.client.getVarbitValue(5432) == 1;
        if (this.inRaidChambers != setting) {
            this.inRaidChambers = setting;
        }
    }
}

