/*
 * Decompiled with CFR 0.152.
 */
package dev.wannaknow.raidplayernames;

import dev.wannaknow.raidplayernames.RaidPlayerNamesPanel;
import dev.wannaknow.raidplayernames.RaidPlayerNamesPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class RaidPlayerNamesBox
extends JPanel {
    private RaidPlayerNamesPanel panel;
    private final JLabel deleteLabel = new JLabel();
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_HOVER_ICON;

    RaidPlayerNamesBox(RaidPlayerNamesPanel panel, String type, List<String> players) {
        this.panel = panel;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 10, 0));
        JPanel actions = new JPanel();
        actions.setLayout(new BoxLayout(actions, 0));
        actions.setBorder(new EmptyBorder(7, 7, 7, 7));
        actions.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        this.deleteLabel.setIcon(DELETE_ICON);
        this.deleteLabel.setToolTipText("Delete this raid");
        this.deleteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int confirm = JOptionPane.showConfirmDialog(RaidPlayerNamesBox.this, "Are you sure you want to permanently delete this raid?", "Warning", 2);
                if (confirm == 0) {
                    RaidPlayerNamesBox.this.deleteRaid();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                RaidPlayerNamesBox.this.deleteLabel.setIcon(DELETE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                RaidPlayerNamesBox.this.deleteLabel.setIcon(DELETE_ICON);
            }
        });
        actions.add((Component)new JLabel(type + " (" + players.size() + " players)"), "West");
        actions.add(Box.createHorizontalGlue());
        actions.add(Box.createRigidArea(new Dimension(5, 0)));
        actions.add((Component)this.deleteLabel, "East");
        this.add((Component)actions, "North");
        JPanel topContainer = new JPanel();
        topContainer.setLayout(new BorderLayout());
        topContainer.setBorder(new EmptyBorder(7, 7, 7, 7));
        topContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JTextArea textArea = new JTextArea();
        textArea.setText(String.join((CharSequence)"\n", players));
        topContainer.add((Component)textArea, "North");
        this.add(topContainer);
    }

    public void deleteRaid() {
        this.panel.deleteRaid(this);
    }

    static {
        BufferedImage deleteImg = ImageUtil.getResourceStreamFromClass(RaidPlayerNamesPlugin.class, (String)"delete.png");
        DELETE_ICON = new ImageIcon(deleteImg);
        DELETE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)deleteImg, (int)-100));
    }
}

