/*
 * Decompiled with CFR 0.152.
 */
package com.invalidmovement;

import com.google.inject.Inject;
import com.invalidmovement.InvalidMovementConfig;
import com.invalidmovement.MovementFlag;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.GeneralPath;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

class InvalidMovementSceneOverlay
extends Overlay {
    private static final int LOCAL_TILE_SIZE = 128;
    private static final int MAX_DRAW_DISTANCE = 32;
    private final Client client;
    private final InvalidMovementConfig config;

    @Inject
    public InvalidMovementSceneOverlay(Client client, InvalidMovementConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showScene()) {
            this.renderScene(graphics);
        }
        return null;
    }

    private void renderScene(Graphics2D graphics) {
        Tile[][] tiles;
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (this.client.getCollisionMaps() == null) {
            return;
        }
        BasicStroke borderStroke = new BasicStroke(this.config.wallWidth());
        int z = this.client.getPlane();
        int[][] flags = this.client.getCollisionMaps()[z].getFlags();
        Tile[][] tileArray = tiles = this.client.getScene().getTiles()[z];
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[] tileRows;
            for (Tile tile : tileRows = tileArray[i]) {
                Polygon poly;
                LocalPoint localPoint;
                WorldPoint worldPoint;
                if (tile == null || playerLocation.distanceTo(worldPoint = tile.getWorldLocation()) >= 32 || (localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint)) == null || (poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)localPoint)) == null) continue;
                int data = flags[tile.getSceneLocation().getX()][tile.getSceneLocation().getY()];
                Set<MovementFlag> movementFlags = MovementFlag.getSetFlags(data);
                graphics.setStroke(borderStroke);
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_FLOOR)) {
                    graphics.setColor(this.config.colourFloor());
                    graphics.fill(poly);
                }
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_OBJECT)) {
                    graphics.setColor(this.config.colourObject());
                    graphics.fill(poly);
                }
                if (tile.getWallObject() == null) continue;
                GeneralPath path = new GeneralPath();
                int x = worldPoint.getX();
                int y = worldPoint.getY();
                graphics.setColor(this.config.colourWall());
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_SOUTH)) {
                    this.drawWall(path, playerLocation, x, y, z, 1, 0);
                }
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_WEST)) {
                    this.drawWall(path, playerLocation, x, y, z, 0, 1);
                }
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_NORTH)) {
                    this.drawWall(path, playerLocation, x, y + 1, z, 1, 0);
                }
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_EAST)) {
                    this.drawWall(path, playerLocation, x + 1, y, z, 0, 1);
                }
                graphics.draw(path);
            }
        }
    }

    private void drawWall(GeneralPath path, WorldPoint playerLocation, int x, int y, int z, int dx, int dy) {
        boolean hasFirst = this.moveTo(path, x, y, z);
        if (hasFirst && playerLocation.distanceTo(new WorldPoint(x += dx, y += dy, z)) < 32) {
            this.lineTo(path, x, y, z);
        }
    }

    private boolean moveTo(GeneralPath path, int x, int y, int z) {
        Point point = this.XYToPoint(x, y, z);
        if (point != null) {
            path.moveTo(point.getX(), point.getY());
            return true;
        }
        return false;
    }

    private void lineTo(GeneralPath path, int x, int y, int z) {
        Point point = this.XYToPoint(x, y, z);
        if (point != null) {
            path.lineTo(point.getX(), point.getY());
        }
    }

    private Point XYToPoint(int x, int y, int z) {
        LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (int)x, (int)y);
        if (localPoint == null) {
            return null;
        }
        return Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() - 64), (int)z);
    }
}

