/*
 * Decompiled with CFR 0.152.
 */
package com.invalidmovement;

import com.google.inject.Inject;
import com.invalidmovement.InvalidMovementConfig;
import com.invalidmovement.MovementFlag;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

class InvalidMovementMinimapOverlay
extends Overlay {
    private static final int MAX_DRAW_DISTANCE = 20;
    private static final int TILE_SIZE = 4;
    private final Client client;
    private final InvalidMovementConfig config;

    @Inject
    InvalidMovementMinimapOverlay(Client client, InvalidMovementConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showMinimap()) {
            this.renderMinimap(graphics);
        }
        return null;
    }

    private void renderMinimap(Graphics2D graphics) {
        Tile[][] tiles;
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (this.client.getCollisionMaps() == null) {
            return;
        }
        int z = this.client.getPlane();
        int[][] flags = this.client.getCollisionMaps()[z].getFlags();
        Tile[][] tileArray = tiles = this.client.getScene().getTiles()[z];
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[] tileRows;
            for (Tile tile : tileRows = tileArray[i]) {
                Point posOnMinimap;
                LocalPoint localPoint;
                WorldPoint worldPoint;
                if (tile == null || playerLocation.distanceTo(worldPoint = tile.getWorldLocation()) >= 20 || (localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint)) == null || (posOnMinimap = Perspective.localToMinimap((Client)this.client, (LocalPoint)localPoint)) == null) continue;
                int data = flags[tile.getSceneLocation().getX()][tile.getSceneLocation().getY()];
                Set<MovementFlag> movementFlags = MovementFlag.getSetFlags(data);
                Area minimapClipArea = this.getMinimapClipArea();
                if (minimapClipArea == null) {
                    return;
                }
                graphics.setClip(minimapClipArea);
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_FLOOR)) {
                    this.drawSquare(graphics, posOnMinimap, this.config.colourFloor());
                }
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_OBJECT)) {
                    this.drawSquare(graphics, posOnMinimap, this.config.colourObject());
                }
                if (tile.getWallObject() == null) continue;
                double angle = (double)this.client.getMapAngle() * 0.0030679615757712823;
                GeneralPath path = new GeneralPath();
                graphics.setColor(this.config.colourWall());
                graphics.rotate(angle, posOnMinimap.getX(), posOnMinimap.getY());
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_SOUTH)) {
                    this.drawWall(path, posOnMinimap, 0, 1, 1, 0);
                }
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_WEST)) {
                    this.drawWall(path, posOnMinimap, 0, 0, 0, 1);
                }
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_NORTH)) {
                    this.drawWall(path, posOnMinimap, 0, 0, 1, 0);
                }
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_EAST)) {
                    this.drawWall(path, posOnMinimap, 1, 0, 0, 1);
                }
                graphics.draw(path);
                graphics.rotate(-angle, posOnMinimap.getX(), posOnMinimap.getY());
            }
        }
    }

    private void drawSquare(Graphics2D graphics, Point center, Color color) {
        int x = center.getX();
        int y = center.getY();
        double angle = (double)this.client.getMapAngle() * 0.0030679615757712823;
        int width = 4;
        int height = 4;
        boolean a = true;
        boolean b = true;
        graphics.setColor(color);
        graphics.rotate(angle, x, y);
        graphics.fillRect(x - 2 + 1, y - 2 - 1, 4, 4);
        graphics.rotate(-angle, x, y);
    }

    private void drawWall(GeneralPath path, Point center, int dx1, int dy1, int dx2, int dy2) {
        int centerX = center.getX();
        int centerY = center.getY();
        int width = 3;
        int height = 3;
        int x = centerX - 1;
        int y = centerY - 3;
        path.moveTo(x += dx1 * 3, y += dy1 * 3);
        path.lineTo(x += dx2 * 3, y += dy2 * 3);
    }

    private Area getMinimapClipArea() {
        Widget minimapDrawArea;
        Widget resizeableDrawArea = this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_DRAW_AREA);
        Widget resizeableStonesDrawArea = this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_STONES_DRAW_AREA);
        Widget fixedDrawArea = this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_MINIMAP_DRAW_AREA);
        Widget widget = this.client.isResized() ? (resizeableDrawArea == null ? resizeableStonesDrawArea : resizeableDrawArea) : (minimapDrawArea = fixedDrawArea);
        if (minimapDrawArea == null || minimapDrawArea.isHidden()) {
            return null;
        }
        Rectangle bounds = minimapDrawArea.getBounds();
        Ellipse2D.Double ellipse = new Ellipse2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        return new Area(ellipse);
    }
}

