/*
 * Decompiled with CFR 0.152.
 */
package com.invalidmovement;

import com.google.inject.Inject;
import com.invalidmovement.InvalidMovementConfig;
import com.invalidmovement.MovementFlag;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;

class InvalidMovementMapOverlay
extends Overlay {
    private final Client client;
    private final InvalidMovementConfig config;
    @Inject
    private WorldMapOverlay worldMapOverlay;

    @Inject
    InvalidMovementMapOverlay(Client client, InvalidMovementConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterLayer(WidgetInfo.WORLD_MAP_VIEW);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showWorldMap() && this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW) != null) {
            this.renderWorldMap(graphics);
        }
        return null;
    }

    private void renderWorldMap(Graphics2D graphics) {
        Tile[][] tiles;
        Rectangle bounds = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW).getBounds();
        if (bounds == null) {
            return;
        }
        Area mapClipArea = this.getWorldMapClipArea(bounds);
        if (this.client.getCollisionMaps() == null) {
            return;
        }
        int z = this.client.getPlane();
        int[][] flags = this.client.getCollisionMaps()[z].getFlags();
        Tile[][] tileArray = tiles = this.client.getScene().getTiles()[z];
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[] tileRows;
            for (Tile tile : tileRows = tileArray[i]) {
                if (tile == null) continue;
                WorldPoint worldPoint = tile.getWorldLocation();
                int data = flags[tile.getSceneLocation().getX()][tile.getSceneLocation().getY()];
                Set<MovementFlag> movementFlags = MovementFlag.getSetFlags(data);
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_FLOOR)) {
                    this.drawSquare(graphics, worldPoint, this.config.colourFloor(), mapClipArea);
                }
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_OBJECT)) {
                    this.drawSquare(graphics, worldPoint, this.config.colourObject(), mapClipArea);
                }
                if (tile.getWallObject() == null) continue;
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_SOUTH)) {
                    this.drawWall(graphics, worldPoint, this.config.colourWall(), mapClipArea, 0, 1, 1, 0);
                }
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_WEST)) {
                    this.drawWall(graphics, worldPoint, this.config.colourWall(), mapClipArea, 0, 0, 0, 1);
                }
                if (movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_NORTH)) {
                    this.drawWall(graphics, worldPoint, this.config.colourWall(), mapClipArea, 0, 0, 1, 0);
                }
                if (!movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_EAST)) continue;
                this.drawWall(graphics, worldPoint, this.config.colourWall(), mapClipArea, 1, 0, 0, 1);
            }
        }
    }

    private void drawSquare(Graphics2D graphics, WorldPoint point, Color color, Area mapClipArea) {
        Point start = this.worldMapOverlay.mapWorldPointToGraphicsPoint(point);
        Point end = this.worldMapOverlay.mapWorldPointToGraphicsPoint(point.dx(1).dy(-1));
        if (start == null || end == null) {
            return;
        }
        int x = start.getX();
        int y = start.getY();
        int width = end.getX() - x;
        int height = end.getY() - y;
        if (!mapClipArea.contains(x -= width / 2, y)) {
            return;
        }
        graphics.setColor(color);
        graphics.fillRect(x, y -= height / 2, width, height);
    }

    private void drawWall(Graphics2D graphics, WorldPoint point, Color color, Area mapClipArea, int dx1, int dy1, int dx2, int dy2) {
        Point start = this.worldMapOverlay.mapWorldPointToGraphicsPoint(point);
        Point end = this.worldMapOverlay.mapWorldPointToGraphicsPoint(point.dx(1).dy(-1));
        if (start == null || end == null) {
            return;
        }
        int x = start.getX();
        int y = start.getY();
        int width = end.getX() - x - 1;
        int height = end.getY() - y - 1;
        if (!mapClipArea.contains(x -= width / 2, y)) {
            return;
        }
        y -= height / 2;
        int a = width % 2 == 0 ? 1 : 0;
        int b = height % 2 == 0 ? 1 : 0;
        x += dx1 * width - 1 + a;
        y += dy1 * height - 1 + b;
        graphics.setColor(color);
        graphics.drawLine(x, y, x + (width *= dx2), y + (height *= dy2));
    }

    private Area getWorldMapClipArea(Rectangle baseRectangle) {
        Widget overview = this.client.getWidget(WidgetInfo.WORLD_MAP_OVERVIEW_MAP);
        Widget surfaceSelector = this.client.getWidget(WidgetInfo.WORLD_MAP_SURFACE_SELECTOR);
        Area clipArea = new Area(baseRectangle);
        if (overview != null && !overview.isHidden()) {
            clipArea.subtract(new Area(overview.getBounds()));
        }
        if (surfaceSelector != null && !surfaceSelector.isHidden()) {
            clipArea.subtract(new Area(surfaceSelector.getBounds()));
        }
        return clipArea;
    }
}

