/*
 * Decompiled with CFR 0.152.
 */
package work.fking.unids;

import java.util.Arrays;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.PostItemComposition;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Unidentified Herbs")
public class UnidentifiedHerbsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(UnidentifiedHerbsPlugin.class);
    private static final int[] GRIMY_HERBS = new int[]{199, 201, 203, 205, 207, 209, 211, 213, 215, 217, 219, 2485, 3049, 3051};
    private static final int ORIGINAL_UNID_MODEL = 2364;
    private static final Pattern CLEAN_MESSAGE_PATTERN = Pattern.compile("You need level \\d{1,2} Herblore to clean the .+");
    private static final String CLEAN_MESSAGE_REPLACEMENT = "Your Herblore level is not high enough to identify this herb.";
    @Inject
    Client client;
    @Inject
    private ClientThread clientThread;

    protected void startUp() {
        this.resetCaches();
    }

    protected void shutDown() throws Exception {
        this.resetCaches();
    }

    @Subscribe
    public void onPostItemComposition(PostItemComposition event) {
        ItemComposition itemComposition = event.getItemComposition();
        int itemId = itemComposition.getId();
        if (this.isGrimyHerb(itemId)) {
            itemComposition.setName("Herb");
            itemComposition.setInventoryModel(2364);
            itemComposition.setColorToReplace(null);
            itemComposition.setColorToReplaceWith(null);
            itemComposition.getInventoryActions()[0] = "Identify";
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (CLEAN_MESSAGE_PATTERN.matcher(chatMessage.getMessage()).matches()) {
            chatMessage.getMessageNode().setValue(CLEAN_MESSAGE_REPLACEMENT);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked clicked) {
        if (clicked.getMenuAction() == MenuAction.CC_OP_LOW_PRIORITY && (clicked.getItemId() == 13226 || clicked.getItemId() == 24478)) {
            clicked.consume();
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You look in your herb sack and see:", null);
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Herbs", null);
        }
    }

    private void resetCaches() {
        this.clientThread.invokeLater(() -> {
            this.client.getItemCompositionCache().reset();
            this.client.getItemModelCache().reset();
            this.client.getItemSpriteCache().reset();
        });
    }

    private boolean isGrimyHerb(int itemId) {
        return Arrays.binarySearch(GRIMY_HERBS, itemId) >= 0;
    }
}

