/*
 * Decompiled with CFR 0.152.
 */
package com.lootsplit.interfaces;

import com.lootsplit.PlayerInfo;
import com.lootsplit.TimePeriod;
import com.lootsplit.interfaces.PlayerEntry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class TimePeriodList
extends JPanel {
    private PlayerEntry playerEntry;
    private final PlayerInfo playerInfo;
    private final ArrayList<JButton> buttons;
    private static final DateTimeFormatter format = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter fullFormat = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    GridBagConstraints startButtonC = new GridBagConstraints();
    GridBagConstraints endButtonC = new GridBagConstraints();

    public TimePeriodList(PlayerEntry playerEntry, PlayerInfo playerInfo) {
        this.playerEntry = playerEntry;
        this.playerInfo = playerInfo;
        this.buttons = new ArrayList();
        this.setLayout(new GridBagLayout());
        this.setAlignmentX(0.5f);
        this.startButtonC.gridx = 0;
        this.startButtonC.gridy = -1;
        this.startButtonC.weightx = 0.5;
        this.startButtonC.fill = 1;
        this.endButtonC.gridx = 1;
        this.endButtonC.gridy = -1;
        this.endButtonC.weightx = 0.5;
        this.endButtonC.fill = 1;
        for (TimePeriod timePeriod : playerInfo.timePeriods) {
            this.addButton(timePeriod, true);
            this.addButton(timePeriod, false);
        }
    }

    public JButton addButton(TimePeriod timePeriod, boolean startElseEnd) {
        JButton button = new JButton();
        button.setAlignmentX(0.5f);
        button.setPreferredSize(new Dimension(200, 20));
        if (startElseEnd) {
            timePeriod.startButton = button;
        } else {
            timePeriod.endButton = button;
            button.setVisible(timePeriod.getEndms() >= 0L);
        }
        button.setText(TimePeriodList.getButtonText(timePeriod, startElseEnd));
        button.addActionListener(e -> {
            String curTime;
            String input;
            TimePeriod last = this.playerInfo.timePeriods.get(this.playerInfo.timePeriods.size() - 1);
            boolean isLastTimeButton = last == timePeriod && (timePeriod.getEndms() < 0L && startElseEnd || !startElseEnd && timePeriod.getEndms() >= 0L);
            String prompt = "Enter new " + (startElseEnd ? "start" : "end") + " time";
            if (isLastTimeButton) {
                prompt = prompt + " or enter d to delete";
            }
            if ((input = JOptionPane.showInputDialog(prompt, (Object)(curTime = Instant.ofEpochMilli(startElseEnd ? timePeriod.getStartms() : timePeriod.getEndms()).atZone(ZoneId.systemDefault()).format(fullFormat)))) == null) {
                return;
            }
            if (isLastTimeButton && input.equalsIgnoreCase("d")) {
                if (startElseEnd) {
                    this.remove(timePeriod.startButton);
                    this.remove(timePeriod.endButton);
                    this.revalidate();
                    this.repaint();
                    this.playerEntry.leaveOrJoinButton.setText("Rejoin");
                    this.playerEntry.username.setForeground(Color.GRAY);
                    this.playerInfo.timePeriods.remove(this.playerInfo.timePeriods.size() - 1);
                } else {
                    this.playerEntry.leaveOrJoinButton.setText("Left");
                    this.playerEntry.username.setForeground(Color.ORANGE);
                    timePeriod.setEndms(-1L);
                }
                return;
            }
            try {
                long newTime = fullFormat.parse((CharSequence)input, LocalDateTime::from).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                if (startElseEnd) {
                    timePeriod.setStartms(newTime);
                } else {
                    timePeriod.setEndms(newTime);
                }
            }
            catch (DateTimeException exception) {
                JOptionPane.showMessageDialog(null, "Could not parse date");
            }
        });
        this.buttons.add(button);
        if (startElseEnd) {
            this.add((Component)button, this.startButtonC);
        } else {
            this.add((Component)button, this.endButtonC);
        }
        button.revalidate();
        button.repaint();
        return button;
    }

    public static String getButtonText(TimePeriod timePeriod, boolean startElseEnd) {
        if (startElseEnd) {
            return "S:" + Instant.ofEpochMilli(timePeriod.getStartms()).atZone(ZoneId.systemDefault()).format(format);
        }
        if (timePeriod.getEndms() < 0L) {
            return "";
        }
        return "E:" + Instant.ofEpochMilli(timePeriod.getEndms()).atZone(ZoneId.systemDefault()).format(format);
    }
}

