/*
 * Decompiled with CFR 0.152.
 */
package com.lootsplit.interfaces;

import com.lootsplit.LootEntry;
import com.lootsplit.PlayerInfo;
import com.lootsplit.TimePeriod;
import com.lootsplit.interfaces.PlayerPanel;
import com.lootsplit.interfaces.TimePeriodList;
import java.awt.Color;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PlayerEntry
extends JPanel {
    public JLabel username;
    public JButton leaveOrJoinButton;
    private final PlayerInfo playerInfo;
    private final TimePeriodList timePeriodList;
    private PlayerPanel playerPanel;

    public PlayerEntry(PlayerPanel playerPanel, PlayerInfo playerInfo) {
        this.playerPanel = playerPanel;
        this.setLayout(new BoxLayout(this, 1));
        this.playerInfo = playerInfo;
        this.username = new JLabel(playerInfo.name);
        this.username.setForeground(Color.ORANGE);
        this.add(this.username);
        this.leaveOrJoinButton = new JButton("Left");
        this.timePeriodList = new TimePeriodList(this, playerInfo);
        JButton addLootButton = new JButton("Add Loot");
        addLootButton.addActionListener(e -> {
            int value;
            String input = JOptionPane.showInputDialog("Enter Loot value (k)");
            if (input == null) {
                return;
            }
            try {
                value = Integer.parseInt(input);
            }
            catch (NumberFormatException ignored) {
                JOptionPane.showMessageDialog(null, "Could not parse number");
                return;
            }
            String curTime = Instant.ofEpochMilli(System.currentTimeMillis()).atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            String input2 = JOptionPane.showInputDialog("Enter time of loot", (Object)curTime);
            if (input2 == null) {
                return;
            }
            try {
                long time = DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse((CharSequence)input2, LocalDateTime::from).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                LootEntry entry = new LootEntry(value, playerInfo, time);
                playerPanel.lootPanel.plugin.loot.add(entry);
                playerPanel.lootPanel.add(entry);
            }
            catch (DateTimeException exception) {
                JOptionPane.showMessageDialog(null, "Could not parse date");
            }
        });
        this.add(addLootButton);
        this.leaveOrJoinButton.addActionListener(e -> {
            if (playerInfo.timePeriods.isEmpty() || this.playerInfo.timePeriods.get(playerInfo.timePeriods.size() - 1).getEndms() >= 0L) {
                this.leaveOrJoinButton.setText("Left");
                this.username.setForeground(Color.ORANGE);
                TimePeriod timePeriod = new TimePeriod(System.currentTimeMillis());
                playerInfo.timePeriods.add(timePeriod);
                this.timePeriodList.addButton(timePeriod, true);
                this.timePeriodList.addButton(timePeriod, false);
                this.timePeriodList.revalidate();
                this.timePeriodList.repaint();
                this.revalidate();
                this.repaint();
            } else {
                this.leaveOrJoinButton.setText("Rejoin");
                this.username.setForeground(Color.GRAY);
                TimePeriod timePeriod = playerInfo.timePeriods.get(playerInfo.timePeriods.size() - 1);
                timePeriod.setEndms(System.currentTimeMillis());
            }
        });
        this.add(this.leaveOrJoinButton);
        this.add(this.timePeriodList);
    }
}

