/*
 * Decompiled with CFR 0.152.
 */
package com.lootsplit;

import com.google.inject.Provides;
import com.lootsplit.LootConfig;
import com.lootsplit.LootEntry;
import com.lootsplit.LootPanel;
import com.lootsplit.PlayerInfo;
import com.lootsplit.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="PK Loot Splitter")
public class LootSplitPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LootSplitPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private LootConfig config;
    private LootPanel panel;
    private NavigationButton navButton;
    public final List<LootEntry> loot = new ArrayList<LootEntry>();
    final List<PlayerInfo> playerInfos = new ArrayList<PlayerInfo>();
    public static final String USERNAME = "([\\w\\s-\u00a0]{1,12})";
    public static final String COMMA_NUMBER = "([\\d,]+)";
    public static final Pattern lootKeyPattern = Pattern.compile("^([\\w\\s-\u00a0]{1,12}) has opened a loot key worth ([\\d,]+) coins!$");

    protected void startUp() throws Exception {
        this.panel = new LootPanel(this, this.client, this.clientThread);
        this.navButton = NavigationButton.builder().tooltip("PK Loot Split").icon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/lootsplit_icon.png")).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.panel.clear();
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        int coins;
        if (this.client.getClanChannel() == null) {
            return;
        }
        if (!event.getType().equals((Object)ChatMessageType.CLAN_MESSAGE)) {
            return;
        }
        if (event.getSender() != null && !event.getSender().equals(this.client.getClanChannel().getName())) {
            return;
        }
        Matcher m = lootKeyPattern.matcher(event.getMessage());
        if (!m.matches()) {
            return;
        }
        String username = Util.formatName(m.group(1));
        String valueS = m.group(2);
        valueS = valueS.replaceAll(",", "");
        try {
            coins = Integer.parseInt(valueS);
        }
        catch (NumberFormatException e) {
            return;
        }
        PlayerInfo playerInfo = null;
        for (PlayerInfo pi : this.playerInfos) {
            if (!pi.name.equalsIgnoreCase(username)) continue;
            playerInfo = pi;
            break;
        }
        if (playerInfo == null) {
            return;
        }
        LootEntry lootEntry = new LootEntry(coins / 1000, playerInfo, System.currentTimeMillis());
        lootEntry.inSplit = lootEntry.value >= this.config.minimumLoot();
        this.loot.add(lootEntry);
        this.panel.add(lootEntry);
    }

    @Provides
    LootConfig provideConfig(ConfigManager configManager) {
        return (LootConfig)configManager.getConfig(LootConfig.class);
    }

    public void clear() {
    }
}

