/*
 * Decompiled with CFR 0.152.
 */
package com.lootsplit;

import com.lootsplit.LootEntry;
import com.lootsplit.LootSplitPlugin;
import com.lootsplit.PlayerInfo;
import com.lootsplit.TimePeriod;
import com.lootsplit.Util;
import com.lootsplit.interfaces.LootList;
import com.lootsplit.interfaces.PlayerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.GameState;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.ui.PluginPanel;

public class LootPanel
extends PluginPanel {
    public final LootSplitPlugin plugin;
    private final LootList lootList;
    private final JButton splitButton;
    private final Client client;
    private final ClientThread clientThread;
    public final PlayerPanel playerPanel;

    public LootPanel(LootSplitPlugin plugin, Client client, ClientThread clientThread) {
        this.client = client;
        this.plugin = plugin;
        this.clientThread = clientThread;
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.splitButton = new JButton("Split");
        this.splitButton.setAlignmentX(0.5f);
        this.add(this.splitButton);
        this.splitButton.addActionListener(e -> this.split());
        JButton clearButton = new JButton("Reset");
        clearButton.setAlignmentX(0.5f);
        this.add(clearButton);
        clearButton.addActionListener(e -> {
            int option = JOptionPane.showConfirmDialog(null, "Are you sure you want to reset?");
            if (option == 0) {
                this.clear();
            }
        });
        JLabel label = new JLabel("Enter new player: ");
        label.setAlignmentX(0.5f);
        this.add(label);
        final JTextField addPlayerTF = new JTextField(12);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = addPlayerTF.getText();
                LootPanel.this.inputPlayer(text);
            }
        };
        addPlayerTF.addActionListener(action);
        this.add(addPlayerTF);
        this.playerPanel = new PlayerPanel(this);
        this.add(this.playerPanel);
        this.lootList = new LootList();
        this.add(this.lootList);
    }

    private void inputPlayer(String text) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        String name = this.findName(text);
        if (name == null) {
            this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", text + " not found in clan/friends chat or already present.", ""));
            return;
        }
        PlayerInfo playerInfo = new PlayerInfo(name);
        this.plugin.playerInfos.add(playerInfo);
        this.playerPanel.add(playerInfo);
    }

    private String findName(String name) {
        if (this.plugin.playerInfos.stream().anyMatch(playerInfo -> playerInfo.name.equalsIgnoreCase(name))) {
            return null;
        }
        if (this.client.getClanChannel() != null) {
            for (ClanChannelMember member : this.client.getClanChannel().getMembers()) {
                if (!Util.formatName(member.getName()).equalsIgnoreCase(name)) continue;
                return Util.formatName(member.getName());
            }
        }
        if (this.client.getFriendsChatManager() != null) {
            for (FriendsChatMember member : (FriendsChatMember[])this.client.getFriendsChatManager().getMembers()) {
                if (!Util.formatName(member.getName()).equalsIgnoreCase(name)) continue;
                return Util.formatName(member.getName());
            }
        }
        return null;
    }

    private void split() {
        HashMap<PlayerInfo, Double> playerToSplit = new HashMap<PlayerInfo, Double>();
        HashMap<PlayerInfo, Integer> playerToTotal = new HashMap<PlayerInfo, Integer>();
        long total = 0L;
        for (LootEntry lootEntry : this.plugin.loot) {
            if (!lootEntry.inSplit) continue;
            total += (long)lootEntry.getValue();
            ArrayList<PlayerInfo> presentPlayers = new ArrayList<PlayerInfo>();
            block1: for (PlayerInfo playerInfo : this.plugin.playerInfos) {
                for (TimePeriod timePeriod : playerInfo.timePeriods) {
                    if (lootEntry.timems < timePeriod.getStartms() || timePeriod.getEndms() >= 0L && lootEntry.timems > timePeriod.getEndms()) continue;
                    presentPlayers.add(playerInfo);
                    continue block1;
                }
            }
            double split = (double)lootEntry.getValue() / (double)presentPlayers.size();
            playerToTotal.merge(lootEntry.getPlayerInfo(), lootEntry.getValue(), Integer::sum);
            for (PlayerInfo p2 : presentPlayers) {
                playerToSplit.merge(p2, split, Double::sum);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Totals: ").append(total).append("\n");
        playerToTotal.forEach((p, val) -> sb.append(p.name).append(": ").append(val).append("\n"));
        sb.append("\nSplit\n");
        playerToSplit.forEach((p, val) -> sb.append(p.name).append(": ").append(val).append("\n"));
        StringSelection transferableText = new StringSelection(sb.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(transferableText, null);
        this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Split information added to clipboard.", ""));
    }

    public void clear() {
        Iterator it = Arrays.stream(this.lootList.getComponents()).iterator();
        while (it.hasNext()) {
            Component c = (Component)it.next();
            this.lootList.remove(c);
        }
        this.plugin.loot.clear();
        this.plugin.playerInfos.clear();
        this.playerPanel.removeAll();
        this.lootList.revalidate();
        this.lootList.repaint();
    }

    public void add(LootEntry lootEntry) {
        SwingUtilities.invokeLater(() -> {
            this.lootList.add(lootEntry);
            this.lootList.revalidate();
            this.lootList.repaint();
        });
    }
}

