/*
 * Decompiled with CFR 0.152.
 */
package com.bingoeventautomated.service;

import com.bingoeventautomated.service.BEAClientBase;
import com.bingoeventautomated.service.CacheKeys;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class DynamicConfigClient
extends BEAClientBase {
    private final Cache<CacheKeys, ArrayList<String>> configCache;

    public DynamicConfigClient() {
        int nrOfEntries = 1;
        int nrOfHours = 1;
        this.configCache = CacheBuilder.newBuilder().maximumSize((long)nrOfEntries).expireAfterWrite((long)nrOfHours, TimeUnit.HOURS).build();
    }

    public ArrayList<String> GetDynamicConfiguration() {
        ArrayList config = (ArrayList)this.configCache.getIfPresent((Object)CacheKeys.ITEMSOURCES);
        if (config != null) {
            return config;
        }
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)this.eventConfig.GetDynamicConfigUrl())).newBuilder();
        urlBuilder.addQueryParameter("eventcode", this.eventConfig.eventCodeInput());
        ArrayList<String> configuration = this.GetConfig(urlBuilder, CacheKeys.ITEMSOURCES);
        return configuration;
    }

    private ArrayList<String> GetConfig(HttpUrl.Builder urlBuilder, CacheKeys cacheKey) {
        String url = urlBuilder.build().toString();
        Request request = new Request.Builder().url(url).build();
        Call call = this.okHttpClient.newCall(request);
        try {
            Response response = call.execute();
            if (response.body() != null) {
                String body = response.body().string();
                Type type = new TypeToken<List<String>>(){}.getType();
                ArrayList json = (ArrayList)this.gson.fromJson(body, type);
                this.configCache.put((Object)cacheKey, (Object)json);
                return json;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>();
    }
}

