/*
 * Decompiled with CFR 0.152.
 */
package com.bingoeventautomated.service;

import com.bingoeventautomated.service.BEAClientBase;
import com.bingoeventautomated.service.DiscordChatMessageModel;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.client.ui.DrawManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class BEADiscordClient
extends BEAClientBase {
    @Inject
    private DrawManager drawManager;
    private static Queue<Image> screenshots = new ArrayDeque<Image>();

    public void SendImageToDiscord(String message) {
        byte[] imageBytes = this.CreateImage((BufferedImage)screenshots.peek());
        DiscordChatMessageModel discordMessageModel = new DiscordChatMessageModel();
        discordMessageModel.setContent(message);
        String body = this.gson.toJson((Object)discordMessageModel);
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", body);
        requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
        Callback callback = new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) {
            }
        };
        Request request = new Request.Builder().url(this.eventConfig.webhookUrl()).post((RequestBody)requestBodyBuilder.build()).build();
        Call call = this.okHttpClient.newCall(request);
        call.enqueue(callback);
    }

    private byte[] CreateImage(BufferedImage image) {
        byte[] imageBytes = null;
        try {
            imageBytes = BEADiscordClient.convertImageToByteArray(image);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imageBytes;
    }

    private static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void SetScreenshot() {
        this.drawManager.requestNextFrameListener(image -> screenshots.add((Image)image));
    }

    public void removeNextInLineScreenshot() {
        if (screenshots.peek() != null) {
            screenshots.remove();
        }
    }
}

