/*
 * Decompiled with CFR 0.152.
 */
package com.bingoeventautomated.service;

import com.bingoeventautomated.Mapper.ActionDataModel;
import com.bingoeventautomated.config.IEventConfig;
import com.bingoeventautomated.service.ActionResult;
import com.google.gson.Gson;
import java.io.IOException;
import javax.inject.Inject;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class BEAClientBase {
    @Inject
    protected OkHttpClient okHttpClient;
    @Inject
    protected Gson gson;
    @Inject
    protected IEventConfig eventConfig;

    protected String Serialize(ActionDataModel actionData) {
        return this.gson.toJson((Object)actionData);
    }

    protected ActionResult Deserialize(String responseBody) {
        return (ActionResult)this.gson.fromJson(responseBody, ActionResult.class);
    }

    protected void AsyncPostRequest(String body) {
        Callback callback = new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            public void onResponse(Call call, Response response) {
            }
        };
        this.MakeAsyncPostCall(body, callback);
    }

    protected void MakeAsyncPostCall(String body, Callback callback) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.eventConfig.urlInput()).newBuilder().build();
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)body);
        Request request = new Request.Builder().url(httpUrl).post(requestBody).build();
        Call call = this.okHttpClient.newCall(request);
        call.enqueue(callback);
    }
}

