/*
 * Decompiled with CFR 0.152.
 */
package com.bingoeventautomated.service;

import com.bingoeventautomated.Mapper.ActionDataModel;
import com.bingoeventautomated.service.ActionResult;
import com.bingoeventautomated.service.BEAClientBase;
import com.bingoeventautomated.service.BEADiscordClient;
import java.io.IOException;
import javax.inject.Inject;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class ActionDataModelClient
extends BEAClientBase {
    @Inject
    private BEADiscordClient discordClient;

    public void SendActionDataModel(ActionDataModel actionData) {
        boolean isActionDataSet = actionData.IsSet();
        if (!isActionDataSet) {
            this.RemoveScreenshot();
            return;
        }
        String body = this.Serialize(actionData);
        if (this.eventConfig.SendScreenshot()) {
            this.SendPostRequestWithScreenshot(body);
        } else {
            this.AsyncPostRequest(body);
        }
    }

    private void SendPostRequestWithScreenshot(String body) {
        Callback callback = new Callback(){

            public void onFailure(Call call, IOException e) {
                ActionDataModelClient.this.RemoveScreenshot();
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.code() == 200 && response.body() != null) {
                    String responseBody = response.body().string();
                    ActionResult actionResult = ActionDataModelClient.this.Deserialize(responseBody);
                    if (actionResult.isMessageSet) {
                        ActionDataModelClient.this.discordClient.SendImageToDiscord(actionResult.message);
                    }
                }
                ActionDataModelClient.this.RemoveScreenshot();
            }
        };
        this.MakeAsyncPostCall(body, callback);
    }

    public void SetScreenshot() {
        this.discordClient.SetScreenshot();
        System.out.println("setting screenshot");
    }

    public void RemoveScreenshot() {
        this.discordClient.removeNextInLineScreenshot();
    }
}

