/*
 * Decompiled with CFR 0.152.
 */
package com.bingoeventautomated.Mapper;

import com.bingoeventautomated.Mapper.ActionDataItem;
import com.bingoeventautomated.Mapper.ActionDataItemMapper;
import com.bingoeventautomated.Mapper.ActionDataModel;
import com.bingoeventautomated.config.IEventConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemStack;

public class InventoryActionDataModelMapper {
    @Inject
    Client client;
    @Inject
    IEventConfig eventconfig;
    @Inject
    ActionDataItemMapper actionDataItemMapper;

    public String GetInventoryName(int widgetId) {
        switch (widgetId) {
            case 155: {
                return "Barrows";
            }
            case 539: {
                return "COX";
            }
            case 28: {
                return "TOB";
            }
            case 771: {
                return "TOA";
            }
            case 367: {
                return "Fishing Trawler";
            }
            case 742: {
                return "Wilderniss Loot Chest";
            }
        }
        return "";
    }

    public InventoryID GetWidgetId(int widgetId) {
        switch (widgetId) {
            case 155: {
                return InventoryID.BARROWS_REWARD;
            }
            case 539: {
                return InventoryID.CHAMBERS_OF_XERIC_CHEST;
            }
            case 28: {
                return InventoryID.THEATRE_OF_BLOOD_CHEST;
            }
            case 771: {
                return InventoryID.TOA_REWARD_CHEST;
            }
            case 367: {
                return InventoryID.FISHING_TRAWLER_REWARD;
            }
            case 742: {
                return InventoryID.WILDERNESS_LOOT_CHEST;
            }
        }
        return null;
    }

    public ActionDataModel Map(int widgetId) {
        String inventoryName = this.GetInventoryName(widgetId);
        ActionDataModel actionData = new ActionDataModel();
        InventoryID foundInventory = this.GetWidgetId(widgetId);
        if (foundInventory == null) {
            return actionData;
        }
        actionData = this.InventoryToActionDataModel(foundInventory, inventoryName);
        actionData.username = this.client.getLocalPlayer().getName();
        actionData.eventcode = this.eventconfig.eventCodeInput();
        return actionData;
    }

    private ActionDataModel InventoryToActionDataModel(InventoryID inventoryID, String itemsource) {
        ActionDataModel actionData = new ActionDataModel();
        actionData.itemsource = itemsource;
        System.out.println(itemsource);
        this.SetBingoTileItems(inventoryID, actionData);
        return actionData;
    }

    private void SetBingoTileItems(InventoryID inventoryID, ActionDataModel actionData) {
        try {
            Collection<ItemStack> InventoryItemCollection = this.GetItemListFromInventory(inventoryID);
            this.AddInventoryItemsToBingoTileItems(actionData, InventoryItemCollection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Collection<ItemStack> GetItemListFromInventory(InventoryID inventoryID) {
        ItemContainer container = this.client.getItemContainer(inventoryID);
        Collection<Object> items = new ArrayList<ItemStack>();
        if (container != null) {
            items = Arrays.stream(container.getItems()).filter(item -> item.getId() > 0).map(item -> new ItemStack(item.getId(), item.getQuantity(), this.client.getLocalPlayer().getLocalLocation())).collect(Collectors.toList());
        }
        return items;
    }

    private void AddInventoryItemsToBingoTileItems(ActionDataModel actionData, Collection<ItemStack> inventoryItemCollection) {
        for (ItemStack itemStack : inventoryItemCollection) {
            ActionDataItem actionDataItem = this.actionDataItemMapper.ToActionDataItem(itemStack);
            actionData.items.add(actionDataItem);
        }
    }
}

