/*
 * Decompiled with CFR 0.152.
 */
package com.bingoeventautomated;

import com.bingoeventautomated.Mapper.ActionDataModel;
import com.bingoeventautomated.Mapper.InventoryActionDataModelMapper;
import com.bingoeventautomated.Mapper.NpcActionDataModelMapper;
import com.bingoeventautomated.config.IEventConfig;
import com.bingoeventautomated.events.PlayerEvent;
import com.bingoeventautomated.service.ActionDataModelClient;
import com.bingoeventautomated.service.DynamicConfigClient;
import com.bingoeventautomated.validator.ActionDataItemValidator;
import com.google.inject.Provides;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bingo Event Automated", description="To send bingo items to the server.")
public class BingoEventAutomatedPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BingoEventAutomatedPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ActionDataModelClient actionDataItemClient;
    @Inject
    private DynamicConfigClient dynamicConfigClient;
    @Inject
    private NpcActionDataModelMapper npcActionDataModelMapper;
    @Inject
    private InventoryActionDataModelMapper inventoryActionDataModelMapper;
    @Inject
    private ActionDataItemValidator actionDataItemValidator;
    @Inject
    private PlayerEvent playerEvent;
    @Inject
    private IEventConfig eventconfig;

    @Subscribe
    private void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        String itemsource = npcLootReceived.getNpc().getName();
        if (!this.IsLoggedIn() || !this.IsSupported(itemsource)) {
            return;
        }
        if (this.eventconfig.SendScreenshot()) {
            this.actionDataItemClient.SetScreenshot();
        }
        ActionDataModel unvalidatedActionData = this.npcActionDataModelMapper.ToActionDataModel(npcLootReceived);
        ActionDataModel validatedActionData = this.actionDataItemValidator.validate(unvalidatedActionData);
        this.actionDataItemClient.SendActionDataModel(validatedActionData);
    }

    private boolean IsSupported(String npcName) {
        ArrayList<String> configuration = this.dynamicConfigClient.GetDynamicConfiguration();
        return configuration.contains(npcName) && configuration.size() > 0;
    }

    private boolean IsLoggedIn() {
        return this.client.getGameState() == GameState.LOGGED_IN;
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        if (!this.IsLoggedIn()) {
            return;
        }
        this.playerEvent.UpdateInvalidItemList(event);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        int groupId = widgetLoaded.getGroupId();
        if (!this.IsLoggedIn() || !this.IsSupportedWidget(groupId)) {
            return;
        }
        if (this.eventconfig.SendScreenshot()) {
            this.actionDataItemClient.SetScreenshot();
        }
        ActionDataModel actionData = this.inventoryActionDataModelMapper.Map(groupId);
        this.actionDataItemClient.SendActionDataModel(actionData);
    }

    private boolean IsSupportedWidget(int inventoryId) {
        String inventoryName = this.inventoryActionDataModelMapper.GetInventoryName(inventoryId);
        return inventoryName != "" && this.IsSupported(inventoryName);
    }

    @Provides
    IEventConfig provideConfig(ConfigManager configManager) {
        return (IEventConfig)configManager.getConfig(IEventConfig.class);
    }
}

