/*
 * Decompiled with CFR 0.152.
 */
package com.lamplockout;

import com.google.inject.Provides;
import com.lamplockout.LampLockoutConfig;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Lamp Lockout", description="Remove skill options from lamp interface.", tags={"lamp", "lamps", "xp"})
public class LampLockoutPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LampLockoutPlugin.class);
    static final String CONFIG_GROUP = "Lamp-Lockout";
    static final String ENABLE_ATTACK = "enableAttack";
    static final String ENABLE_DEFENCE = "enableDefence";
    static final String ENABLE_STRENGTH = "enableStrength";
    static final String ENABLE_HITPOINTS = "enableHitpoints";
    static final String ENABLE_RANGED = "enableRanged";
    static final String ENABLE_PRAYER = "enablePrayer";
    static final String ENABLE_MAGIC = "enableMagic";
    static final String ENABLE_COOKING = "enableCooking";
    static final String ENABLE_WOODCUTTING = "enableWoodcutting";
    static final String ENABLE_FLETCHING = "enableFletching";
    static final String ENABLE_FISHING = "enableFishing";
    static final String ENABLE_FIREMAKING = "enableFiremaking";
    static final String ENABLE_CRAFTING = "enableCrafting";
    static final String ENABLE_SMITHING = "enableSmithing";
    static final String ENABLE_MINING = "enableMining";
    static final String ENABLE_HERBLORE = "enableHerblore";
    static final String ENABLE_AGILITY = "enableAgility";
    static final String ENABLE_THIEVING = "enableThieving";
    static final String ENABLE_SLAYER = "enableSlayer";
    static final String ENABLE_FARMING = "enableFarming";
    static final String ENABLE_RUNECRAFT = "enableRunecraft";
    static final String ENABLE_HUNTER = "enableHunter";
    static final String ENABLE_CONSTRUCTION = "enableConstruction";
    private static final int LAMP_WIDGET = 240;
    private static final int LAMP_WIDGET_ID = WidgetInfo.PACK((int)240, (int)0);
    private static final Map<String, Skill> SKILLS = new HashMap<String, Skill>();
    private final Set<Skill> enabledSkills = EnumSet.noneOf(Skill.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private LampLockoutConfig config;

    protected void startUp() {
        log.info("Lamp-Lockout started!");
        this.loadEnabledSkills();
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invoke(this::start);
        }
    }

    protected void shutDown() {
        this.updateInterface(true);
        log.info("Lamp-Lockout stopped!");
    }

    private void start() {
        this.updateInterface();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        boolean enabled = Boolean.TRUE.toString().equals(event.getNewValue());
        switch (event.getKey()) {
            case "enableAttack": {
                this.updateEnabledSkills(enabled, Skill.ATTACK);
                break;
            }
            case "enableDefence": {
                this.updateEnabledSkills(enabled, Skill.DEFENCE);
                break;
            }
            case "enableStrength": {
                this.updateEnabledSkills(enabled, Skill.STRENGTH);
                break;
            }
            case "enableHitpoints": {
                this.updateEnabledSkills(enabled, Skill.HITPOINTS);
                break;
            }
            case "enableRanged": {
                this.updateEnabledSkills(enabled, Skill.RANGED);
                break;
            }
            case "enablePrayer": {
                this.updateEnabledSkills(enabled, Skill.PRAYER);
                break;
            }
            case "enableMagic": {
                this.updateEnabledSkills(enabled, Skill.MAGIC);
                break;
            }
            case "enableCooking": {
                this.updateEnabledSkills(enabled, Skill.COOKING);
                break;
            }
            case "enableWoodcutting": {
                this.updateEnabledSkills(enabled, Skill.WOODCUTTING);
                break;
            }
            case "enableFletching": {
                this.updateEnabledSkills(enabled, Skill.FLETCHING);
                break;
            }
            case "enableFishing": {
                this.updateEnabledSkills(enabled, Skill.FISHING);
                break;
            }
            case "enableFiremaking": {
                this.updateEnabledSkills(enabled, Skill.FIREMAKING);
                break;
            }
            case "enableCrafting": {
                this.updateEnabledSkills(enabled, Skill.CRAFTING);
                break;
            }
            case "enableSmithing": {
                this.updateEnabledSkills(enabled, Skill.SMITHING);
                break;
            }
            case "enableMining": {
                this.updateEnabledSkills(enabled, Skill.MINING);
                break;
            }
            case "enableHerblore": {
                this.updateEnabledSkills(enabled, Skill.HERBLORE);
                break;
            }
            case "enableAgility": {
                this.updateEnabledSkills(enabled, Skill.AGILITY);
                break;
            }
            case "enableThieving": {
                this.updateEnabledSkills(enabled, Skill.THIEVING);
                break;
            }
            case "enableSlayer": {
                this.updateEnabledSkills(enabled, Skill.SLAYER);
                break;
            }
            case "enableFarming": {
                this.updateEnabledSkills(enabled, Skill.FARMING);
                break;
            }
            case "enableRunecraft": {
                this.updateEnabledSkills(enabled, Skill.RUNECRAFT);
                break;
            }
            case "enableHunter": {
                this.updateEnabledSkills(enabled, Skill.HUNTER);
                break;
            }
            case "enableConstruction": {
                this.updateEnabledSkills(enabled, Skill.CONSTRUCTION);
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        int groupID = widgetLoaded.getGroupId();
        if (groupID != 240) {
            return;
        }
        this.updateInterface();
    }

    private void updateInterface() {
        this.updateInterface(false);
    }

    private void updateInterface(boolean showAll) {
        Widget widget = this.client.getWidget(LAMP_WIDGET_ID);
        if (widget == null) {
            return;
        }
        Widget[] children = widget.getStaticChildren();
        if (children == null) {
            return;
        }
        for (Widget child : children) {
            String action;
            Skill skill;
            String[] actions = child.getActions();
            if (actions == null || (skill = SKILLS.get(action = actions[0])) == null) continue;
            child.setHidden(!this.enabledSkills.contains(skill) && !showAll);
        }
    }

    private void updateEnabledSkills(boolean enabled, Skill skill) {
        if (enabled) {
            this.enabledSkills.add(skill);
        } else {
            this.enabledSkills.remove(skill);
        }
        this.updateInterface();
    }

    private void loadEnabledSkills() {
        this.enabledSkills.clear();
        if (this.config.enableAttack()) {
            this.enabledSkills.add(Skill.ATTACK);
        }
        if (this.config.enableDefence()) {
            this.enabledSkills.add(Skill.DEFENCE);
        }
        if (this.config.enableStrength()) {
            this.enabledSkills.add(Skill.STRENGTH);
        }
        if (this.config.enableHitpoints()) {
            this.enabledSkills.add(Skill.HITPOINTS);
        }
        if (this.config.enableRanged()) {
            this.enabledSkills.add(Skill.RANGED);
        }
        if (this.config.enablePrayer()) {
            this.enabledSkills.add(Skill.PRAYER);
        }
        if (this.config.enableMagic()) {
            this.enabledSkills.add(Skill.MAGIC);
        }
        if (this.config.enableCooking()) {
            this.enabledSkills.add(Skill.COOKING);
        }
        if (this.config.enableWoodcutting()) {
            this.enabledSkills.add(Skill.WOODCUTTING);
        }
        if (this.config.enableFletching()) {
            this.enabledSkills.add(Skill.FLETCHING);
        }
        if (this.config.enableFishing()) {
            this.enabledSkills.add(Skill.FISHING);
        }
        if (this.config.enableFiremaking()) {
            this.enabledSkills.add(Skill.FIREMAKING);
        }
        if (this.config.enableCrafting()) {
            this.enabledSkills.add(Skill.CRAFTING);
        }
        if (this.config.enableSmithing()) {
            this.enabledSkills.add(Skill.SMITHING);
        }
        if (this.config.enableMining()) {
            this.enabledSkills.add(Skill.MINING);
        }
        if (this.config.enableHerblore()) {
            this.enabledSkills.add(Skill.HERBLORE);
        }
        if (this.config.enableAgility()) {
            this.enabledSkills.add(Skill.AGILITY);
        }
        if (this.config.enableThieving()) {
            this.enabledSkills.add(Skill.THIEVING);
        }
        if (this.config.enableSlayer()) {
            this.enabledSkills.add(Skill.SLAYER);
        }
        if (this.config.enableFarming()) {
            this.enabledSkills.add(Skill.FARMING);
        }
        if (this.config.enableRunecraft()) {
            this.enabledSkills.add(Skill.RUNECRAFT);
        }
        if (this.config.enableHunter()) {
            this.enabledSkills.add(Skill.HUNTER);
        }
        if (this.config.enableConstruction()) {
            this.enabledSkills.add(Skill.CONSTRUCTION);
        }
    }

    @Provides
    LampLockoutConfig provideConfig(ConfigManager configManager) {
        return (LampLockoutConfig)configManager.getConfig(LampLockoutConfig.class);
    }

    static {
        for (Skill skill : Skill.values()) {
            SKILLS.put(skill.getName(), skill);
        }
    }
}

