/*
 * Decompiled with CFR 0.152.
 */
package com.rohanbansal;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.rohanbansal.ScapeGptClient;
import com.rohanbansal.ScapeGptConfig;
import com.rohanbansal.ScapeGptPanel;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ScapeGPT", loadWhenOutdated=true)
public class ScapeGptPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ScapeGptPlugin.class);
    private static final String HOST = "44.211.86.102";
    private static final String ENDPOINT = "api/v1/query";
    private static final String LOGO = "scapegpt-icon.png";
    private static final int HTTP_TIMEOUT_SECONDS = 45;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ScapeGptConfig config;
    @Inject
    private Gson gson;
    @Inject
    private OkHttpClient httpClient;
    private ScapeGptClient scapeGptClient;
    private ScapeGptPanel panel;
    private NavigationButton navButton;
    private HttpUrl apiUrl;

    protected void startUp() {
        this.apiUrl = new HttpUrl.Builder().scheme("http").host(HOST).addPathSegments(ENDPOINT).build();
        this.scapeGptClient = new ScapeGptClient(this.httpClient.newBuilder().connectTimeout(45L, TimeUnit.SECONDS).readTimeout(45L, TimeUnit.SECONDS).build(), this.apiUrl, this.gson);
        this.panel = (ScapeGptPanel)((Object)this.injector.getInstance(ScapeGptPanel.class));
        this.panel.init(this.scapeGptClient);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)LOGO);
        this.navButton = NavigationButton.builder().tooltip("ScapeGPT").icon(icon).priority(13).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Provides
    ScapeGptConfig provideConfig(ConfigManager configManager) {
        return (ScapeGptConfig)configManager.getConfig(ScapeGptConfig.class);
    }
}

