/*
 * Decompiled with CFR 0.152.
 */
package com.rohanbansal;

import com.rohanbansal.ScapeGptClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScapeGptPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(ScapeGptPanel.class);
    private final JLabel promptInputFieldLabel = new JLabel("<html>Ask ScapeGPT anything! Enter text and press <b>Shift+Enter</b> to submit.<br/><br/>Please keep in mind there is a limit of 20 questions per day, and 3 per minute.<br/><br/></html>");
    private final JTextArea promptInputField = new JTextArea();
    private final JTextArea responseArea = new JTextArea();
    private String prompt = "";
    private ScapeGptClient scapeGptClient;

    ScapeGptPanel() {
    }

    void init(ScapeGptClient client) {
        this.scapeGptClient = client;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.promptInputField.setTabSize(2);
        this.promptInputField.setLineWrap(true);
        this.promptInputField.setWrapStyleWord(true);
        this.promptInputField.setMargin(new Insets(10, 10, 10, 10));
        JScrollPane promptInputScrollPane = new JScrollPane(this.promptInputField);
        promptInputScrollPane.setPreferredSize(new Dimension(this.promptInputField.getPreferredSize().width, 100));
        promptInputScrollPane.setBorder(BorderFactory.createLineBorder(ColorScheme.BRAND_ORANGE));
        this.responseArea.setEditable(false);
        this.responseArea.setLineWrap(true);
        this.responseArea.setWrapStyleWord(true);
        this.responseArea.setMargin(new Insets(10, 10, 10, 10));
        JScrollPane responseScrollPane = new JScrollPane(this.responseArea);
        responseScrollPane.setPreferredSize(new Dimension(this.responseArea.getPreferredSize().width, 400));
        JPanel promptContainer = new JPanel();
        promptContainer.setLayout(new BorderLayout());
        promptContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        promptContainer.setOpaque(false);
        JPanel responseContainer = new JPanel();
        responseContainer.setLayout(new BoxLayout(responseContainer, 1));
        responseContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        responseContainer.add(Box.createVerticalStrut(10));
        responseContainer.setOpaque(false);
        this.addPromptInputFieldEventListeners();
        promptContainer.add((Component)this.promptInputFieldLabel, "North");
        promptContainer.add((Component)promptInputScrollPane, "Center");
        promptContainer.setBorder(new EmptyBorder(10, 10, 10, 10));
        responseContainer.add((Component)responseScrollPane, "North");
        responseContainer.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add(promptContainer, "North");
        this.add(responseContainer, "South");
    }

    private String getTextFromDocument(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    private void addPromptInputFieldEventListeners() {
        this.addPromptInputFieldKeyEventListener();
        this.addPromptInputFieldDocumentListener();
        this.addPromptInputFieldDocumentFilterListener();
    }

    private void addPromptInputFieldKeyEventListener() {
        this.promptInputField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && e.isShiftDown()) {
                    ScapeGptPanel.this.responseArea.setText(ScapeGptPanel.this.scapeGptClient.getResponse(ScapeGptPanel.this.prompt));
                }
            }
        });
    }

    private void addPromptInputFieldDocumentListener() {
        this.promptInputField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ScapeGptPanel.this.prompt = ScapeGptPanel.this.getTextFromDocument(e.getDocument());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ScapeGptPanel.this.prompt = ScapeGptPanel.this.getTextFromDocument(e.getDocument());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    private void addPromptInputFieldDocumentFilterListener() {
        ((AbstractDocument)this.promptInputField.getDocument()).setDocumentFilter(new DocumentFilter(){
            private final int maxLength = 200;

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attrs) throws BadLocationException {
                if (fb.getDocument().getLength() + text.length() <= 200) {
                    super.insertString(fb, offset, text, attrs);
                }
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                super.remove(fb, offset, length);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                if (fb.getDocument().getLength() - length + text.length() <= 200) {
                    super.replace(fb, offset, length, text, attrs);
                }
            }
        });
    }
}

