/*
 * Decompiled with CFR 0.152.
 */
package com.ttl.ui;

import com.ttl.ImgUtils;
import com.ttl.TimeToLevelPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;
import org.apache.commons.lang3.StringUtils;

public class SkillRatePanelHeader
extends JPanel {
    private static final ImageIcon CANCEL_ICON;
    private static final ImageIcon CANCEL_ICON_HOVER;
    private static final ImageIcon CONFIRM_ICON;
    private static final ImageIcon CONFIRM_ICON_HOVER;
    private static final ImageIcon BACK_ICON;
    private static final ImageIcon BACK_ICON_HOVER;

    public SkillRatePanelHeader(String skill, Runnable onBack, Runnable onSave) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(8, 4, 8, 0));
        BufferedImage skillImg = ImgUtils.getSkillImage(skill, true);
        JPanel leftActions = new JPanel(new FlowLayout(0, 4, 0));
        JPanel rightActions = new JPanel(new FlowLayout(2, 4, 0));
        JButton backBtn = new JButton(BACK_ICON);
        backBtn.setRolloverIcon(BACK_ICON_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)backBtn);
        backBtn.addActionListener(e -> onBack.run());
        backBtn.setToolTipText("Back");
        JLabel skillLabel = new JLabel(new ImageIcon(skillImg));
        skillLabel.setToolTipText(StringUtils.capitalize((String)skill));
        leftActions.add(backBtn);
        leftActions.add(skillLabel);
        JButton confirmBtn = new JButton(CONFIRM_ICON);
        confirmBtn.setRolloverIcon(CONFIRM_ICON_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)confirmBtn);
        confirmBtn.setToolTipText("Confirm");
        confirmBtn.addActionListener(e -> onSave.run());
        JButton cancelBtn = new JButton(CANCEL_ICON);
        cancelBtn.setRolloverIcon(CANCEL_ICON_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)cancelBtn);
        cancelBtn.addActionListener(e -> {
            if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you discard changes?", "Discard Changes", 0)) {
                onBack.run();
            }
        });
        cancelBtn.setToolTipText("Cancel");
        rightActions.add((Component)confirmBtn, "East");
        rightActions.add((Component)cancelBtn, "West");
        this.add((Component)leftActions, "West");
        this.add((Component)rightActions, "East");
    }

    static {
        BufferedImage cancelIcon = ImageUtil.getResourceStreamFromClass(TimeToLevelPlugin.class, (String)"/cancel_icon.png");
        CANCEL_ICON = new ImageIcon(cancelIcon);
        CANCEL_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)cancelIcon, (float)0.53f));
        BufferedImage confirmIcon = ImageUtil.getResourceStreamFromClass(TimeToLevelPlugin.class, (String)"/confirm_icon.png");
        CONFIRM_ICON = new ImageIcon(confirmIcon);
        CONFIRM_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)confirmIcon, (float)0.53f));
        BufferedImage backIcon = ImageUtil.getResourceStreamFromClass(TimeToLevelPlugin.class, (String)"/back_icon.png");
        BACK_ICON = new ImageIcon(backIcon);
        BACK_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)backIcon, (float)0.53f));
    }
}

