/*
 * Decompiled with CFR 0.152.
 */
package com.ttl.ui;

import com.ttl.RateMethod;
import com.ttl.Rates;
import com.ttl.TimeToLevelPlugin;
import com.ttl.ui.SkillRateBox;
import com.ttl.ui.SkillRatePanelHeader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Skill;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

public class SkillRatePanel
extends JPanel {
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_ICON_HOVER;
    private final TimeToLevelPlugin plugin;
    private final JPanel ratesListPanel = new JPanel(new BorderLayout());
    private Rates rates;
    private final JScrollPane scroller;
    private boolean scrollBottom = false;
    private final Runnable onBack;

    public SkillRatePanel(TimeToLevelPlugin plugin, Rates rates, Runnable onBack) {
        this.plugin = plugin;
        this.rates = rates;
        this.onBack = onBack;
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)new SkillRatePanelHeader(rates.getSkill(), onBack, this::saveRates), "North");
        JButton addButton = new JButton(ADD_ICON);
        addButton.setRolloverIcon(ADD_ICON_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)addButton);
        addButton.setToolTipText("Add rate");
        JButton resetBtn = new JButton("Reset rates");
        resetBtn.setFocusPainted(false);
        resetBtn.addActionListener(l -> this.resetRates());
        JPanel wrappedBtb = new JPanel(new BorderLayout());
        wrappedBtb.add((Component)addButton, "East");
        wrappedBtb.add((Component)resetBtn, "West");
        wrappedBtb.setBorder(new EmptyBorder(8, 8, 8, 0));
        this.ratesListPanel.setBorder(new EmptyBorder(0, 8, 0, 8));
        JPanel wrapped = new JPanel(new BorderLayout());
        wrapped.add((Component)this.ratesListPanel, "North");
        this.scroller = new JScrollPane(wrapped);
        this.scroller.setHorizontalScrollBarPolicy(31);
        addButton.addActionListener(e -> {
            this.addInfo();
            this.scrollBottom = true;
        });
        this.add((Component)northPanel, "North");
        this.add((Component)this.scroller, "Center");
        this.add((Component)wrappedBtb, "South");
        this.update();
    }

    private void resetRates() {
        Skill skill = this.rates.getRSSkill();
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you reset custom XP rates?", "Reset Confirmation", 0)) {
            this.rates = this.plugin.resetRates(skill);
            this.update();
        }
    }

    public void update() {
        SwingUtilities.invokeLater(this::updatePanel);
    }

    private void updatePanel() {
        this.ratesListPanel.removeAll();
        this.ratesListPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.rates.getMethods().sort(Comparator.comparingInt(RateMethod::getLevel));
        for (RateMethod info : this.rates.getMethods()) {
            SkillRateBox srb = new SkillRateBox(info, () -> this.removeInfo(info));
            this.ratesListPanel.add((Component)srb, constraints);
            ++constraints.gridy;
            this.ratesListPanel.add(Box.createRigidArea(new Dimension(0, 16)), constraints);
            ++constraints.gridy;
        }
        this.repaint();
        this.revalidate();
        if (this.scrollBottom) {
            SwingUtilities.invokeLater(() -> {
                this.scroller.getVerticalScrollBar().setValue(this.scroller.getVerticalScrollBar().getMaximum());
                this.scrollBottom = false;
            });
        }
    }

    private void addInfo() {
        this.rates.getMethods().add(new RateMethod(99, 0, null));
        this.update();
    }

    private void removeInfo(RateMethod info) {
        this.rates.getMethods().remove(info);
        this.update();
    }

    private void saveRates() {
        this.plugin.saveRates(this.rates);
        this.onBack.run();
    }

    static {
        BufferedImage addIcon = ImageUtil.getResourceStreamFromClass(TimeToLevelPlugin.class, (String)"/add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, (float)0.53f));
    }
}

