/*
 * Decompiled with CFR 0.152.
 */
package com.ttl.ui;

import com.ttl.RateMethod;
import com.ttl.TimeToLevelPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.NumberFormatter;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkillRateBox
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(SkillRateBox.class);
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_ICON_HOVER;

    public SkillRateBox(final RateMethod rates, Runnable onDelete) {
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setLayout(new BorderLayout(0, 2));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        JPanel top = new JPanel(new BorderLayout());
        JPanel lvlCnts = new JPanel(new FlowLayout(0, 2, 0));
        NumberFormatter lvlFmt = new NumberFormatter(NumberFormat.getIntegerInstance());
        lvlFmt.setValueClass(Integer.class);
        lvlFmt.setAllowsInvalid(false);
        lvlFmt.setMinimum(Integer.valueOf(1));
        lvlFmt.setCommitsOnValidEdit(true);
        lvlFmt.setMaximum(Integer.valueOf(99));
        final JFormattedTextField lvlTxt = new JFormattedTextField(lvlFmt);
        lvlTxt.setColumns(2);
        lvlTxt.setValue(rates.getLevel());
        lvlCnts.add(new JLabel("Lvl: "));
        lvlCnts.add(lvlTxt);
        JPanel xpCnts = new JPanel(new FlowLayout(1, 2, 0));
        NumberFormatter xpFmt = new NumberFormatter(NumberFormat.getIntegerInstance());
        xpFmt.setValueClass(Integer.class);
        xpFmt.setAllowsInvalid(false);
        xpFmt.setCommitsOnValidEdit(true);
        xpFmt.setMinimum(Integer.valueOf(0));
        xpFmt.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        final JFormattedTextField xpRateTxt = new JFormattedTextField(xpFmt);
        xpRateTxt.setValue(rates.getRate());
        xpRateTxt.setColumns(7);
        xpCnts.add(xpRateTxt);
        xpCnts.add(new JLabel("xp/hr"));
        JButton deleteBtn = new JButton(DELETE_ICON);
        deleteBtn.setRolloverIcon(DELETE_ICON_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)deleteBtn);
        deleteBtn.addActionListener(e -> onDelete.run());
        deleteBtn.setToolTipText("Delete rate");
        deleteBtn.setPreferredSize(new Dimension(16, 0));
        top.add((Component)lvlCnts, "West");
        top.add((Component)xpCnts, "Center");
        top.add((Component)deleteBtn, "East");
        final JTextField methodTxt = new JTextField(rates.getMethod());
        if (rates.getMethod() == null) {
            methodTxt.setText("method description");
        }
        this.add((Component)top, "North");
        this.add((Component)methodTxt, "South");
        lvlTxt.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                rates.setLevel((Integer)lvlTxt.getValue());
            }
        });
        xpRateTxt.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                rates.setRate((Integer)xpRateTxt.getValue());
            }
        });
        methodTxt.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                rates.setMethod(methodTxt.getText());
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(1, super.getPreferredSize().height);
    }

    static {
        BufferedImage deleteIcon = ImageUtil.getResourceStreamFromClass(TimeToLevelPlugin.class, (String)"/delete_icon.png");
        DELETE_ICON = new ImageIcon(deleteIcon);
        DELETE_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)deleteIcon, (float)0.53f));
    }
}

