/*
 * Decompiled with CFR 0.152.
 */
package com.ttl.ui;

import com.ttl.ImgUtils;
import com.ttl.TimeToLevelPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Skill;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

public class RatesConfigPanel
extends JPanel {
    private static final ImageIcon BACK_ICON;
    private static final ImageIcon BACK_ICON_HOVER;
    private final JPanel skillsPanel = new JPanel(new GridLayout(8, 3, 8, 16));
    private final TimeToLevelPlugin plugin;
    private static final Skill[] SKILLS;

    public RatesConfigPanel(TimeToLevelPlugin plugin, Runnable back, Consumer<Skill> showSkillRates) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.plugin = plugin;
        JPanel northPanel = new JPanel(new BorderLayout());
        JButton backBtn = new JButton(BACK_ICON);
        backBtn.setRolloverIcon(BACK_ICON_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)backBtn);
        backBtn.setToolTipText("Back");
        backBtn.addActionListener(l -> back.run());
        northPanel.add((Component)backBtn, "West");
        JPanel wrapper = new JPanel(new BorderLayout());
        this.skillsPanel.setBorder(new EmptyBorder(16, 8, 16, 8));
        this.skillsPanel.setBackground(ColorScheme.MEDIUM_GRAY_COLOR.darker());
        wrapper.add((Component)this.skillsPanel, "North");
        JButton resetBtn = new JButton("Reset all rates");
        resetBtn.addActionListener(l -> {
            if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you reset ALL custom XP rates?", "Reset Confirmation", 0)) {
                plugin.resetRates();
            }
        });
        JPanel buttons = new JPanel(new BorderLayout(4, 4));
        JPanel importExport = new JPanel(new GridLayout(1, 2, 8, 8));
        JButton imBtn = new JButton("Import rates");
        JButton exBtn = new JButton("Export rates");
        imBtn.addActionListener(l -> this.importRates());
        exBtn.addActionListener(l -> this.exportRates());
        exBtn.setFocusPainted(false);
        imBtn.setFocusPainted(false);
        resetBtn.setFocusPainted(false);
        buttons.add((Component)resetBtn, "South");
        importExport.add(imBtn);
        importExport.add(exBtn);
        buttons.add((Component)importExport, "North");
        buttons.add((Component)resetBtn, "South");
        this.add((Component)northPanel, "North");
        this.add((Component)wrapper, "Center");
        this.add((Component)buttons, "South");
        this.addSkills(showSkillRates);
    }

    private void importRates() {
        try {
            String rates = JOptionPane.showInputDialog(this, "Enter rates data", "Import New Rates", -1);
            if (rates == null) {
                return;
            }
            boolean success = this.plugin.setRatesConfig(rates);
            if (!success) {
                throw new Exception("failed to import rates");
            }
            JOptionPane.showMessageDialog(this, "Skill rates were successfully imported.", "Import Succeeded", -1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid rates data.", "Import Rates Failed", 0);
        }
    }

    private void exportRates() {
        StringSelection contents = new StringSelection(this.plugin.getRatesConfig());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
        JOptionPane.showMessageDialog(this, "Skill rates was copied to clipboard.", "Export Succeeded", -1);
    }

    private void addSkills(final Consumer<Skill> showSkillRates) {
        this.skillsPanel.removeAll();
        for (final Skill skill : SKILLS) {
            JLabel img = new JLabel(new ImageIcon(ImgUtils.getSkillImage(skill, false)));
            img.setToolTipText(skill.getName());
            img.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    showSkillRates.accept(skill);
                }
            });
            this.skillsPanel.add(img);
        }
    }

    static {
        BufferedImage backIcon = ImageUtil.getResourceStreamFromClass(TimeToLevelPlugin.class, (String)"/back_icon.png");
        BACK_ICON = new ImageIcon(backIcon);
        BACK_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)backIcon, (float)0.53f));
        SKILLS = new Skill[]{Skill.ATTACK, Skill.HITPOINTS, Skill.MINING, Skill.STRENGTH, Skill.AGILITY, Skill.SMITHING, Skill.DEFENCE, Skill.HERBLORE, Skill.FISHING, Skill.RANGED, Skill.THIEVING, Skill.COOKING, Skill.PRAYER, Skill.CRAFTING, Skill.FIREMAKING, Skill.MAGIC, Skill.FLETCHING, Skill.WOODCUTTING, Skill.RUNECRAFT, Skill.SLAYER, Skill.FARMING, Skill.CONSTRUCTION, Skill.HUNTER};
    }
}

