/*
 * Decompiled with CFR 0.152.
 */
package com.ttl.ui;

import com.ttl.RateTTL;
import com.ttl.TimeToLevelConfig;
import com.ttl.TimeToLevelPlugin;
import com.ttl.ui.LevelsListPanel;
import com.ttl.ui.RatesConfigPanel;
import com.ttl.ui.SkillRatePanel;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Skill;
import net.runelite.client.ui.PluginPanel;

public class LevelsPanel
extends PluginPanel {
    private final LevelsListPanel levelsListPanel;
    private final RatesConfigPanel ratesConfigPanel;
    private final TimeToLevelPlugin plugin;

    public LevelsPanel(TimeToLevelPlugin plugin, TimeToLevelConfig config) {
        super(false);
        this.plugin = plugin;
        this.levelsListPanel = new LevelsListPanel(plugin, config, skill -> this.showSkillRates((Skill)skill, true), this::showRatesConfig);
        this.ratesConfigPanel = new RatesConfigPanel(plugin, () -> this.showList(true), skill -> this.showSkillRates((Skill)skill, false));
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.showList(true);
    }

    public void update(List<RateTTL> ttls) {
        this.levelsListPanel.update(ttls);
    }

    public void showList(boolean levelsList) {
        this.removeAll();
        if (levelsList) {
            this.add(this.levelsListPanel, "Center");
        } else {
            this.add(this.ratesConfigPanel, "Center");
        }
        this.repaint();
        this.revalidate();
    }

    public void showSkillRates(Skill skill, boolean levelsList) {
        this.removeAll();
        this.add(new SkillRatePanel(this.plugin, this.plugin.getRates(skill), () -> this.showList(levelsList)));
        this.repaint();
        this.revalidate();
    }

    public void showRatesConfig() {
        this.removeAll();
        this.add(this.ratesConfigPanel);
        this.repaint();
        this.revalidate();
    }
}

