/*
 * Decompiled with CFR 0.152.
 */
package com.ttl.ui;

import com.ttl.TimeToLevelPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.SwingUtil;

public class LevelsListPanelHeader
extends JPanel {
    private static final ImageIcon REFRESH_ICON;
    private static final ImageIcon REFRESH_ICON_HOVER;
    private static final ImageIcon HELP_ICON;
    private static final ImageIcon HELP_ICON_HOVER;
    private static final ImageIcon CONFIG_ICON;
    private static final ImageIcon CONFIG_ICON_HOVER;

    public LevelsListPanelHeader(Runnable onRefresh, Runnable showRatesConfig) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(8, 16, 8, 8));
        JButton refreshBtn = new JButton(REFRESH_ICON);
        refreshBtn.setRolloverIcon(REFRESH_ICON_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)refreshBtn);
        refreshBtn.setToolTipText("Refresh");
        refreshBtn.addActionListener(e -> onRefresh.run());
        JButton helpBtn = new JButton(HELP_ICON);
        helpBtn.setRolloverIcon(HELP_ICON_HOVER);
        SwingUtil.removeButtonDecorations((AbstractButton)helpBtn);
        helpBtn.setToolTipText("Help");
        helpBtn.addActionListener(e -> LinkBrowser.browse((String)"https://github.com/while-loop/runelite-plugins/tree/ttl#time-to-level"));
        JLabel title = new JLabel("Time to Level");
        title.setForeground(Color.WHITE);
        JButton configBtn = new JButton(CONFIG_ICON);
        SwingUtil.removeButtonDecorations((AbstractButton)configBtn);
        configBtn.setRolloverIcon(CONFIG_ICON_HOVER);
        configBtn.setToolTipText("Edit XP Rates");
        configBtn.addActionListener(e -> showRatesConfig.run());
        JPanel leftActions = new JPanel(new FlowLayout(0, 4, 0));
        leftActions.add(title);
        leftActions.add(helpBtn);
        JPanel rightActions = new JPanel(new FlowLayout(2, 0, 0));
        rightActions.add(configBtn);
        rightActions.add(refreshBtn);
        this.add((Component)leftActions, "West");
        this.add((Component)rightActions, "East");
    }

    static {
        BufferedImage refreshIcon = ImageUtil.getResourceStreamFromClass(TimeToLevelPlugin.class, (String)"/refresh_icon.png");
        REFRESH_ICON = new ImageIcon(refreshIcon);
        REFRESH_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)refreshIcon, (float)0.53f));
        BufferedImage helpIcon = ImageUtil.getResourceStreamFromClass(TimeToLevelPlugin.class, (String)"/help_icon.png");
        HELP_ICON = new ImageIcon(helpIcon);
        HELP_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)helpIcon, (float)0.53f));
        BufferedImage configIcon = ImageUtil.getResourceStreamFromClass(TimeToLevelPlugin.class, (String)"/config_icon.png");
        CONFIG_ICON = new ImageIcon(configIcon);
        CONFIG_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)configIcon, (float)0.53f));
    }
}

