/*
 * Decompiled with CFR 0.152.
 */
package com.ttl.ui;

import com.ttl.RateTTL;
import com.ttl.TimeToLevelConfig;
import com.ttl.TimeToLevelPlugin;
import com.ttl.ui.LevelsListCalcBox;
import com.ttl.ui.LevelsListHeader;
import com.ttl.ui.LevelsListPanelHeader;
import com.ttl.ui.SortOrder;
import com.ttl.ui.ToggleButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Skill;
import net.runelite.client.util.SwingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelsListPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(LevelsListPanel.class);
    static final int SKILL_COLUMN_WIDTH = 39;
    static final int SKILL_COLUMN_HEIGHT = 25;
    static final int LEVEL_COLUMN_WIDTH = 35;
    static final int XP_COLUMN_WIDTH = 57;
    static final int XP_RATE_COLUMN_WIDTH = 52;
    static final int TTL_COLUMN_WIDTH = 59;
    private final JPanel ratesListPanel = new JPanel();
    private final LevelsListHeader ratesHeaders;
    private List<RateTTL> ttls = new ArrayList<RateTTL>();
    private final Consumer<Skill> showSkillListener;
    private final Filters filters;

    public LevelsListPanel(TimeToLevelPlugin plugin, TimeToLevelConfig config, Consumer<Skill> showSkillListener, Runnable showRatesConfig) {
        this.showSkillListener = showSkillListener;
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        this.ratesHeaders = new LevelsListHeader(this, this::onSortChanged);
        this.filters = new Filters(config, this::updatePanel);
        northPanel.add((Component)new LevelsListPanelHeader(plugin::recalculate, showRatesConfig), "North");
        northPanel.add((Component)this.filters, "Center");
        northPanel.add((Component)this.ratesHeaders, "South");
        JPanel wrapped = new JPanel(new BorderLayout());
        wrapped.add((Component)this.ratesListPanel, "North");
        JScrollPane scroller = new JScrollPane(wrapped);
        scroller.setHorizontalScrollBarPolicy(31);
        this.add((Component)northPanel, "North");
        this.add((Component)scroller, "Center");
    }

    private void onSortChanged() {
        this.update(this.ttls);
    }

    private List<RateTTL> sortTTLs(List<RateTTL> ts) {
        SortOrder sortOrder = this.ratesHeaders.getSort();
        Comparator<RateTTL> comp = sortOrder.comparator;
        if (!sortOrder.asc) {
            comp = comp.reversed();
        }
        ts.sort(comp);
        return ts;
    }

    public void update(List<RateTTL> ttls) {
        this.ttls = this.sortTTLs(ttls);
        SwingUtilities.invokeLater(this::updatePanel);
    }

    private void updatePanel() {
        this.ratesListPanel.removeAll();
        this.ratesListPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        List<Skill> vis = this.filters.getVisibleSkills();
        List shown = this.ttls.stream().filter(rc -> vis.contains(rc.getSkill())).collect(Collectors.toList());
        for (int i = 0; i < shown.size(); ++i) {
            RateTTL calc = (RateTTL)shown.get(i);
            LevelsListCalcBox llcb = new LevelsListCalcBox(calc, () -> this.showSkillListener.accept(calc.getSkill()), i % 2 == 1);
            this.ratesListPanel.add((Component)llcb, constraints);
            ++constraints.gridy;
        }
        this.repaint();
        this.revalidate();
    }

    private static class Filters
    extends JPanel {
        private final TimeToLevelConfig config;
        private final JCheckBox cmb;
        private final JCheckBox art;
        private final JCheckBox gath;
        private final JCheckBox supp;
        private final JToggleButton buy;

        private Filters(TimeToLevelConfig config, Runnable refresh) {
            this.config = config;
            this.setBorder(new EmptyBorder(0, 0, 8, 0));
            this.setLayout(new GridLayout(3, 2, 2, 4));
            int height = 18;
            this.cmb = new JCheckBox("Combat", true);
            SwingUtil.removeButtonDecorations((AbstractButton)this.cmb);
            this.cmb.setToolTipText(TimeToLevelPlugin.COMBAT_SKILLS.stream().map(Skill::getName).collect(Collectors.joining(",")));
            this.cmb.addActionListener(l -> refresh.run());
            this.cmb.setHorizontalAlignment(0);
            this.cmb.setPreferredSize(new Dimension(this.cmb.getPreferredSize().width, 18));
            this.art = new JCheckBox("Artisan", true);
            SwingUtil.removeButtonDecorations((AbstractButton)this.art);
            this.art.setToolTipText(TimeToLevelPlugin.ARTISAN_SKILLS.stream().map(Skill::getName).collect(Collectors.joining(",")));
            this.art.addActionListener(l -> refresh.run());
            this.art.setHorizontalAlignment(0);
            this.art.setPreferredSize(new Dimension(this.cmb.getPreferredSize().width, 18));
            this.gath = new JCheckBox("Gathering", true);
            SwingUtil.removeButtonDecorations((AbstractButton)this.gath);
            this.gath.setToolTipText(TimeToLevelPlugin.GATHERING_SKILLS.stream().map(Skill::getName).collect(Collectors.joining(",")));
            this.gath.addActionListener(l -> refresh.run());
            this.gath.setHorizontalAlignment(0);
            this.gath.setPreferredSize(new Dimension(this.cmb.getPreferredSize().width, 18));
            this.supp = new JCheckBox("Support", true);
            SwingUtil.removeButtonDecorations((AbstractButton)this.supp);
            this.supp.setToolTipText(TimeToLevelPlugin.SUPPORT_SKILLS.stream().map(Skill::getName).collect(Collectors.joining(",")));
            this.supp.addActionListener(l -> refresh.run());
            this.supp.setHorizontalAlignment(0);
            this.supp.setPreferredSize(new Dimension(this.cmb.getPreferredSize().width, 18));
            this.buy = new ToggleButton("Buyables", true);
            this.buy.setFocusPainted(false);
            this.buy.setToolTipText(this.getBuyables().stream().map(Skill::getName).collect(Collectors.joining(",")));
            this.buy.addActionListener(l -> refresh.run());
            this.buy.setHorizontalAlignment(0);
            this.buy.setPreferredSize(new Dimension(this.cmb.getPreferredSize().width, 18));
            this.add(this.cmb);
            this.add(this.art);
            this.add(this.supp);
            this.add(this.gath);
            this.add(this.buy);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(1, super.getPreferredSize().height);
        }

        private List<Skill> getVisibleSkills() {
            ArrayList<Skill> vis = new ArrayList<Skill>();
            if (this.cmb.isSelected()) {
                vis.addAll(TimeToLevelPlugin.COMBAT_SKILLS);
            }
            if (this.art.isSelected()) {
                vis.addAll(TimeToLevelPlugin.ARTISAN_SKILLS);
            }
            if (this.gath.isSelected()) {
                vis.addAll(TimeToLevelPlugin.GATHERING_SKILLS);
            }
            if (this.supp.isSelected()) {
                vis.addAll(TimeToLevelPlugin.SUPPORT_SKILLS);
            }
            if (!this.buy.isSelected()) {
                vis.removeAll(this.getBuyables());
            }
            return vis;
        }

        private List<Skill> getBuyables() {
            ArrayList<Skill> buyables = new ArrayList<Skill>();
            for (String s : this.config.buyableSkills().split(",")) {
                if ((s = s.trim()).isEmpty()) continue;
                try {
                    buyables.add(Skill.valueOf((String)s.toUpperCase()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return buyables;
        }
    }
}

