/*
 * Decompiled with CFR 0.152.
 */
package com.ttl.ui;

import com.ttl.TimeToLevelPlugin;
import com.ttl.ui.LevelsListPanel;
import com.ttl.ui.SortOrder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelsListHeader
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(LevelsListHeader.class);
    private static final ImageIcon ARROW_UP;
    private static final ImageIcon HIGHLIGHT_ARROW_DOWN;
    private static final ImageIcon HIGHLIGHT_ARROW_UP;
    private static final Color ARROW_COLOR;
    private static final Color HIGHLIGHT_COLOR;
    private final Map<SortOrder, JLabel> lables = new HashMap<SortOrder, JLabel>();
    private final Map<SortOrder, JLabel> arrows = new HashMap<SortOrder, JLabel>();
    private SortOrder sortOrder = SortOrder.TTL;
    private final Runnable onSort;

    public LevelsListHeader(LevelsListPanel list, Runnable onSort) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.onSort = onSort;
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        leftSide.setOpaque(true);
        rightSide.setOpaque(true);
        leftSide.add((Component)this.buildHeader("Skill", SortOrder.SKILL, 39), "West");
        leftSide.add((Component)this.buildHeader("Lvl", SortOrder.LEVEL, 35), "East");
        rightSide.add((Component)this.buildHeader("XP Left", SortOrder.XP, 57), "West");
        rightSide.add((Component)this.buildHeader("XP/Hr", SortOrder.RATE, 52), "Center");
        rightSide.add((Component)this.buildHeader("TTL", SortOrder.TTL, 59), "East");
        this.add((Component)leftSide, "West");
        this.add((Component)rightSide, "East");
        SwingUtilities.invokeLater(this::setHighlights);
    }

    private JPanel buildHeader(String name, final SortOrder so, int x) {
        JPanel column = new JPanel(new BorderLayout());
        column.setBackground(ColorScheme.SCROLL_TRACK_COLOR);
        column.setPreferredSize(new Dimension(x, 18));
        column.setBorder(new EmptyBorder(0, 1, 0, 1));
        final JLabel label = new JLabel(name);
        label.setFont(FontManager.getRunescapeSmallFont());
        final JLabel arrowLabel = new JLabel();
        arrowLabel.setIcon(ARROW_UP);
        column.add((Component)label, "West");
        column.add((Component)arrowLabel, "East");
        column.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (so == LevelsListHeader.this.sortOrder) {
                    LevelsListHeader.this.sortOrder.toggleAsc();
                } else {
                    LevelsListHeader.this.sortOrder = so;
                }
                LevelsListHeader.this.setHighlights();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setForeground(HIGHLIGHT_COLOR);
                if (so != LevelsListHeader.this.sortOrder) {
                    arrowLabel.setIcon(HIGHLIGHT_ARROW_UP);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (so != LevelsListHeader.this.sortOrder) {
                    label.setForeground(ARROW_COLOR);
                    arrowLabel.setIcon(ARROW_UP);
                }
            }
        });
        this.lables.put(so, label);
        this.arrows.put(so, arrowLabel);
        return column;
    }

    private void setHighlights() {
        this.onSort.run();
        for (Map.Entry<SortOrder, JLabel> e : this.lables.entrySet()) {
            SortOrder so = e.getKey();
            if (so == this.sortOrder) {
                e.getValue().setForeground(HIGHLIGHT_COLOR);
                if (this.sortOrder.asc) {
                    this.arrows.get((Object)so).setIcon(HIGHLIGHT_ARROW_UP);
                    continue;
                }
                this.arrows.get((Object)so).setIcon(HIGHLIGHT_ARROW_DOWN);
                continue;
            }
            e.getValue().setForeground(ARROW_COLOR);
            this.arrows.get((Object)so).setIcon(ARROW_UP);
        }
    }

    public SortOrder getSort() {
        return this.sortOrder;
    }

    static {
        ARROW_COLOR = ColorScheme.LIGHT_GRAY_COLOR;
        HIGHLIGHT_COLOR = ColorScheme.BRAND_ORANGE;
        BufferedImage arrowDown = ImageUtil.getResourceStreamFromClass(TimeToLevelPlugin.class, (String)"/arrow_down.png");
        BufferedImage arrowUp = ImageUtil.rotateImage((BufferedImage)arrowDown, (double)Math.PI);
        BufferedImage arrowUpFaded = ImageUtil.luminanceOffset((Image)arrowUp, (int)-80);
        ARROW_UP = new ImageIcon(arrowUpFaded);
        BufferedImage highlightArrowDown = ImageUtil.fillImage((BufferedImage)arrowDown, (Color)HIGHLIGHT_COLOR);
        BufferedImage highlightArrowUp = ImageUtil.fillImage((BufferedImage)arrowUp, (Color)HIGHLIGHT_COLOR);
        HIGHLIGHT_ARROW_DOWN = new ImageIcon(highlightArrowDown);
        HIGHLIGHT_ARROW_UP = new ImageIcon(highlightArrowUp);
    }
}

