/*
 * Decompiled with CFR 0.152.
 */
package com.ttl.ui;

import com.ttl.ImgUtils;
import com.ttl.RateTTL;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelsListCalcBox
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(LevelsListCalcBox.class);
    private static final Color ODD_ROW = new Color(44, 44, 44);
    private final RateTTL calc;

    public LevelsListCalcBox(RateTTL calc, final Runnable onClick, final boolean odd) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.setBackground(odd ? ODD_ROW : ColorScheme.DARK_GRAY_COLOR);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseExited(e);
                onClick.run();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LevelsListCalcBox.this.setBackground(LevelsListCalcBox.this.getBackground().darker());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LevelsListCalcBox.this.setBackground(odd ? ODD_ROW : ColorScheme.DARK_GRAY_COLOR);
            }
        });
        this.calc = calc;
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        leftSide.setOpaque(false);
        rightSide.setOpaque(false);
        leftSide.add((Component)this.buildSkillImage(), "West");
        leftSide.add((Component)this.buildLevelLabel(), "East");
        rightSide.add((Component)this.buildXpLabel(), "West");
        rightSide.add((Component)this.buildRateLabel(), "Center");
        rightSide.add((Component)this.buildTtlLabel(), "East");
        this.setToolTipText(calc.toolTip());
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem view = new JMenuItem("View skill xp rates");
        view.addActionListener(e -> onClick.run());
        popupMenu.add(view);
        this.setComponentPopupMenu(popupMenu);
        this.add((Component)leftSide, "West");
        this.add((Component)rightSide, "East");
    }

    private JPanel buildTtlLabel() {
        JPanel column = new JPanel(new BorderLayout());
        JLabel label = new JLabel(this.calc.ttl());
        column.add((Component)label, "East");
        column.setBorder(new EmptyBorder(0, 0, 0, 9));
        column.setOpaque(false);
        column.setPreferredSize(new Dimension(59, 0));
        return column;
    }

    private JPanel buildRateLabel() {
        JPanel column = new JPanel(new BorderLayout());
        JLabel label = new JLabel(QuantityFormatter.quantityToRSDecimalStack((int)this.calc.getXpRate()));
        column.add((Component)label, "West");
        column.setOpaque(false);
        column.setPreferredSize(new Dimension(52, 0));
        return column;
    }

    private JPanel buildXpLabel() {
        JPanel column = new JPanel(new BorderLayout());
        JLabel label = new JLabel(QuantityFormatter.quantityToRSDecimalStack((int)this.calc.getXpLeft()));
        column.add((Component)label, "West");
        column.setOpaque(false);
        column.setPreferredSize(new Dimension(57, 0));
        return column;
    }

    private JPanel buildLevelLabel() {
        JPanel column = new JPanel(new BorderLayout());
        JLabel label = new JLabel(String.valueOf(this.calc.getLevel()));
        column.add((Component)label, "Center");
        column.setOpaque(false);
        column.setPreferredSize(new Dimension(35, 0));
        return column;
    }

    private JPanel buildSkillImage() {
        JPanel column = new JPanel(new BorderLayout());
        JLabel label = new JLabel(new ImageIcon(ImgUtils.getSkillImage(this.calc.getSkill(), true)));
        column.add((Component)label, "Center");
        column.setPreferredSize(new Dimension(39, 25));
        column.setOpaque(false);
        return column;
    }
}

