/*
 * Decompiled with CFR 0.152.
 */
package com.ttl;

import com.google.inject.Provides;
import com.ttl.RateMethod;
import com.ttl.RateTTL;
import com.ttl.Rates;
import com.ttl.RatesManager;
import com.ttl.TimeToLevelConfig;
import com.ttl.ui.LevelsPanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Skill;
import net.runelite.api.events.StatChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Time to Level", description="Panel to show how long until you get dopamine fireworks. /s", tags={"xp", "track", "ttl", "skill", "level"})
public class TimeToLevelPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TimeToLevelPlugin.class);
    @Inject
    private Client client;
    @Inject
    private TimeToLevelConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private RatesManager ratesManager;
    private LevelsPanel panel;
    private NavigationButton navButton;
    public static final List<Skill> COMBAT_SKILLS = Arrays.asList(Skill.ATTACK, Skill.STRENGTH, Skill.DEFENCE, Skill.MAGIC, Skill.RANGED, Skill.PRAYER, Skill.HITPOINTS);
    public static final List<Skill> GATHERING_SKILLS = Arrays.asList(Skill.MINING, Skill.FISHING, Skill.WOODCUTTING, Skill.HUNTER, Skill.FARMING);
    public static final List<Skill> ARTISAN_SKILLS = Arrays.asList(Skill.COOKING, Skill.SMITHING, Skill.FLETCHING, Skill.FIREMAKING, Skill.HERBLORE, Skill.CRAFTING, Skill.RUNECRAFT, Skill.CONSTRUCTION);
    public static final List<Skill> SUPPORT_SKILLS = Arrays.asList(Skill.AGILITY, Skill.THIEVING, Skill.SLAYER);

    protected void startUp() {
        this.panel = new LevelsPanel(this, this.config);
        this.navButton = NavigationButton.builder().tooltip("Time to Level").icon(ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/icon.png")).priority(50).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        this.recalculate();
    }

    @Provides
    TimeToLevelConfig provideConfig(ConfigManager configManager) {
        return (TimeToLevelConfig)configManager.getConfig(TimeToLevelConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("timetolevel")) {
            return;
        }
        this.recalculate();
    }

    public List<RateTTL> getTTLs() {
        ArrayList<RateTTL> ttls = new ArrayList<RateTTL>();
        for (Rates e : this.ratesManager.getRates()) {
            Skill skill = Skill.valueOf((String)e.getSkill().toUpperCase());
            int xp = this.client.getSkillExperience(skill);
            int level = Experience.getLevelForXp((int)xp);
            if (level >= 99 && !this.config.virtualLevels()) continue;
            int xpLeft = Experience.getXpForLevel((int)(level + 1)) - this.client.getSkillExperience(skill);
            RateMethod rate = null;
            for (RateMethod rateMethod : e.getMethods()) {
                if (rateMethod.level > level) break;
                rate = rateMethod;
            }
            if (rate == null || rate.rate <= 0) continue;
            double secondsLeft = (double)xpLeft / ((double)rate.rate / 3600.0);
            ttls.add(new RateTTL(skill, level, xpLeft, rate.getRate(), (int)secondsLeft, rate));
        }
        return ttls;
    }

    public void recalculate() {
        this.panel.update(this.getTTLs());
    }

    public void saveRates(Rates r) {
        this.ratesManager.saveRates(r);
        this.recalculate();
    }

    public Rates getRates(Skill skill) {
        return this.ratesManager.getRates(skill);
    }

    public void resetRates() {
        this.ratesManager.resetRates();
        this.recalculate();
    }

    public String getRatesConfig() {
        return this.ratesManager.getRatesConfig();
    }

    public boolean setRatesConfig(String rates) {
        boolean success = this.ratesManager.setRatesConfig(rates);
        if (success) {
            this.recalculate();
        }
        return success;
    }

    public Rates resetRates(Skill skill) {
        Rates r = this.ratesManager.resetRates(skill);
        this.recalculate();
        return r;
    }
}

